/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.event;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;

@EventType(deliveryMode=1)
@XmlRootElement
public class InetAccountingManageEvent
extends QueueEvent {
    private static final long serialVersionUID = -1420990991266433888L;
    public static final int TYPE_START = 1;
    public static final int TYPE_STOP = 2;
    public static final int TYPE_UPDATE = 3;
    private final int accountingRootDeviceId;
    private final int type;
    private InetConnection connection;
    private final long timeout;

    protected InetAccountingManageEvent() {
        this.accountingRootDeviceId = -1;
        this.type = -1;
        this.timeout = -1L;
    }

    public InetAccountingManageEvent(int moduleId, int contractId, int userId, int accountingRootDeviceId, InetConnection connection, int type, long timeout) {
        super(moduleId, contractId, userId);
        this.accountingRootDeviceId = accountingRootDeviceId;
        this.connection = connection;
        this.type = type;
        this.timeout = timeout;
    }

    public InetConnection getConnection() {
        return this.connection;
    }

    public void setConnection(InetConnection connection) {
        this.connection = connection;
    }

    public int getType() {
        return this.type;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("accountingRootDeviceId", this.accountingRootDeviceId);
    }

    protected void toString(StringBuilder sb) {
        sb.append("; type: ");
        sb.append(this.type);
        sb.append("; deviceId: ");
        sb.append(this.connection.getDeviceId());
        sb.append("; connectionId: ");
        sb.append(this.connection.getId());
    }
}

