/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.AbstactHourLogProccessor;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.AccountingProcess;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.NetflowHourLogProcessor;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.RadiusHourLogProcessor;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.event.ProcessingContinueEvent;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.event.ProcessingSuspendEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.server.bean.DataProcessRecordDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.common.worker.WorkerThreadFactory;

public class ProcessLogTask
implements Runnable {
    private final DataProcessRecord record;
    public final Setup setup;
    private AccountingProcess accounting;
    private final int moduleId;
    private final int rootDeviceId;
    private static final Logger logger = LogManager.getLogger();

    public ProcessLogTask(DataProcessRecord record, Setup setup, int moduleId, int rootDeviceId) {
        this.record = record;
        this.setup = setup;
        this.moduleId = moduleId;
        this.rootDeviceId = rootDeviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
            Connection con = connectionSet.getConnection();
            this.accounting = new AccountingProcess(this.setup, this.rootDeviceId, false, true, this.record.getDay(), null, null, this.record.getDeviceId());
            try {
                this.accounting.start();
            }
            catch (Throwable e) {
                logger.error("", e);
                throw new BGException(e);
            }
            Date day = this.record.getDay();
            Date now = new Date();
            int currentHour = TimeUtils.convertDateToCalendar((Date)now).get(11);
            int deviceId = this.record.getDeviceId();
            int daylDelta = TimeUtils.daysDelta((Date)now, (Date)day);
            if (daylDelta > 0) {
                this.removeTask(this.record, con);
                return;
            }
            boolean isCurrentDay = daylDelta == 0;
            try {
                this.getDictionaries(con, day, deviceId);
                List<AbstactHourLogProccessor> processors = this.getProcessors(connectionSet, day, deviceId);
                if (isCurrentDay) {
                    EventProcessor.getInstance().request((QueueEvent)new ProcessingSuspendEvent(this.accounting.moduleId, this.accounting.applicationId));
                }
                ArrayList futures = new ArrayList();
                ServerContextThreadFactory threadContextFactory = new ServerContextThreadFactory(this.setup, this.accounting.moduleId, null, null, true);
                Calendar cal = TimeUtils.convertDateToCalendar((Date)day);
                int hourMax = isCurrentDay ? currentHour : 24;
                for (int i = 0; i < hourMax; ++i) {
                    cal.set(11, i);
                    final Date hour = cal.getTime();
                    ArrayList tasks = new ArrayList();
                    ExecutorService executor = Executors.newFixedThreadPool(processors.size(), (ThreadFactory)new WorkerThreadFactory(null, null, (ThreadContextFactory)threadContextFactory));
                    for (final AbstactHourLogProccessor abstactHourLogProccessor : processors) {
                        Future<?> future = executor.submit((Runnable)new WorkerTask(){

                            protected void runImpl() throws Exception {
                                try {
                                    ServerContext context = (ServerContext)ServerContext.get();
                                    ConnectionSet connectionSet = context.getConnectionSet();
                                    logger.debug("start processing log for hour " + hour + ";deviceId=" + ProcessLogTask.this.record.getDeviceId());
                                    long start = System.currentTimeMillis();
                                    abstactHourLogProccessor.getAmountsFromLogs(connectionSet, hour);
                                    logger.debug("hour " + hour + " was processed by  " + TimeUtils.formatDeltaTime((long)((System.currentTimeMillis() - start) / 1000L)));
                                }
                                catch (BGException e) {
                                    logger.error("error while proccesing log", (Throwable)e);
                                }
                            }
                        });
                        futures.add(future);
                    }
                    for (Future future : futures) {
                        future.get();
                    }
                    executor.shutdown();
                    this.saveAmounts(con, hour, processors, deviceId, isCurrentDay);
                    if (i >= 23 && !isCurrentDay) continue;
                    this.updateTaskHour(con, this.record, i + 1);
                }
                for (AbstactHourLogProccessor p : processors) {
                    p.dayFinished(connectionSet, isCurrentDay);
                }
            }
            finally {
                this.removeTask(this.record, con);
                if (isCurrentDay) {
                    EventProcessor.getInstance().request((QueueEvent)new ProcessingContinueEvent(this.accounting.moduleId, this.accounting.applicationId));
                }
                connectionSet.recycle();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    protected void getDictionaries(Connection con, Date day, int deviceId) throws BGException {
        try {
            InetSessionLogDao.checkTables(con, this.moduleId, day);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected List<AbstactHourLogProccessor> getProcessors(ConnectionSet connectionSet, Date day, int deviceId) throws BGException {
        AbstactHourLogProccessor proccesor;
        ArrayList<AbstactHourLogProccessor> processors = new ArrayList<AbstactHourLogProccessor>();
        if (this.accounting.isProcessRadiusLogs()) {
            proccesor = new RadiusHourLogProcessor(day, this.accounting, deviceId);
            processors.add(proccesor);
            proccesor.init(connectionSet.getConnection());
        }
        if (this.accounting.isProcessFlowLogs()) {
            proccesor = new NetflowHourLogProcessor(day, this.accounting, deviceId);
            processors.add(proccesor);
            proccesor.init(connectionSet.getConnection());
        }
        return processors;
    }

    protected void saveAmounts(Connection con, Date hour, List<AbstactHourLogProccessor> processors, int deviceId, boolean isCurrentDay) throws SQLException {
        long updateTime = 0L;
        String detailLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_detail", (Date)hour, (int)this.moduleId);
        String detailTableName = ServerUtils.getModuleTableName((String)"inet_session_detail", (int)this.moduleId);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(hour);
        int day = cal.get(5);
        int hourInt = cal.get(11);
        String pattern = "DELETE FROM detailTable  WHERE   deviceId = ? AND  trafficTypeId > 0  AND day=?  AND hour=? ";
        String query = pattern.replaceAll("detailTable", detailLogTableName);
        PreparedStatement deleteDetailPS = con.prepareStatement(query);
        deleteDetailPS.setInt(1, deviceId);
        deleteDetailPS.setInt(2, day);
        deleteDetailPS.setInt(3, hourInt);
        deleteDetailPS.executeUpdate();
        deleteDetailPS.close();
        if (isCurrentDay) {
            query = pattern.replaceAll("detailTable", detailTableName);
            deleteDetailPS = con.prepareStatement(query);
            deleteDetailPS.setInt(1, deviceId);
            deleteDetailPS.setInt(2, day);
            deleteDetailPS.setInt(3, hourInt);
            deleteDetailPS.executeUpdate();
            deleteDetailPS.close();
        }
        pattern = "INSERT INTO detailTable  (amount, day,  sessionId, hour, trafficTypeId, deviceId ) VALUES (?,?,?,?,?,?)";
        PreparedStatement insertDetailLogPS = con.prepareStatement(pattern.replaceAll("detailTable", detailLogTableName));
        PreparedStatement insertDetailPS = null;
        if (isCurrentDay) {
            insertDetailPS = con.prepareStatement(pattern.replaceAll("detailTable", detailTableName));
        }
        HashMap<Long, Map<Integer, Long>> sessionAmountMap = new HashMap<Long, Map<Integer, Long>>();
        HashSet<Long> currentSessionSet = new HashSet<Long>();
        for (AbstactHourLogProccessor abstactHourLogProccessor : processors) {
            sessionAmountMap.putAll(abstactHourLogProccessor.getSessionHourAmountMap());
            currentSessionSet.addAll(abstactHourLogProccessor.getCurrentSessionSet());
        }
        logger.debug("saving amount for hour = " + hour + ";deviceId =" + deviceId);
        int count = 0;
        for (Map.Entry entry : sessionAmountMap.entrySet()) {
            long sessionId = (Long)entry.getKey();
            boolean isCurrentSession = currentSessionSet.contains(sessionId);
            if (isCurrentSession && !isCurrentDay) {
                logger.error("Current Session and is not in current day for sessionId = " + sessionId);
                continue;
            }
            PreparedStatement ps = isCurrentSession ? insertDetailPS : insertDetailLogPS;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                int trafficTypeId = (Integer)entry2.getKey();
                long amount = (Long)entry2.getValue();
                if (amount == 0L) continue;
                ps.setLong(1, amount);
                ps.setInt(2, day);
                ps.setLong(3, sessionId);
                ps.setInt(4, hourInt);
                ps.setInt(5, trafficTypeId);
                ps.setInt(6, trafficTypeId != 0 ? deviceId : 0);
                long start = System.currentTimeMillis();
                ps.executeUpdate();
                updateTime += System.currentTimeMillis() - start;
                ++count;
            }
        }
        insertDetailLogPS.close();
        if (isCurrentDay) {
            insertDetailPS.close();
        }
        logger.debug(count + " amounts saved by " + TimeUtils.formatDeltaTime((long)(updateTime / 1000L)) + " in hour" + hour + ";deviceId =" + deviceId);
    }

    private void updateTaskHour(Connection con, DataProcessRecord record, int hour) throws BGException {
        DataProcessRecordDao dao = new DataProcessRecordDao(con, this.moduleId);
        record.setCurentHour(hour);
        dao.update(record);
    }

    private void removeTask(DataProcessRecord record, Connection con) throws BGException {
        DataProcessRecordDao dao = new DataProcessRecordDao(con, this.moduleId);
        record.setStartTime(null);
        dao.update(record);
        dao.delete(record.getId());
    }

    protected void addIds(InetDevice device, Set<Integer> deviceIds) {
        deviceIds.add(device.getId());
        for (InetDevice d : device.getChildren()) {
            this.addIds(d, deviceIds);
        }
    }
}

