/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.Pair;

public class InetConnectionDao {
    private static final Logger logger = LogManager.getLogger();
    private final Connection con;
    private final int moduleId;
    private final String tableName;
    private PreparedStatement insertSeqPS = null;
    private PreparedStatement insertPS = null;
    private static final ExecutorService SERVICE = Executors.newFixedThreadPool(1);
    private PreparedStatement updatePS = null;
    private PreparedStatement updateDeviceStatePS = null;
    private PreparedStatement updateDeviceOptionsPS = null;
    private PreparedStatement updateDeviceStateAndOptionsPS = null;
    private PreparedStatement updateInetAddressPS = null;
    private PreparedStatement getPS = null;
    PreparedStatement insertIpNetPS;
    PreparedStatement deleteIpNetPS;

    public InetConnectionDao(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
        this.tableName = "inet_connection_" + moduleId;
    }

    public void insert(InetConnection b) throws BGException {
        try {
            long id = this.getNextConnectionId();
            PreparedStatement ps = this.insertPS;
            if (ps == null) {
                ps = this.insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (id, parentId, deviceId, devicePort, agentDeviceId, circuitId, acctSessionId, username, type, accessCode, servId, calledStationId, callingStationId, ipResourceId, ipAddress, prefixResourceId, prefix, prefixLength, delegatedPrefixResourceId, delegatedPrefix, delegatedPrefixLength, connectionStart, deviceState, deviceOptions, status ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            }
            ps.setLong(1, id);
            ps.setLong(2, b.getParentConnectionId());
            ps.setInt(3, b.getDeviceId());
            ps.setInt(4, b.getDevicePort());
            ps.setInt(5, b.getAgentDeviceId());
            ps.setString(6, b.getCircuitId() != null ? b.getCircuitId().toString() : null);
            ps.setString(7, b.getAcctSessionId());
            ps.setString(8, b.getUsername());
            ps.setInt(9, b.getType());
            ps.setInt(10, b.getAccessCode());
            ps.setInt(11, b.getServId());
            ps.setString(12, b.getCalledStationId());
            ps.setString(13, b.getCallingStationId());
            ps.setInt(14, b.getIpResourceId());
            ps.setBytes(15, b.getInetAddressBytes());
            ps.setInt(16, b.getPrefixResourceId());
            ps.setBytes(17, b.getPrefix());
            ps.setShort(18, b.getPrefixLength());
            ps.setInt(19, b.getDelegatedPrefixResourceId());
            ps.setBytes(20, b.getDelegatedPrefix());
            ps.setShort(21, b.getDelegatedPrefixLength());
            ps.setTimestamp(22, TimeUtils.convertDateToTimestampSeconds((Date)b.getConnectionStart()));
            ps.setInt(23, b.getDeviceState());
            ps.setString(24, Utils.toString((Iterable)b.getDeviceOptions()));
            ps.setInt(25, b.getConnectionStatus());
            ps.executeUpdate();
            b.setId(id);
            List routeList = b.getRouteList();
            if (routeList != null) {
                PreparedStatement insertIpNetPS = this.getInsertIpNetPS();
                int size = routeList.size();
                for (int i = 0; i < size; ++i) {
                    IpNet ipNet = (IpNet)routeList.get(i);
                    insertIpNetPS.setLong(1, id);
                    insertIpNetPS.setBytes(2, ipNet.getSubnet());
                    insertIpNetPS.setInt(3, ipNet.getMask());
                    insertIpNetPS.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public long getNextConnectionId() throws SQLException {
        PreparedStatement ps = this.insertSeqPS;
        if (ps == null) {
            ps = this.insertSeqPS = this.con.prepareStatement("INSERT INTO inet_connection_" + this.moduleId + "_seq (id) VALUES (NULL)", 1);
        }
        ps.executeUpdate();
        final long id = ServerUtils.lastInsertId((PreparedStatement)ps);
        if (id % 10000L == 0L) {
            SERVICE.execute(new Runnable(){

                @Override
                public void run() {
                    Connection con = Setup.getSetup().getDBConnectionFromPool();
                    try {
                        con.setAutoCommit(false);
                        logger.info("Clean old id from inet_connection_" + InetConnectionDao.this.moduleId + "_seq");
                        PreparedStatement ps = con.prepareStatement("DELETE FROM inet_connection_" + InetConnectionDao.this.moduleId + "_seq WHERE id<?");
                        ps.setLong(1, id - 2000L);
                        ps.executeUpdate();
                        ps.close();
                        con.commit();
                        logger.info("End clean old id from inet_connection_" + InetConnectionDao.this.moduleId + "_seq");
                        Thread.sleep(60000L);
                    }
                    catch (SQLException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        ServerUtils.closeConnection((Connection)con);
                    }
                }
            });
        }
        return id;
    }

    public void update(InetConnection b) throws BGException {
        try {
            PreparedStatement ps = this.updatePS;
            if (ps == null) {
                ps = this.updatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=?, acctSessionId=?, username=?, calledStationId=?, callingStationId=?, ipResourceid=?, ipAddress=?, prefixResourceId=?, prefix=?, prefixLength=?, delegatedPrefixResourceId=?, delegatedPrefix=?, delegatedPrefixLength=?, connectionStart=?, status=? WHERE id=?");
            }
            ps.setLong(1, b.getParentConnectionId());
            ps.setString(2, b.getAcctSessionId());
            ps.setString(3, b.getUsername());
            ps.setString(4, b.getCalledStationId());
            ps.setString(5, b.getCallingStationId());
            ps.setInt(6, b.getIpResourceId());
            ps.setBytes(7, b.getInetAddressBytes());
            ps.setInt(8, b.getPrefixResourceId());
            ps.setBytes(9, b.getPrefix());
            ps.setShort(10, b.getPrefixLength());
            ps.setInt(11, b.getDelegatedPrefixResourceId());
            ps.setBytes(12, b.getDelegatedPrefix());
            ps.setShort(13, b.getDelegatedPrefixLength());
            ps.setTimestamp(14, TimeUtils.convertDateToTimestampSeconds((Date)b.getConnectionStart()));
            ps.setInt(15, b.getConnectionStatus());
            ps.setLong(16, b.getId());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateDeviceStateAndOptions(int deviceId, long id, int state, Set<Integer> inetOptions, int accessCode) throws BGException {
        try {
            PreparedStatement ps;
            if (state != -1000) {
                if (inetOptions != null) {
                    ps = this.updateDeviceStateAndOptionsPS;
                    if (ps == null) {
                        ps = this.updateDeviceStateAndOptionsPS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceState=?, deviceOptions=?, accessCode=?, type=type|? WHERE deviceId=? AND id=?");
                    }
                    ArrayList<Integer> options = new ArrayList<Integer>(inetOptions);
                    Collections.sort(options);
                    ps.setInt(1, state);
                    ps.setString(2, Utils.toString(options));
                    ps.setInt(3, accessCode);
                    ps.setInt(4, 8);
                    ps.setInt(5, deviceId);
                    ps.setLong(6, id);
                } else {
                    ps = this.updateDeviceStatePS;
                    if (ps == null) {
                        ps = this.updateDeviceStatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceState=?, accessCode=?, type=type|? WHERE deviceId=? AND id=?");
                    }
                    ps.setInt(1, state);
                    ps.setInt(2, accessCode);
                    ps.setInt(3, 8);
                    ps.setInt(4, deviceId);
                    ps.setLong(5, id);
                }
            } else {
                assert (inetOptions != null);
                ps = this.updateDeviceOptionsPS;
                if (ps == null) {
                    ps = this.updateDeviceOptionsPS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceOptions=? WHERE deviceId=? AND id=?");
                }
                ArrayList<Integer> options = new ArrayList<Integer>(inetOptions);
                Collections.sort(options);
                ps.setString(1, Utils.toString(options));
                ps.setInt(2, deviceId);
                ps.setLong(3, id);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean updateInetAddress(int deviceId, long id, byte[] ipAddress, int ipResourceId) throws BGException {
        try {
            PreparedStatement ps = this.updateInetAddressPS;
            if (ps == null) {
                ps = this.updateInetAddressPS = this.con.prepareStatement("UPDATE " + this.tableName + " SET ipResourceid=?, ipAddress=? WHERE deviceId=? AND id=? AND ipAddress IS NULL");
            }
            ps.setInt(1, ipResourceId);
            ps.setBytes(2, ipAddress);
            ps.setInt(3, deviceId);
            ps.setLong(4, id);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<InetConnection> list(Set<Integer> deviceIds, boolean checkSession) throws BGException {
        try {
            StringBuilder sb = new StringBuilder(100);
            sb.append("SELECT connection.*, serv.contractId FROM " + this.tableName + " as connection LEFT JOIN inet_serv_" + this.moduleId + " as serv ON serv.id=connection.servId");
            if (checkSession) {
                sb.append(" LEFT JOIN inet_session_" + this.moduleId + " as session ON session.connectionId=connection.id");
            }
            sb.append(" WHERE 1=1");
            if (deviceIds != null) {
                sb.append(" AND connection.deviceId IN (" + Utils.toString(deviceIds) + ")");
            }
            if (checkSession) {
                sb.append(" AND session.id IS NOT NULL");
            }
            ArrayList<InetConnection> result = new ArrayList<InetConnection>();
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected InetConnection getFromRS(ResultSet rs) throws SQLException {
        InetConnection result = new InetConnection();
        result.setId(rs.getLong("id"));
        result.setParentConnectionId(rs.getLong("parentId"));
        result.setDeviceId(rs.getInt("deviceId"));
        result.setDevicePort(rs.getInt("devicePort"));
        result.setAgentDeviceId(rs.getInt("agentDeviceId"));
        result.setAcctSessionId(rs.getString("acctSessionId"));
        result.setUsername(rs.getString("username"));
        result.setType(rs.getInt("type"));
        result.setAccessCode(rs.getInt("accessCode"));
        result.setContractId(rs.getInt("contractId"));
        result.setServId(rs.getInt("servId"));
        result.setCalledStationId(rs.getString("calledStationId"));
        result.setCallingStationId(rs.getString("callingStationId"));
        result.setCircuitId((Object)rs.getString("circuitId"));
        result.setIpResourceId(rs.getInt("ipResourceId"));
        result.setInetAddressBytes(rs.getBytes("ipAddress"));
        result.setPrefixResourceId(rs.getInt("prefixResourceId"));
        result.setPrefix(rs.getBytes("prefix"));
        result.setPrefixLength(rs.getShort("prefixLength"));
        result.setDelegatedPrefixResourceId(rs.getInt("delegatedPrefixResourceId"));
        result.setDelegatedPrefix(rs.getBytes("delegatedPrefix"));
        result.setDelegatedPrefixLength(rs.getShort("delegatedPrefixLength"));
        result.setConnectionStart(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("connectionStart")));
        result.setDeviceState(rs.getShort("deviceState"));
        result.setDeviceOptions(Utils.toIntegerSet((String)rs.getString("deviceOptions")));
        result.setConnectionStatus(rs.getInt("status"));
        return result;
    }

    public static InetConnection getConnectionFromRS(ResultSet rs) throws SQLException {
        InetConnection result = new InetConnection();
        result.setId(rs.getLong("connection.id"));
        result.setParentConnectionId(rs.getLong("connection.parentId"));
        result.setDeviceId(rs.getInt("connection.deviceId"));
        result.setDevicePort(rs.getInt("connection.devicePort"));
        result.setAgentDeviceId(rs.getInt("connection.agentDeviceId"));
        result.setAcctSessionId(rs.getString("connection.acctSessionId"));
        result.setUsername(rs.getString("connection.username"));
        result.setType(rs.getInt("connection.type"));
        result.setAccessCode(rs.getInt("connection.accessCode"));
        result.setContractId(rs.getInt("serv.contractId"));
        result.setServId(rs.getInt("connection.servId"));
        result.setCalledStationId(rs.getString("connection.calledStationId"));
        result.setCallingStationId(rs.getString("connection.callingStationId"));
        result.setCircuitId((Object)rs.getString("connection.circuitId"));
        result.setIpResourceId(rs.getInt("connection.ipResourceId"));
        result.setInetAddressBytes(rs.getBytes("connection.ipAddress"));
        result.setPrefixResourceId(rs.getInt("connection.prefixResourceId"));
        result.setPrefix(rs.getBytes("connection.prefix"));
        result.setPrefixLength(rs.getShort("connection.prefixLength"));
        result.setDelegatedPrefixResourceId(rs.getInt("connection.delegatedPrefixResourceId"));
        result.setDelegatedPrefix(rs.getBytes("connection.delegatedPrefix"));
        result.setDelegatedPrefixLength(rs.getShort("connection.delegatedPrefixLength"));
        result.setConnectionStart(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("connection.connectionStart")));
        result.setDeviceState(rs.getShort("connection.deviceState"));
        result.setDeviceOptions(Utils.toIntegerSet((String)rs.getString("connection.deviceOptions")));
        result.setConnectionStatus(rs.getInt("connection.status"));
        return result;
    }

    public InetConnection get(long connectionId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT connection.*, serv.contractId FROM " + this.tableName + " as connection LEFT JOIN inet_serv_" + this.moduleId + " as serv ON serv.id=connection.servId WHERE connection.id=?");
            ps.setLong(1, connectionId);
            InetConnection result = null;
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public InetConnection get(int deviceId, long connectionId) throws BGException {
        try {
            PreparedStatement ps = this.getPS;
            if (ps == null) {
                ps = this.getPS = this.con.prepareStatement("SELECT connection.*, serv.contractId FROM " + this.tableName + " as connection LEFT JOIN inet_serv_" + this.moduleId + " as serv ON serv.id=connection.servId WHERE connection.deviceId=? AND connection.id=?");
            }
            ps.setInt(1, deviceId);
            ps.setLong(2, connectionId);
            InetConnection result = null;
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public boolean closeConnection(int deviceId, long id, Date sessionStop, int type) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET status=?, type=type|? WHERE deviceId=? AND id=? AND status!=?");
            ps.setInt(1, 3);
            ps.setInt(2, type);
            ps.setInt(3, deviceId);
            ps.setLong(4, id);
            ps.setInt(5, 3);
            int result = ps.executeUpdate();
            ps.close();
            return result == 1;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateType(int deviceId, long id, int type) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET type=type|? WHERE deviceId=? AND id=?");
            ps.setInt(1, type);
            ps.setInt(2, deviceId);
            ps.setLong(3, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<InetConnection> list(int inetServId) throws BGException {
        try {
            ArrayList<InetConnection> result = new ArrayList<InetConnection>();
            PreparedStatement ps = this.con.prepareStatement("SELECT connection.*, serv.contractId FROM " + this.tableName + " as connection LEFT JOIN inet_serv_" + this.moduleId + " as serv ON serv.id=connection.servId WHERE connection.servId=?");
            ps.setInt(1, inetServId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public static void main(String[] args) {
        Setup setup = new Setup("data.data");
        Setup.setSetup((Setup)setup);
        class R
        implements Runnable {
            final /* synthetic */ Setup val$setup;

            R(Setup setup) {
                this.val$setup = setup;
            }

            @Override
            public void run() {
                for (int i = 0; i < 10000; ++i) {
                    try {
                        if (i % 100 == 0) {
                            System.out.println(i);
                        }
                        Connection con = this.val$setup.getDBConnectionFromPool();
                        con.setAutoCommit(false);
                        InetConnection connection = new InetConnection();
                        connection.setConnectionStart(new Date());
                        new InetConnectionDao(con, 179).insert(connection);
                        Thread.sleep(new Random().nextInt(1000));
                        con.commit();
                        con.close();
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                System.out.println("STOP");
            }
        }
        new Thread(new R(setup)).start();
        new Thread(new R(setup)).start();
        new Thread(new R(setup)).start();
        new Thread(new R(setup)).start();
        new Thread(new R(setup)).start();
        new Thread(new R(setup)).start();
        new Thread(new R(setup)).start();
        new Thread(new R(setup)).start();
    }

    public void recycle() {
        try {
            if (this.insertPS != null) {
                this.insertPS.close();
                this.insertPS = null;
            }
            if (this.insertSeqPS != null) {
                this.insertSeqPS.close();
                this.insertSeqPS = null;
            }
            if (this.deleteIpNetPS != null) {
                this.deleteIpNetPS.close();
                this.deleteIpNetPS = null;
            }
            if (this.insertIpNetPS != null) {
                this.insertIpNetPS.close();
                this.insertIpNetPS = null;
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private PreparedStatement getInsertIpNetPS() throws SQLException {
        if (this.insertIpNetPS == null) {
            this.insertIpNetPS = this.con.prepareStatement("INSERT INTO inet_connection_route_" + this.moduleId + " (connectionId, subnet, mask) VALUES (?,?,?)");
        }
        return this.insertIpNetPS;
    }

    private PreparedStatement getDeleteIpNetPS() throws SQLException {
        if (this.deleteIpNetPS == null) {
            this.deleteIpNetPS = this.con.prepareStatement("DELETE FROM inet_connection_route_" + this.moduleId + " WHERE connectionId=?");
        }
        return this.deleteIpNetPS;
    }

    public void updateIpNets(long connectionId, List<IpNet> routeList) throws BGException {
        try {
            PreparedStatement deleteIpNetPS = this.getDeleteIpNetPS();
            deleteIpNetPS.setLong(1, connectionId);
            deleteIpNetPS.executeUpdate();
            if (routeList == null) {
                return;
            }
            PreparedStatement insertIpNetPS = this.getInsertIpNetPS();
            int size = routeList.size();
            for (int i = 0; i < size; ++i) {
                IpNet ipNet = routeList.get(i);
                insertIpNetPS.setLong(1, connectionId);
                insertIpNetPS.setBytes(2, ipNet.getSubnet());
                insertIpNetPS.setInt(3, ipNet.getMask());
                insertIpNetPS.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean delete(long connectionId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");
            ps.setLong(1, connectionId);
            boolean result = ps.executeUpdate() > 0;
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public static Pair<InetServ, InetConnection> find(Connection con, int moduleId, Set<Integer> servIds, String acctSessionId, String address, String login, String callingStationId) throws SQLException, BGException, UnknownHostException {
        return InetConnectionDao.find(con, moduleId, servIds, acctSessionId, address, login, callingStationId, null);
    }

    public static Pair<InetServ, InetConnection> find(Connection con, int moduleId, Set<Integer> servIds, String acctSessionId, String address, String login, String callingStationId, String calledStationId) throws SQLException, BGException, UnknownHostException {
        return InetConnectionDao.find(con, moduleId, null, servIds, acctSessionId, address, login, callingStationId, calledStationId);
    }

    public static Pair<InetServ, InetConnection> find(Connection con, int moduleId, Set<Integer> deviceIds, Set<Integer> servIds, String acctSessionId, String address, String login, String callingStationId, String calledStationId) throws SQLException, BGException, UnknownHostException {
        int i;
        InetAddress inetAddress;
        if (address != null) {
            if (logger.isInfoEnabled()) {
                logger.info("address: " + address);
            }
            inetAddress = InetAddress.getByName(address);
            if (logger.isInfoEnabled()) {
                logger.info("inetAddress: " + IpAddress.toString((byte[])inetAddress.getAddress()));
            }
        } else {
            inetAddress = null;
        }
        Pair result = null;
        StringBuilder sb = new StringBuilder("SELECT serv.*, connection.* FROM inet_connection_" + moduleId + " as connection LEFT JOIN inet_serv_" + moduleId + " as serv ON serv.id=connection.servId");
        sb.append(" WHERE");
        if (deviceIds != null) {
            deviceIds.remove(0);
            if (deviceIds.size() == 1) {
                sb.append(" connection.deviceId=? AND");
            } else if (deviceIds.size() > 0) {
                sb.append('(');
                for (i = 0; i < deviceIds.size(); ++i) {
                    sb.append(" connection.deviceId=? OR ");
                }
                sb.setLength(sb.length() - 4);
                sb.append(") AND");
            }
        }
        if (servIds != null) {
            servIds.remove(0);
            if (servIds.size() == 1) {
                sb.append(" serv.id=? AND");
            } else if (servIds.size() > 0) {
                sb.append('(');
                for (i = 0; i < servIds.size(); ++i) {
                    sb.append(" serv.id=? OR ");
                }
                sb.setLength(sb.length() - 4);
                sb.append(") AND");
            }
        }
        sb.append(" (? OR connection.acctSessionId=?) AND (? OR connection.ipAddress=?) AND (? OR connection.username=?) AND (? OR connection.callingStationId=?) AND (? OR connection.calledStationId=?) AND connection.status=? AND connection.parentId=0");
        PreparedStatement ps = con.prepareStatement(sb.toString());
        int i2 = 1;
        if (deviceIds != null && deviceIds.size() > 0) {
            for (Integer deviceId : deviceIds) {
                ps.setInt(i2++, deviceId);
            }
        }
        if (servIds != null && servIds.size() > 0) {
            for (Integer servId : servIds) {
                ps.setInt(i2++, servId);
            }
        }
        ps.setBoolean(i2++, acctSessionId == null);
        ps.setString(i2++, acctSessionId);
        ps.setBoolean(i2++, inetAddress == null);
        ps.setBytes(i2++, inetAddress != null ? inetAddress.getAddress() : null);
        ps.setBoolean(i2++, login == null);
        ps.setString(i2++, login);
        ps.setBoolean(i2++, callingStationId == null);
        ps.setString(i2++, callingStationId);
        ps.setBoolean(i2++, calledStationId == null);
        ps.setString(i2++, calledStationId);
        ps.setInt(i2++, 1);
        InetServDao inetServDao = new InetServDao(con, moduleId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            InetServ inetServ = inetServDao.getInetServFromRS(rs, false, false);
            InetConnection inetConnection = InetConnectionDao.getConnectionFromRS(rs);
            result = new Pair((Object)inetServ, (Object)inetConnection);
        }
        inetServDao.close();
        rs.close();
        ps.close();
        return result;
    }
}

