/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.bean.InvDevice;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.InvDeviceEntityAttrDaoSupport;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceDao;

public class InvDeviceDao
extends DeviceDao<InvDevice, InetDeviceType> {
    private final String deviceTypeTable;

    public InvDeviceDao(Connection con, int moduleId, int userId) throws BGException {
        super(con, moduleId, userId, "inv_device", (EntityAttrDaoSupport)new InvDeviceEntityAttrDaoSupport());
        this.deviceTypeTable = "inet_device_type_" + moduleId;
    }

    public InvDeviceDao(Connection con, int moduleId) throws BGException {
        this(con, moduleId, 0);
    }

    protected InvDevice newDevice() {
        return new InvDevice();
    }

    protected InetDeviceType newDeviceType(int id, String title) {
        return new InetDeviceType(id, title);
    }

    protected Directory<InetDeviceType> getTypeDir() throws BGException {
        return ServerDirectoryFactory.newUnmodifiableDirectory(InetDeviceType.class, (Connection)this.con, (int)this.moduleId, (boolean)false);
    }

    protected String getQueryById() {
        return "SELECT t.*, d.`entitySpecId` AS `entitySpecId` FROM " + this.tableName + " AS t LEFT JOIN " + this.deviceTypeTable + " AS d ON d.id=t.deviceTypeId WHERE t.`id`=?";
    }

    public void update(InvDevice invDevice) throws BGException {
        InetDeviceType deviceType = (InetDeviceType)this.getTypeDir().get(invDevice.getDeviceTypeId());
        if (deviceType == null && invDevice.getDeviceTypeId() == 0) {
            deviceType = new InetDeviceType(0, "\u041f\u0430\u043f\u043a\u0430");
        }
        invDevice.setTitle(InetDevice.generateTitle((String)invDevice.getIdentifier(), (String)invDevice.getHost(), (String)deviceType.toString()));
        super.update((Device)invDevice);
    }
}

