/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAuthError;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.DhcpDisableMode;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAuthErrorDao;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetAbstractDhcpProcessor;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDevice;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpOfferedAddressMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.ServSearchResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;

public class InetSimpleDhcpProcessor
extends InetAbstractDhcpProcessor
implements Lifecycle {
    private static final Logger log = LogManager.getLogger();
    private InetDhcpOfferedAddressMap offerMap;

    @ConstructorProperties(value={"setup", "access"})
    public InetSimpleDhcpProcessor(Setup setup, Access access) throws BGException {
        super(access, setup, "inet", SetupParam.getModuleId((ParameterMap)setup));
    }

    public void start() throws Exception {
        this.deviceMap = new InetDhcpDeviceMap(this.access);
        InetDeviceRuntime rootDeviceRuntime = this.access.deviceMap.get(this.access.rootDeviceId);
        boolean useXid = rootDeviceRuntime != null ? rootDeviceRuntime.config.getInt("dhcp.xid", 1) > 0 : ((Setup)this.setup).getModuleSetup(Integer.valueOf(this.access.moduleId)).getInt("dhcp.xid", 1) > 0;
        this.offerMap = new InetDhcpOfferedAddressMap(useXid);
    }

    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DhcpPacket processOption82RequestImpl(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, DhcpPacket request, boolean renew) throws BGException {
        byte messageType = request.messageType;
        if (messageType == 3) {
            log.debug("DHCP_REQUEST");
        } else {
            log.debug("DHCP_DISCOVER");
        }
        if (log.isDebugEnabled()) {
            log.debug("request.giaddr= " + IPUtils.convertIpToString((int)Utils.convertBytesToInt((byte[])request.giaddr)) + ", clientAddress=" + clientAddress);
        }
        DhcpPacket response = request.createResponse();
        ServSearchResult servSearchResult = device.findServRuntime(request, req);
        if (servSearchResult == null) {
            log.info("InetServ not found.");
            return null;
        }
        log.info("InetServ found: " + servSearchResult.parentServRuntime);
        servSearchResult.parentServRuntime.tryLockEx(20L, TimeUnit.SECONDS);
        try {
            DhcpPacket dhcpPacket = this.processOption82Request0(req, clientAddress, device, servSearchResult, request, response, renew);
            servSearchResult.parentServRuntime.unlock();
            return dhcpPacket;
        }
        catch (Throwable throwable) {
            try {
                servSearchResult.parentServRuntime.unlock();
                throw throwable;
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DhcpPacket processOption82Request0(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, ServSearchResult servSearchResult, DhcpPacket request, DhcpPacket response, boolean renew) throws BGException, UnknownHostException {
        AuthResult authResult;
        InetServRuntime parentServRuntime = servSearchResult.parentServRuntime;
        InetServRuntime servRuntime = servSearchResult.servRuntime != null ? servSearchResult.servRuntime : parentServRuntime;
        InetServ parentServ = parentServRuntime.getInetServ();
        InetServ serv = servRuntime.getInetServ();
        req.interfaceId = parentServ.getInterfaceId();
        if (servSearchResult.servRuntime == null) {
            log.info("inetServ[id=" + serv.getId() + "] sub serv with MAC-addresses not found.");
            authResult = new AuthResult(46);
        } else {
            authResult = parentServ.getDeviceState() != 1 ? new AuthResult(parentServ.getAccessCode() != 0 ? parentServ.getAccessCode() : 10) : new AuthResult(0);
        }
        if (request.messageType == 1) {
            IpResourceReserve resource = null;
            InetDhcpOfferedAddressMap.Offered offered = this.offerMap.getOffered(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr);
            if (offered != null) {
                log.info("Duplicate offer. Send same answer");
                resource = offered.resource;
            }
            if (resource == null) {
                DhcpDisableMode dhcpDisableMode = device.getDhcpDisableMode(servRuntime.getInetServTypeRuntime());
                if (authResult.accessCode == 0 || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH) {
                    List<InetServRuntime> childrenServRuntimeList = this.access.inetServRuntimeMap.listChildren(serv.getId(), req.millis);
                    resource = this.offerMap.offer((int)device.deviceRuntime.inetDeviceId, (Integer)serv.getId(), request.xid, request.chaddr, serv, childrenServRuntimeList, Collections.emptyList(), authResult.accessCode, TimeUnit.SECONDS.toMillis(25L));
                } else {
                    InetAuthError error = new InetAuthError();
                    error.setDeviceId(device.deviceRuntime.inetDevice.getId());
                    error.setDeviceTitle(device.deviceRuntime.inetDevice.getTitle());
                    error.setContractId(serv.getContractId());
                    error.setServId(serv.getId());
                    error.setServTitle(serv.getTitle());
                    error.setErrorCode(authResult.accessCode);
                    ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
                    try {
                        error.setContractTitle("");
                        InetAuthErrorDao authErrorDao = new InetAuthErrorDao(connectionSet, this.mid, new Date());
                        authErrorDao.addError(error);
                        authErrorDao.recycle();
                    }
                    finally {
                        connectionSet.recycle();
                    }
                }
            }
            if (resource == null) {
                log.info("Free IP address not found");
                return null;
            }
            Set inetOptionIds = authResult.accessCode == 0 ? parentServ.getDeviceOptions() : null;
            this.setOptions(device, resource.getAddress(), resource.getIpResourceId(), response, inetOptionIds, renew);
            response.messageType = (byte)2;
            return response;
        }
        if (request.messageType == 3) {
            InetDhcpOfferedAddressMap.Offered offered = this.offerMap.getOffered(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr);
            if (offered == null) {
                List<InetServRuntime> childrenServRuntimeList = this.access.inetServRuntimeMap.listChildren(serv.getId(), req.millis);
                IpResourceReserve resource = this.offerMap.offer((int)device.deviceRuntime.inetDeviceId, (Integer)serv.getId(), request.xid, request.chaddr, serv, childrenServRuntimeList, Collections.emptyList(), authResult.accessCode, TimeUnit.SECONDS.toMillis(25L));
                if (resource == null) {
                    log.info("Free IP address not found");
                    return null;
                }
                int errorCode = authResult.accessCode;
                Set inetOptionIds = errorCode == 0 ? parentServ.getDeviceOptions() : null;
                this.setOptions(device, resource.getAddress(), resource.getIpResourceId(), response, inetOptionIds, renew);
                response.messageType = (byte)5;
                DhcpOption requestedIp = request.getOption((byte)50);
                if (requestedIp != null && !Arrays.equals(requestedIp.value, resource.getAddress())) {
                    log.info("requestedIP=" + InetAddress.getByAddress(requestedIp.value));
                    response.messageType = (byte)6;
                    response.flags = DhcpPacket.FLAG_BROADCAST;
                }
                return response;
            }
            DhcpOption requestedIp = request.getOption((byte)50);
            if (requestedIp != null && !Arrays.equals(requestedIp.value, offered.resource.getAddress())) {
                log.info("requestedIP=" + InetAddress.getByAddress(requestedIp.value));
                response.messageType = (byte)6;
                response.flags = DhcpPacket.FLAG_BROADCAST;
            } else {
                IpResourceReserve resource = offered.resource;
                int errorCode = offered.errorCode;
                Set inetOptionIds = errorCode == 0 ? parentServ.getDeviceOptions() : null;
                this.setOptions(device, resource.getAddress(), resource.getIpResourceId(), response, inetOptionIds, renew);
                response.messageType = (byte)5;
            }
        }
        return response;
    }

    private void setOptions(InetDhcpDevice device, byte[] address, int ipResourceId, DhcpPacket response, Set<Integer> inetOptionIds, boolean renew) throws BGException {
        response.yiaddr = address;
        device.setOptions(this.access.ipResourceManager, ipResourceId, response, Utils.unsignedIntToLong((int)Utils.convertBytesToInt((byte[])address)), inetOptionIds, renew);
    }
}

