/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.ip;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServTypeIPMode;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpData;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpHandler;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpUtils;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.radius.IpResourceEntry;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public abstract class AbstractInetServIpHandler
implements InetServIpHandler {
    private Logger logger = LogManager.getLogger();
    protected int moduleId = 0;
    protected ServerContext context = null;
    protected InetServService inetServService = null;

    @Override
    public void checkAddress(InetServ inetServ, InetServType servType) throws BGMessageException {
    }

    @Override
    public void setAddress(InetServ inetServ, InetServType servType, InetServ oldInetServ, int subscriberId, String subscriberTitle) throws BGException {
    }

    @Override
    public boolean setRadiusIp(InetServIpData inetServIpData, RadiusPacket request, RadiusPacket response) {
        return true;
    }

    @Override
    public void flowStaticSubnet(InetServRuntime inetServRuntime, List<IpNet> result) {
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public void setServerContext(ServerContext context) {
        this.context = context;
    }

    public void setInetServService(InetServService inetServService) {
        this.inetServService = inetServService;
    }

    protected void flowStaticSubnetIPv4(InetServRuntime inetServRuntime, List<IpNet> result) {
        InetServ inetServ = inetServRuntime.getInetServ();
        InetServIpUtils.flowStaticSubnet(result, IpNet.newInstance((byte[])inetServ.getAddressFrom(), (byte[])inetServ.getAddressTo()));
    }

    protected void setFramedIPAddress(RadiusListenerWorker<?> radiusListenerWorker, RadiusPacket response, int ipResourceId, byte[] ipAddress) {
        InetServIpUtils.setFramedIPAddress(radiusListenerWorker, response, ipResourceId, ipAddress);
    }

    protected void setFramedIPv6Prefix(RadiusListenerWorker<?> radiusListenerWorker, RadiusPacket response, int ipResourceId, byte[] prefix, short prefixLength) {
        InetServIpUtils.setFramedIPv6Prefix(radiusListenerWorker, response, ipResourceId, prefix, prefixLength);
    }

    protected void setDelegatedIPv6Prefix(RadiusListenerWorker<?> radiusListenerWorker, RadiusPacket response, int ipResourceId, byte[] prefix, short prefixLength) {
        InetServIpUtils.setDelegatedIPv6Prefix(radiusListenerWorker, response, ipResourceId, prefix, prefixLength);
    }

    protected InetServTypeIPMode getIPv4Mode(InetServType servType) {
        JSONObject jsonData = new JSONObject(servType.getData() == null || !servType.getData().startsWith("{") ? "{}" : servType.getData());
        return new InetServTypeIPMode(jsonData.optJSONObject("ipv4"));
    }

    protected InetServTypeIPMode getIPv6Mode(InetServType servType) {
        JSONObject jsonData = new JSONObject(servType.getData() == null || !servType.getData().startsWith("{") ? "{}" : servType.getData());
        return new InetServTypeIPMode(jsonData.optJSONObject("ipv6"));
    }

    protected void subscriptionFramedIPv6Prefix(InetServ oldInetServ, InetServ newInetServ, int subscriberId, String subscriberTitle) throws BGException {
        byte[] oldPrefix = oldInetServ == null ? null : oldInetServ.getFramedIPv6Prefix();
        short oldPrefixLength = oldInetServ == null ? (short)0 : oldInetServ.getFramedIPv6PrefixLength();
        byte[] newPrefix = newInetServ.getFramedIPv6Prefix();
        short newPrefixLength = newInetServ.getFramedIPv6PrefixLength();
        this.subscriptionIPv6Prefix("Framed", oldInetServ, newInetServ, oldPrefix, oldPrefixLength, newPrefix, newPrefixLength, subscriberId, subscriberTitle);
    }

    protected void subscriptionDelegatedIPv6Prefix(InetServ oldInetServ, InetServ newInetServ, int subscriberId, String subscriberTitle) throws BGException {
        byte[] oldPrefix = oldInetServ == null ? null : oldInetServ.getDelegatedIPv6Prefix();
        short oldPrefixLength = oldInetServ == null ? (short)0 : oldInetServ.getDelegatedIPv6PrefixLength();
        byte[] newPrefix = newInetServ.getDelegatedIPv6Prefix();
        short newPrefixLength = newInetServ.getDelegatedIPv6PrefixLength();
        this.subscriptionIPv6Prefix("Delegated", oldInetServ, newInetServ, oldPrefix, oldPrefixLength, newPrefix, newPrefixLength, subscriberId, subscriberTitle);
    }

    private void subscriptionIPv6Prefix(String prefixType, InetServ oldInetServ, InetServ newInetServ, byte[] oldPrefix, short oldPrefixLength, byte[] newPrefix, short newPrefixLength, int subscriberId, String subscriberTitle) throws BGException {
        boolean needSubscription = oldInetServ == null || !IpAddress.equals((byte[])oldPrefix, (byte[])newPrefix) || (oldInetServ.getDateFrom() != null || newInetServ.getDateFrom() != null) && !TimeUtils.dateEqual((Date)oldInetServ.getDateFrom(), (Date)newInetServ.getDateFrom()) || (oldInetServ.getDateTo() != null || newInetServ.getDateTo() != null) && !TimeUtils.dateEqual((Date)oldInetServ.getDateTo(), (Date)newInetServ.getDateTo());
        ResourceService resourceService = (ResourceService)this.context.getService(ResourceService.class, this.moduleId);
        List ipResourceCategoryIds = this.inetServService.ipResourceCategoryIds(newInetServ.getDeviceId(), newInetServ.getInterfaceId(), newInetServ.getTypeId());
        if (oldInetServ != null) {
            boolean need = true;
            for (IpResource ipResource : resourceService.ipResourceList((Collection)ipResourceCategoryIds)) {
                if (oldInetServ.getIpResourceId() != ipResource.getId()) continue;
                need = false;
                break;
            }
            needSubscription |= need;
        }
        if (needSubscription) {
            try (InetServDao inetServDao = new InetServDao(this.context.getConnectionSet().getConnection(), this.moduleId);){
                if (oldInetServ != null && oldPrefix != null) {
                    if ("Framed".equals(prefixType)) {
                        resourceService.ipResourceUnsubscribe(subscriberId, oldInetServ.getFramedIPv6PrefixResourceSubscriptionId(), oldPrefix, new IpNet(oldPrefix, (int)oldPrefixLength).getBroadcast());
                        newInetServ.setFramedIPv6PrefixResourceId(0);
                        newInetServ.setFramedIPv6PrefixResourceSubscriptionId(0);
                    } else if ("Delegated".equals(prefixType)) {
                        resourceService.ipResourceUnsubscribe(subscriberId, oldInetServ.getDelegatedIPv6PrefixResourceSubscriptionId(), oldPrefix, new IpNet(oldPrefix, (int)oldPrefixLength).getBroadcast());
                        newInetServ.setDelegatedIPv6PrefixResourceId(0);
                        newInetServ.setDelegatedIPv6PrefixResourceSubscriptionId(0);
                    }
                    inetServDao.update((Entity)newInetServ);
                }
                if (newPrefix != null) {
                    IpResourceSubscription subscription = resourceService.ipResourceSubscribe(subscriberId, subscriberTitle, (Collection)ipResourceCategoryIds, 0, newPrefix, new IpNet(newPrefix, (int)newPrefixLength).getBroadcast(), newInetServ.getDateFrom(), newInetServ.getDateTo());
                    if ("Framed".equals(prefixType)) {
                        newInetServ.setFramedIPv6PrefixResourceId(subscription.getIpResourseId());
                        newInetServ.setFramedIPv6PrefixResourceSubscriptionId(subscription.getId());
                    } else if ("Delegated".equals(prefixType)) {
                        newInetServ.setDelegatedIPv6PrefixResourceId(subscription.getIpResourseId());
                        newInetServ.setDelegatedIPv6PrefixResourceSubscriptionId(subscription.getId());
                    }
                    inetServDao.update((Entity)newInetServ);
                }
            }
        }
    }

    protected IpResult tryReserveIPv4FromPool(InetServIpData inetServIpData, RadiusPacket request) {
        this.logger.debug("Try to reserve dynamic IPv4.");
        String identifier = (String)request.getOption(InetRadiusProcessor.IDENTIFIER);
        InetServ inetServ = inetServIpData.getInetServ();
        InetNas inetNas = inetServIpData.getInetNas();
        String realm = inetServIpData.getIpRealm();
        String username = inetServIpData.getUsername();
        int agentDeviceId = inetServIpData.getAgentDeviceId();
        String callingStationId = request.getStringAttribute(-1, 31, "");
        Set<Integer> optionSet = inetServIpData.getOptionSet();
        byte[] macAddress = InetServ.parseMacAddress((String)((String)request.getOption(InetRadiusProcessor.MAC_ADDRESS)));
        if (macAddress == null) {
            macAddress = (byte[])request.getOption(InetRadiusProcessor.MAC_ADDRESS_BYTES);
        }
        IpResult result = new IpResult();
        IpResourceReserve reserve = inetNas.reserveIp(agentDeviceId, inetServ.getId(), username, macAddress, callingStationId, identifier, realm, null, optionSet, IpResourceEntry.AddressType.Default);
        if (reserve != null) {
            this.logger.debug("Set IPv4 from pool: ip={}, ipResourceId={}", (Object)reserve.getAddress(), (Object)reserve.getIpResourceId());
            result.setIpAddress(reserve.getAddress());
            result.setIpResourceId(reserve.getIpResourceId());
        }
        return result;
    }

    protected class IpResult {
        private int ipResourceId = 0;
        private byte[] ipAddress = null;

        public int getIpResourceId() {
            return this.ipResourceId;
        }

        public void setIpResourceId(int ipResourceId) {
            this.ipResourceId = ipResourceId;
        }

        public byte[] getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(byte[] ipAddress) {
            this.ipAddress = ipAddress;
        }
    }
}

