/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.InetAuthErrorWorker;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListener;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorkerContext;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAuthError;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAuthErrorDao;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasConnection;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.common.model.Idable;
import ru.bitel.common.sql.ConnectionSet;

public class InetRadiusListenerWorker
extends RadiusListenerWorker<InetNas> {
    protected static final Logger logger = LogManager.getLogger();
    protected static final Logger loggerUpdate = LogManager.getLogger((String)(InetRadiusListenerWorker.class.getName() + ".update"));
    private final InetRadiusProcessor processor;

    public static InetRadiusListenerWorker get() {
        return (InetRadiusListenerWorker)((Object)worker.get());
    }

    public InetRadiusListenerWorker(RadiusListener<InetNas> listener, SocketAddress clientAddress, long millis, ByteBuffer data, int overloadLevel) {
        super(listener, clientAddress, millis, data, overloadLevel);
        this.processor = (InetRadiusProcessor)((RadiusListenerWorker)this).processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accessRequest(InetNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) throws BGException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        try {
            this.processor.accessRequest(this, nas, 0, request, response, connectionSet);
            connectionSet.commit();
            if (this.radiusSession != null && this.radiusSession.errorCode != 0) {
                // empty if block
            }
        }
        finally {
            ByteBuffer responseData = ByteBuffer.allocate(4096);
            response.write(responseData, nas.getSecret());
            responseData.flip();
            long millis = System.currentTimeMillis();
            long duration = millis - this.millis;
            this.send(this.clientAddress, responseData);
            if (logger.isInfoEnabled()) {
                logger.info("RESPONSE (" + duration + "ms):\n" + response.toString());
            }
            try {
                responseData.rewind();
                this.writeAccessLog(connectionSet, time, responseData);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void writeAccessLog(ConnectionSet connectionSet, Date time, ByteBuffer responseData) throws InvalidKeyException, NoSuchAlgorithmException, BGException, InterruptedException {
        Integer accessCode;
        boolean accept;
        if (this.radiusSession.errorCode == 110) {
            return;
        }
        boolean bl = accept = this.response.getCode() == 2;
        if (!accept && this.response.getCode() != 3) {
            return;
        }
        int[] requestPositions = new int[3];
        int[] responsePositions = new int[3];
        this.data.rewind();
        ((RadiusListenerWorkerContext)this.context).writeRecord((Idable)this.nas, requestPositions, this.data, time.getTime());
        ((RadiusListenerWorkerContext)this.context).writeRecord((Idable)this.nas, responsePositions, responseData, time.getTime());
        responseData.rewind();
        ConnectionLogEntry entry = new ConnectionLogEntry();
        entry.setApplicationId(this.processor.applicationId);
        entry.setDeviceId(((InetNas)this.nas).getId());
        entry.setDevicePort(RadiusUtils.getNasPort((RadiusPacket)this.request));
        entry.setConnectionId(this.connectionId);
        entry.setTime(time);
        entry.setAcctSessId(this.request.getStringAttribute(-1, 44, ""));
        entry.setLogType(1);
        entry.setRequestDataLogId(requestPositions[0]);
        entry.setRequestChunkId(requestPositions[1]);
        entry.setRequestPosition(requestPositions[2]);
        entry.setResponseDataLogId(responsePositions[0]);
        entry.setResponseChunkId(responsePositions[1]);
        entry.setResponsePosition(responsePositions[2]);
        if (accept) {
            ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(connectionSet, this.processor.moduleId);
            dataLogEntryDao.update(entry);
            dataLogEntryDao.recycle();
        }
        if ((accessCode = (Integer)this.request.getOption(InetRadiusProcessor.ACCESS_CODE)) != null) {
            this.accessCode = this.radiusSession.errorCode = accessCode.intValue();
        }
        if (this.radiusSession.errorCode != 0) {
            InetAuthError error = new InetAuthError();
            error.setDeviceId(((InetNas)this.nas).getId());
            error.setDeviceTitle(((InetNas)this.nas).getNasIdentifier());
            if (this.radiusSession.contract != null) {
                error.setContractId(this.radiusSession.contract.getId());
                error.setContractTitle(this.radiusSession.contract.getTitle());
            }
            if (this.radiusSession.errorCode == 1) {
                error.setServTitle(((InetNas)this.nas).getInvalidAccountErrorFormatter().format(this.request));
            } else if (this.radiusSession.login != null) {
                InetServ serv = (InetServ)this.radiusSession.login;
                error.setServId(serv.getId());
                error.setServTitle(serv.getTitle());
            }
            error.setLogCoordinateRecordId(entry.getId());
            error.setErrorCode(this.radiusSession.errorCode);
            InetAuthErrorWorker authErrorWorker = this.processor.access.authErrorWorker;
            if (authErrorWorker != null) {
                if (!authErrorWorker.offer(entry.getId() > 0 ? error : new InetAuthErrorWorker.InetAuthErrorTask(error, entry))) {
                    logger.warn("Auth error not writed to DB. Queue is full.");
                }
            } else {
                if (!accept) {
                    ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(connectionSet, this.processor.moduleId);
                    dataLogEntryDao.update(entry);
                    dataLogEntryDao.recycle();
                }
                InetAuthErrorDao authErrorDao = new InetAuthErrorDao(connectionSet, this.processor.moduleId, new Date());
                authErrorDao.addError(error, this.processor.access.authErrorUpdate);
                authErrorDao.recycle();
            }
        }
    }

    protected void accountingRequest(InetNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) throws BGException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        InetConnectionCallRuntime connectionRuntime;
        int[] coords = new int[3];
        ((RadiusListenerWorkerContext)this.context).writeRecord((Idable)nas, coords, this.data, time.getTime());
        InetNasConnection nasConnection = (InetNasConnection)this.processor.accountingRequest(this, nas, request, response, connectionSet, time);
        long connectionId = nasConnection != null && (connectionRuntime = nasConnection.getSession()) != null ? connectionRuntime.connectionId : 0L;
        if (this.isConnectionModified()) {
            ConnectionLogEntry entry = new ConnectionLogEntry();
            entry.setApplicationId(this.processor.applicationId);
            entry.setDeviceId(nas.getId());
            entry.setDevicePort(RadiusUtils.getNasPort((RadiusPacket)request));
            entry.setTime(time);
            entry.setAcctSessId(request.getStringAttribute(-1, 44, ""));
            entry.setConnectionId(connectionId);
            entry.setLogType(2);
            entry.setRequestDataLogId(coords[0]);
            entry.setRequestChunkId(coords[1]);
            entry.setRequestPosition(coords[2]);
            ConnectionLogEntryDao connectionLogEntryDao = new ConnectionLogEntryDao(connectionSet, this.processor.moduleId);
            connectionLogEntryDao.update(entry);
            connectionLogEntryDao.recycle();
        }
    }
}

