/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff;

import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class DeviceAllowTariffTreeNode
extends TariffTreeNode<InetTariffRequest, InetTariffContext, TreeContext, InetTariffWorkerContext> {
    private static final Logger logger = LogManager.getLogger();
    private final Set<Integer> deviceIds;
    private volatile long deviceMapVersion = -1L;
    private volatile Set<Integer> deviceIdsWithDescendants;

    public DeviceAllowTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.deviceIds = Utils.toIntegerSet((String)parameterMap.get("deviceIds", null));
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, InetTariffContext context, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        InetDeviceMap deviceMap = context.deviceMap;
        long deviceMapVersion = deviceMap.getVersion();
        Set<Integer> deviceIdsWithDescendants = this.deviceIdsWithDescendants;
        if (deviceIdsWithDescendants == null || this.deviceMapVersion != deviceMapVersion) {
            deviceIdsWithDescendants = new HashSet<Integer>();
            for (Integer deviceId : this.deviceIds) {
                deviceIdsWithDescendants.add(deviceId);
                try {
                    InetDeviceMap.InetDeviceMapItem device = deviceMap.get(deviceId);
                    if (device == null) continue;
                    deviceIdsWithDescendants.addAll(device.getDescendantIds());
                }
                catch (BGException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            this.deviceIdsWithDescendants = deviceIdsWithDescendants;
            this.deviceMapVersion = deviceMapVersion;
        }
        if (deviceIdsWithDescendants.size() == 0 || deviceIdsWithDescendants.contains(req.deviceId)) {
            return 1;
        }
        req.setAccessCode(40);
        return 0;
    }
}

