/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff.max;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficMaxDetail;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMax;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxKey;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Pair;
import ru.bitel.common.worker.Recyclable;

public class TrafficMaxDao
implements Recyclable {
    public static final String TABLE_INET_TARIFF_TRAFFIC_MAX = "inet_tariff_traffic_max";
    public static final String TABLE_INET_TARIFF_TRAFFIC_MAX_DETAIL = "inet_tariff_traffic_max_detail";
    private final Connection con;
    private final int moduleId;
    private final String tableName;
    private final PreparedStatement selectCounterAndAmountPS;
    private PreparedStatement updateAndSelectAmountPS;
    private PreparedStatement insertPS;
    private PreparedStatement updateDetailPS;
    private PreparedStatement insertDetailPS;
    private Date month;
    private int yy;
    private int mm;
    private PreparedStatement selectAmountPS = null;

    public TrafficMaxDao(Connection con, int moduleId) throws BGException {
        this.con = con;
        this.moduleId = moduleId;
        this.tableName = "inet_tariff_traffic_max_" + moduleId;
        try {
            this.selectCounterAndAmountPS = con.prepareStatement("SELECT @counter, @amountMax, @amount1, @amount2");
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setCurrentMonth(Date month) throws BGException {
        this.month = month;
        Calendar calendar = TimeUtils.convertDateToCalendar((Date)this.month);
        this.yy = calendar.get(1);
        this.mm = calendar.get(2) + 1;
        try {
            if (this.insertPS != null) {
                this.insertPS.close();
            }
            if (this.updateDetailPS != null) {
                this.updateDetailPS.close();
            }
            if (this.insertDetailPS != null) {
                this.insertDetailPS.close();
            }
            if (this.updateAndSelectAmountPS != null) {
                this.updateAndSelectAmountPS.close();
            }
            this.updateAndSelectAmountPS = this.con.prepareStatement("UPDATE " + this.tableName + " SET counter=counter+1, amountMax=amountMax+?, amount1=amount1+?, amount2=amount2+? WHERE contractId=? AND treeNodeId=? AND maxKey=? AND yy=? AND mm = ? AND (@counter:=counter) IS NOT NULL AND (@amountMax:=amountMax) IS NOT NULL AND (@amount1:=amount1) IS NOT NULL AND (@amount2:=amount2) IS NOT NULL");
            this.insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (contractId, treeNodeId, maxKey, counter, amountMax, amount1, amount2, yy, mm ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ? )");
            String detailTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_TARIFF_TRAFFIC_MAX_DETAIL, (Date)month, (int)this.moduleId);
            this.updateDetailPS = this.con.prepareStatement("UPDATE " + detailTableName + " SET amountMax=amountMax+?, amount1=amount1+?, amount2=amount2+? WHERE contractId=? AND treeNodeId=? AND maxKey=? AND day=?");
            this.insertDetailPS = this.con.prepareStatement("INSERT INTO " + detailTableName + " (contractId, treeNodeId, maxKey, day, amountMax, amount1, amount2) VALUES (?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public int add(int contractId, TrafficMaxKey rangeKey, int day, long amountMax, long amount1, long amount2, long[] amountMaxRef, int counter) throws BGException {
        try {
            PreparedStatement updatePS = this.updateAndSelectAmountPS;
            updatePS.setLong(1, amountMax);
            updatePS.setLong(2, amount1);
            updatePS.setLong(3, amount2);
            updatePS.setInt(4, contractId);
            updatePS.setLong(5, rangeKey.treeNodeId);
            updatePS.setLong(6, rangeKey.key);
            updatePS.setLong(7, this.yy);
            updatePS.setLong(8, this.mm);
            int i = 0;
            while (true) {
                if (updatePS.executeUpdate() > 0) {
                    ResultSet rs = this.selectCounterAndAmountPS.executeQuery();
                    if (rs.next()) {
                        counter = rs.getInt(1) + 1;
                        if (amountMaxRef != null) {
                            amountMaxRef[0] = rs.getLong(2) + amountMax;
                            amountMaxRef[1] = rs.getLong(3) + amount1;
                            amountMaxRef[2] = rs.getLong(4) + amount2;
                        }
                    } else {
                        counter = 0;
                        if (amountMaxRef != null) {
                            amountMaxRef[0] = amountMax;
                            amountMaxRef[1] = amount1;
                            amountMaxRef[2] = amount2;
                        }
                    }
                    rs.close();
                    break;
                }
                try {
                    PreparedStatement insertPS = this.insertPS;
                    insertPS.setInt(1, contractId);
                    insertPS.setLong(2, rangeKey.treeNodeId);
                    insertPS.setLong(3, rangeKey.key);
                    insertPS.setLong(4, counter + 1);
                    insertPS.setLong(5, amountMax);
                    insertPS.setLong(6, amount1);
                    insertPS.setLong(7, amount2);
                    insertPS.setLong(8, this.yy);
                    insertPS.setLong(9, this.mm);
                    insertPS.executeUpdate();
                    ++counter;
                    if (amountMaxRef == null) break;
                    amountMaxRef[0] = amountMax;
                    amountMaxRef[1] = amount1;
                    amountMaxRef[2] = amount2;
                }
                catch (SQLException e) {
                    if (e.getSQLState() == null || !e.getSQLState().startsWith("23") || i > 10) {
                        throw e;
                    }
                    ++i;
                    continue;
                }
                break;
            }
            this.addDetail(contractId, rangeKey, day, amountMax, amount1, amount2);
            return counter;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void addDetail(int contractId, TrafficMaxKey rangeKey, int day, long amountMax, long amount1, long amount2) throws SQLException {
        PreparedStatement updatePS = this.updateDetailPS;
        updatePS.setLong(1, amountMax);
        updatePS.setLong(2, amount1);
        updatePS.setLong(3, amount2);
        updatePS.setInt(4, contractId);
        updatePS.setLong(5, rangeKey.treeNodeId);
        updatePS.setLong(6, rangeKey.key);
        updatePS.setLong(7, day);
        int i = 0;
        while (updatePS.executeUpdate() <= 0) {
            try {
                PreparedStatement insertPS = this.insertDetailPS;
                insertPS.setInt(1, contractId);
                insertPS.setLong(2, rangeKey.treeNodeId);
                insertPS.setLong(3, rangeKey.key);
                insertPS.setLong(4, day);
                insertPS.setLong(5, amountMax);
                insertPS.setLong(6, amount1);
                insertPS.setLong(7, amount2);
                insertPS.executeUpdate();
                break;
            }
            catch (SQLException e) {
                if (e.getSQLState() == null || !e.getSQLState().startsWith("23") || i > 10) {
                    throw e;
                }
                ++i;
            }
        }
    }

    public static void checkTables(Connection con, Statement stmt, Date date, int mid) throws SQLException {
        String trafficRangeDetailTableName;
        String trafficMaxTableName = "inet_tariff_traffic_max_" + mid;
        if (!ServerUtils.tableExists((Connection)con, (String)trafficMaxTableName)) {
            stmt.executeUpdate("CREATE TABLE `" + trafficMaxTableName + "` (`contractId` int(11) NOT NULL,`treeNodeId` bigint(20) NOT NULL,`maxKey` bigint(20) NOT NULL,`counter` int(11) NOT NULL,`yy` int(11) NOT NULL,`mm` int(11) NOT NULL,`amountMax` bigint(20) NOT NULL,`amount1` bigint(20) NOT NULL,`amount2` bigint(20) NOT NULL,PRIMARY KEY (`contractId`,`treeNodeId`,`maxKey`,`yy`,`mm`) ) /*!50100 PARTITION BY HASH( contractId ) PARTITIONS 8*/");
        }
        if (!ServerUtils.tableExists((Connection)con, (String)(trafficRangeDetailTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_TARIFF_TRAFFIC_MAX_DETAIL, (Date)date, (int)mid)))) {
            stmt.executeUpdate("CREATE TABLE `" + trafficRangeDetailTableName + "` ( `contractId` INT NOT NULL, `treeNodeId` bigint(20) NOT NULL, `maxKey` bigint(20) NOT NULL, `day` INT NOT NULL, `amountMax` bigint(20) NOT NULL, `amount1` bigint(20) NOT NULL, `amount2` bigint(20) NOT NULL, PRIMARY KEY `key`(`contractId`, `treeNodeId`, `maxKey`, `day`) ) /*!50100 PARTITION BY HASH( contractId ) PARTITIONS 8*/");
        }
    }

    public void get(int contractId, TrafficMaxKey key, TrafficMax max) throws BGException {
        try {
            PreparedStatement ps = this.selectAmountPS;
            if (ps == null) {
                ps = this.selectAmountPS = this.con.prepareStatement("SELECT counter, amountMax, amount1, amount2 FROM " + this.tableName + " WHERE contractId=? AND treeNodeId=? AND maxKey=? ORDER BY yy DESC, mm DESC LIMIT 1");
            }
            ps.setInt(1, contractId);
            ps.setLong(2, key.treeNodeId);
            ps.setLong(3, key.key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                max.counter = rs.getInt(1);
                max.amountMax = rs.getLong(2) + max.deltaMax;
                max.amount1 = rs.getLong(3) + max.delta1;
                max.amount2 = rs.getLong(4) + max.delta2;
            } else {
                max.counter = 0;
                max.amountMax = 0L;
                max.amount1 = 0L;
                max.amount2 = 0L;
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<TrafficMaxDetail> listDetail(int contractId, long treeNodeId, Date dateFrom, Date dateTo) throws BGException {
        try {
            ArrayList<TrafficMaxDetail> result = new ArrayList<TrafficMaxDetail>();
            String tableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_TARIFF_TRAFFIC_MAX_DETAIL, (Date)dateFrom, (int)this.moduleId);
            if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                return result;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateFrom);
            int dayFrom = calendar.get(5);
            calendar.setTime(dateTo);
            int dayTo = calendar.get(5);
            PreparedStatement ps = this.con.prepareStatement("SELECT day, maxKey, amountMax, amount1, amount2 FROM " + tableName + " WHERE contractId=? AND treeNodeId=? AND day>=? AND day<=? ORDER BY day, maxKey");
            ps.setInt(1, contractId);
            ps.setLong(2, treeNodeId);
            ps.setLong(3, dayFrom);
            ps.setLong(4, dayTo);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int day = rs.getInt(1);
                long maxKey = rs.getLong(2);
                long amountMax = rs.getLong(3);
                long amount1 = rs.getLong(4);
                long amount2 = rs.getLong(5);
                TrafficMaxDetail detail = new TrafficMaxDetail();
                detail.setMaxKey(maxKey);
                detail.setAmountMax(amountMax);
                detail.setAmount1(amount1);
                detail.setAmount2(amount2);
                detail.setDay(day);
                detail.setHour(TrafficMaxKey.getHourOfDay(maxKey, calendar));
                result.add(detail);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Pair<TrafficMaxKey, TrafficMax>> list(int contractId, long treeNodeId, long keyMin, long keyMax) throws BGException {
        try {
            ArrayList<Pair<TrafficMaxKey, TrafficMax>> result = new ArrayList<Pair<TrafficMaxKey, TrafficMax>>();
            PreparedStatement ps = this.con.prepareStatement("SELECT maxKey, amountMax, amount1, amount2 FROM " + this.tableName + " WHERE contractId=? AND treeNodeId=? AND (? OR maxKey>=?) AND (? OR maxKey<=?) ORDER BY maxKey, yy, mm");
            ps.setInt(1, contractId);
            ps.setLong(2, treeNodeId);
            ps.setBoolean(3, keyMin == -1L);
            ps.setLong(4, keyMin);
            ps.setBoolean(5, keyMax == -1L);
            ps.setLong(6, keyMax);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long maxKey = rs.getLong(1);
                long amountMax = rs.getLong(2);
                long amount1 = rs.getLong(3);
                long amount2 = rs.getLong(4);
                TrafficMaxKey key = new TrafficMaxKey(treeNodeId, maxKey);
                TrafficMax max = new TrafficMax(0, amountMax, amount1, amount2);
                result.add((Pair<TrafficMaxKey, TrafficMax>)new Pair((Object)key, (Object)max));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void recycle() {
        ServerUtils.recycle((Object[])new Object[]{this.selectCounterAndAmountPS, this.updateAndSelectAmountPS, this.insertPS, this.updateDetailPS, this.insertDetailPS});
    }
}

