/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff.max;

import java.util.Calendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.common.TimeUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public final class TrafficMaxKey {
    @XmlAttribute
    long treeNodeId;
    @XmlAttribute
    long key;

    public static final int getMode(long key) {
        return (int)(key >> 56);
    }

    public static final long getId(long key) {
        return (int)(key & 0xFFFFFFFFFFFFFFL);
    }

    public static final long getKey(int mode, int accountingPeriodId, int contractTariffOptionId, Calendar time) {
        long key = 0L;
        switch (mode) {
            case 1: {
                key |= (long)accountingPeriodId;
                key |= 0x100000000000000L;
                break;
            }
            case 2: {
                key |= (long)time.get(2);
                key |= (long)time.get(1) << 16;
                key |= 0x200000000000000L;
                break;
            }
            case 3: {
                key |= (long)time.get(6);
                key |= (long)time.get(1) << 16;
                key |= 0x300000000000000L;
                break;
            }
            case 4: {
                long hour = time.getTimeInMillis() / 3600000L;
                key |= hour;
                key |= 0x400000000000000L;
                break;
            }
            case 5: {
                key |= (long)contractTariffOptionId;
                key |= 0x500000000000000L;
                break;
            }
        }
        return key;
    }

    public static final Calendar getTime(long key, Calendar time) {
        int mode = TrafficMaxKey.getMode(key);
        switch (mode) {
            case 2: {
                int month = (int)(key & 0xFFFFL);
                int year = (int)(key >> 16 & 0xFFFFL);
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)time);
                time.set(5, 1);
                time.set(2, 0);
                time.set(1, year);
                time.set(2, month);
                return time;
            }
            case 3: {
                int dayOfYear = (int)(key & 0xFFFFL);
                int year = (int)(key >> 16 & 0xFFFFL);
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)time);
                time.set(5, 1);
                time.set(2, 0);
                time.set(1, year);
                time.set(6, dayOfYear);
                return time;
            }
            case 4: {
                long hour = key & 0xFFFFFFFFFFFFL;
                time.setTimeInMillis(hour * 3600000L);
                return time;
            }
        }
        return null;
    }

    public static final int getHourOfDay(long key, Calendar time) {
        int mode = TrafficMaxKey.getMode(key);
        switch (mode) {
            case 4: {
                long hour = key & 0xFFFFFFFFFFFFL;
                time.setTimeInMillis(hour * 3600000L);
                return time.get(11);
            }
        }
        return -1;
    }

    public TrafficMaxKey() {
    }

    public TrafficMaxKey(long treeNodeId, long key) {
        this.treeNodeId = treeNodeId;
        this.key = key;
    }

    public TrafficMaxKey(long treeNodeId, int mode, int accountingPeriodId, int contractTariffOptionId, Calendar time) {
        this.setKey(treeNodeId, mode, accountingPeriodId, contractTariffOptionId, time);
    }

    public void setKey(long treeNodeId, long key) {
        this.treeNodeId = treeNodeId;
        this.key = key;
    }

    public void setKey(long treeNodeId, int mode, int accountingPeriodId, int contractTariffOptionId, Calendar time) {
        long key;
        this.treeNodeId = treeNodeId;
        this.key = key = TrafficMaxKey.getKey(mode, accountingPeriodId, contractTariffOptionId, time);
    }

    public int hashCode() {
        return 31 * (31 + (int)(this.key ^ this.key >>> 32)) + (int)(this.treeNodeId ^ this.treeNodeId >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        TrafficMaxKey other = (TrafficMaxKey)obj;
        return this.treeNodeId == other.treeNodeId && this.key == other.key;
    }

    public String toString() {
        return "MaxKey[" + this.treeNodeId + ":" + TrafficMaxKey.getMode(this.key) + ":" + TrafficMaxKey.getId(this.key) + "]";
    }

    public long getTreeNodeId() {
        return this.treeNodeId;
    }

    public long getKey() {
        return this.key;
    }
}

