/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import bitel.billing.module.common.BGDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.xml.ws.soap.SOAPFaultException;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGFilterPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.modules.inet.client.InetContractMonitorPanel;
import ru.bitel.bgbilling.modules.inet.client.InvDevicePanel;
import ru.bitel.bgbilling.modules.inet.client.device.InetDeviceFormMain;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InvDevice;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.GroupParent;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.bean.DevicePortSubscription;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceService;

public class InetDevicePanel
extends DevicePanel<InetDevice, InetDeviceType>
implements GroupParent {
    private static final String CONTRACT_MODE = "contracts";
    private static final String COMMAND_EXEC = "exec:";
    AbstractBGUPanel.DefaultAction reloadAction;
    AbstractBGUPanel.MenuAction saReinit;
    AbstractBGUPanel.MenuAction manage;
    AbstractBGUPanel.MenuAction contracts;
    JPanel editorPanel = new JPanel();
    private InetDeviceService inetDeviceService = null;
    InetContractMonitorPanel contractPanel = new InetContractMonitorPanel();
    AbstractBGUPanel.MenuAction portContract = new AbstractBGUPanel.MenuAction("port.contract", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            DeviceInterface iface = (DeviceInterface)e.getSource();
            if (iface == null || iface.getSubscriberId() <= 0) {
                return;
            }
            InetServService servService = (InetServService)((ClientContext)InetDevicePanel.this.getContext()).getPort(InetServService.class);
            InetServ serv = servService.inetServGet(iface.getSubscriberId());
            if (serv == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0421\u0435\u0440\u0432\u0438\u0441 Inet \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                return;
            }
            InetDevicePanel.this.openContract(serv.getContractId());
        }
    };
    AbstractBGUPanel.MenuAction portSubscriptionContract = new AbstractBGUPanel.MenuAction("devicePortSubscription.contract", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            DevicePortSubscription portSubscription = (DevicePortSubscription)e.getSource();
            if (portSubscription == null || portSubscription.getSubscriberId() <= 0) {
                return;
            }
            InetServService servService = (InetServService)((ClientContext)InetDevicePanel.this.getContext()).getPort(InetServService.class);
            InetServ serv = servService.inetServGet(portSubscription.getSubscriberId());
            if (serv == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0421\u0435\u0440\u0432\u0438\u0441 Inet \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return;
            }
            InetDevicePanel.this.openContract(serv.getContractId());
        }
    };

    public InetDevicePanel(ClientContext ctx) {
        this(ctx, 1, null);
    }

    public InetDevicePanel(ClientContext ctx, int mode, ActionListener actionListener) {
        super(ctx, mode, actionListener);
        if (mode == 1) {
            this.contracts = new AbstractBGUPanel.MenuAction("device.contracts", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b", ClientUtils.getIcon((String)"fugue/folder-open-document-text")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    int id = ((InetDevice)InetDevicePanel.this.model.getSelectedRow()).getId();
                    InetDevicePanel.this.contractPanel.setDeviceId(id);
                    InetDevicePanel.this.contractPanel.setData(InetDevicePanel.this.getInetDeviceService().getContracts(id));
                    ((CardLayout)InetDevicePanel.this.editorPanel.getLayout()).show(InetDevicePanel.this.editorPanel, InetDevicePanel.CONTRACT_MODE);
                    InetDevicePanel.this.editorPanel.setVisible(true);
                }
            };
            this.saReinit = new AbstractBGUPanel.MenuAction("device.saReinit", "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441\u044b", ClientUtils.getIcon((String)"fugue/arrow-repeat")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetDevice device = (InetDevice)InetDevicePanel.this.model.getSelectedRow();
                    if (device != null && device.getId() > 0 && BGSwingUtilites.confirm((String)"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u044b \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0435", (Object)device)) {
                        InetDevicePanel.this.getInetDeviceService().deviceSaReinit(device.getId());
                    }
                }
            };
            this.manage = new AbstractBGUPanel.MenuAction("device.manage", "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443", ClientUtils.getIcon((String)"fugue/terminal-network")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    String operation;
                    InetDevice device = (InetDevice)InetDevicePanel.this.model.getSelectedRow();
                    if (device != null && device.getId() > 0 && Utils.notBlankString((String)(operation = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443?", "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443", 3)))) {
                        InetDevicePanel.this.executeCommand(device, operation);
                    }
                }
            };
            new AbstractBGUPanel.MenuAction("device.stopConnections", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0432 \u0411\u0414", ClientUtils.getIcon((String)"fugue/plug--minus")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetDevice device = (InetDevice)InetDevicePanel.this.model.getSelectedRow();
                    if (device == null || device.getId() <= 0) {
                        return;
                    }
                    String s = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0430\u0439\u043c\u0430\u0443\u0442 (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445) \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438\n\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0432 \u0411\u0414:", "\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439", 2, null, null, "0");
                    if (s == null) {
                        return;
                    }
                    ((InetSessionService)((ClientContext)InetDevicePanel.this.getContext()).getPort(InetSessionService.class)).connectionsStop(device.getId(), Utils.parseLong((String)s, (long)0L));
                }
            };
            new AbstractBGUPanel.MenuAction("device.__skipSaEvent", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438", ClientUtils.getIcon((String)"fugue/traffic-cone--minus")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    String result;
                    InetDevice device = (InetDevice)InetDevicePanel.this.model.getSelectedRow();
                    if (device != null && device.getId() > 0 && BGSwingUtilites.confirm((String)"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438", (Object)device) && Utils.notBlankString((String)(result = InetDevicePanel.this.getInetDeviceService().deviceManage(device.getInvDeviceId(), device.getId(), "__skipSaEvent:" + device.getId(), 0, 0, 20000L)))) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), result, "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442", 0);
                    }
                }
            };
        }
    }

    protected void jbInit() {
        super.jbInit();
    }

    protected BGTreeTableModel<InetDevice> newModel() {
        return new InetDeviceTableModel();
    }

    public boolean isLibrary() {
        return false;
    }

    protected String getTitle(InetDevice val, Calendar calendar) {
        String title = val.getTitle();
        Object result = title;
        if (val.getEntityId() == -100) {
            result = "<html><font color='#666666'>" + (String)result + "</font></html>";
        } else if (title.equals(val.getInvTitle())) {
            if (title != val.getInvTitle()) {
                val.setTitle(val.getInvTitle());
            }
            if (val.getDateTo() != null) {
                calendar.setTime(val.getDateTo());
                if (TimeUtils.dateBefore((Calendar)calendar, (Calendar)this.currentDay)) {
                    result = "<html><font color='#666666'>" + (String)result + "</font></html>";
                }
            }
        } else if (val.getDateTo() != null) {
            calendar.setTime(val.getDateTo());
            if (TimeUtils.dateBefore((Calendar)calendar, (Calendar)this.currentDay)) {
                result = "<html><font color='#666666'>" + (String)result + "</font></html>";
            }
        } else {
            result = "<html>" + (String)result + "</html>";
        }
        return result;
    }

    protected void initEditor(BGEditor editor) {
        super.initEditor(editor);
        editor.addForm((JComponent)((Object)new MenuForm()));
        editor.addForm((JComponent)((Object)new MenuForm2()));
    }

    private static void browse(ClientContext context, String url) {
        try {
            ClientUtils.openBrowser((URI)new URI(url));
        }
        catch (Exception e) {
            context.processException((Throwable)e);
        }
    }

    private static void telnet(ClientContext context, String telnet) {
        try {
            int port = 21;
            int index = telnet.lastIndexOf(32);
            if (index > 0) {
                port = Utils.parseInt((String)telnet.substring(index + 1), (int)21);
                telnet = telnet.substring(0, index);
            }
            ClientUtils.openTelnet((String)telnet, (int)port);
        }
        catch (Exception e) {
            context.processException((Throwable)e);
        }
    }

    private static void exec(ClientContext context, String command) {
        try {
            ClientUtils.exec((String)command);
        }
        catch (Exception e) {
            context.processException((Throwable)e);
        }
    }

    private static void ping(ClientContext context, String host) {
        try {
            boolean win = System.getProperty("os.name").toLowerCase().contains("win");
            String cmd = win ? "ping -t " + host : "ping " + host;
            ClientUtils.openTerminal((String)cmd);
        }
        catch (Exception e) {
            context.processException((Throwable)e);
        }
    }

    protected void executeCommand(InetDevice device, String operation) throws BGException {
        InetDevicePanel.executeCommand((ClientContext)this.getContext(), device.getInvDeviceId(), device.getId(), operation, 0, 0);
    }

    public static void executeCommand(ClientContext context, int invDeviceId, int inetDeviceId, String operation, int servId, int connectionId) throws BGException {
        JTextPane textArea = new JTextPane();
        textArea.setEditable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane(textArea), (boolean)true), "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout());
        panel.add((Component)bottomPanel, "South");
        BGButton button = new BGButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        bottomPanel.add((Component)button, "South");
        BGDialog dialog = new BGDialog();
        dialog.add((Component)panel);
        dialog.pack();
        dialog.setMinimumSize(new Dimension(500, 400));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode mode = device.getDisplayMode();
        int width = mode.getWidth();
        int height = mode.getHeight();
        dialog.setLocation(width > 0 ? width >>> 1 : 0, height > 0 ? height >>> 1 : 0);
        dialog.setLocationRelativeTo((Component)JOptionPane.getRootFrame());
        textArea.setFont(new Font("Monospaced", 0, 12));
        textArea.setText("\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430...");
        Async future = Async.of(() -> ((InetDeviceService)context.getPort(InetDeviceService.class)).deviceManage(invDeviceId, inetDeviceId, operation, servId, connectionId, TimeUnit.MINUTES.toMillis(3L))).handle((result, ex) -> {
            SwingUtilities.invokeLater(() -> {
                if (ex != null) {
                    Throwable t = ex;
                    if (t instanceof CompletionException) {
                        t = t.getCause();
                    }
                    if (t instanceof SOAPFaultException && t.getCause() != null) {
                        t = t.getCause();
                    }
                    if (t instanceof BGRuntimeException) {
                        t = t.getCause();
                    }
                    if (t instanceof BGMessageException) {
                        textArea.setText(t.getMessage());
                    } else if (t instanceof BGIllegalAccessException) {
                        textArea.setText(t.getMessage());
                    } else {
                        StringWriter writer = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(writer);
                        t.printStackTrace(printWriter);
                        textArea.setText(((Object)writer).toString());
                    }
                    if (!dialog.isShowing()) {
                        dialog.showDialog();
                    }
                } else if (Utils.notBlankString((String)result)) {
                    if (result.startsWith("browse:")) {
                        String result2 = result.substring(7);
                        InetDevicePanel.browse(context, result2);
                        dialog.dispose();
                    } else if (result.startsWith("telnet:")) {
                        String result2 = result.substring(7);
                        InetDevicePanel.telnet(context, result2);
                        dialog.dispose();
                    } else if (result.startsWith("ping:")) {
                        String result2 = result.substring(5);
                        InetDevicePanel.ping(context, result2);
                        dialog.dispose();
                    } else if (result.startsWith(COMMAND_EXEC)) {
                        String command = result.substring(COMMAND_EXEC.length());
                        InetDevicePanel.exec(context, command);
                        dialog.dispose();
                    } else {
                        if (result.startsWith("<html>")) {
                            textArea.setContentType("text/html");
                        }
                        textArea.setText((String)result);
                        if (!dialog.isShowing()) {
                            dialog.showDialog();
                        }
                    }
                }
            });
            return result;
        });
        button.addActionListener(a -> {
            dialog.dispose();
            if (!future.getFuture().isDone()) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u043e\u043a\u043d\u0430 \u043d\u0435 \u043e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 2);
            }
        });
        String result2 = null;
        try {
            result2 = (String)future.getFuture().get(5L, TimeUnit.SECONDS);
            if (Utils.notBlankString((String)result2) && !dialog.isShowing()) {
                dialog.showDialog();
            }
        }
        catch (TimeoutException e) {
            if (!dialog.isShowing()) {
                dialog.showDialog();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public void setFilter(Set<Integer> deviceTypeIds, Set<Integer> deviceGroupIds) {
        this.filter.setDeviceGroupIds(deviceGroupIds);
        if (deviceTypeIds == null || deviceTypeIds.size() == 0 || deviceTypeIds.size() == 1 && deviceTypeIds.contains(-1)) {
            deviceTypeIds = null;
        }
        this.defaultDeviceTypeIds = deviceTypeIds;
    }

    protected void initActions() {
        super.initActions();
        this.reloadAction = new AbstractBGUPanel.DefaultAction("inetReload", "\u041f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e\n\u043d\u0430 \u0432\u0441\u0435\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445 InetAccess/InetAccounting?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                    InetDevicePanel.this.getInetDeviceService().deviceReload(0);
                }
            }
        };
    }

    protected JComponent treeWrap(BGFilterPane splitPane) {
        if (this.mode == 1) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JButton((Action)this.reloadAction), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
            panel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)splitPane, "Center");
            panel2.add((Component)panel, "South");
            this.editorPanel.setLayout(new CardLayout());
            this.editorPanel.add((Component)((Object)this.contractPanel), CONTRACT_MODE);
            this.editorPanel.setVisible(false);
            panel2.add((Component)this.editorPanel, "East");
            return panel2;
        }
        return splitPane;
    }

    protected Class<InetDevice> getDeviceClass() {
        return InetDevice.class;
    }

    public InetDevice newDevice() {
        return new InetDevice();
    }

    public InetDeviceType newDeviceType(int id, String title) {
        return new InetDeviceType(id, title);
    }

    public DeviceService getWs() {
        return this.getInetDeviceService();
    }

    public InetDeviceService getInetDeviceService() {
        if (this.inetDeviceService == null) {
            this.inetDeviceService = (InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class);
        }
        return this.inetDeviceService;
    }

    public InetDevice deviceGet(int id) throws BGException {
        return this.getInetDeviceService().inetDeviceGet(id);
    }

    public void deviceDelete(int id) throws BGException {
        this.getInetDeviceService().inetDeviceDelete(id);
    }

    public int deviceUpdate(InetDevice device) throws BGException {
        return this.getInetDeviceService().inetDeviceUpdate(device, true);
    }

    public void deviceMove(int id, Set<Integer> cutSet) throws BGException {
        this.getInetDeviceService().inetDeviceMove(id, cutSet);
    }

    public InetDevice deviceSourceRoot() throws BGException {
        return this.getInetDeviceService().deviceSourceRoot();
    }

    public InetDevice deviceRoot(String identifier, String host, Set<Integer> deviceTypeIds, Set<Integer> deviceGroupIds, Date dateFrom, Date dateTo, Date intersectDateFrom, Date intersectDateTo, List<FilterEntityAttr> entityFilter) throws BGException {
        JSONObject treeJsonObject = this.getInetDeviceService().inetDeviceTree();
        return this.getInetDeviceService().inetDeviceRoot(identifier, host, deviceTypeIds, deviceGroupIds, dateFrom, dateTo, intersectDateFrom, intersectDateTo, entityFilter, false, this.mode == 2 || this.mode == 1);
    }

    public int getInvDeviceId(InetDevice device) {
        return device.getInvDeviceId();
    }

    protected Class<InetDeviceType> getDeviceTypeClass() {
        return InetDeviceType.class;
    }

    protected BGUPanel newMainForm(AtomicReference<InetDevice> currentRef) {
        return new InetDeviceFormMain(this, currentRef);
    }

    protected void ok() {
        this.selectedDevice = (Device)this.model.getSelectedRow();
        if (this.selectedDevice == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            return;
        }
        if (((InetDevice)this.selectedDevice).getInvDeviceId() == 0) {
            return;
        }
        this.performDeviceSelected();
        this.performActionClose();
    }

    protected InetDevice getLoadingStateRoot() {
        InetDevice result = new InetDevice();
        result.setId(-1);
        return result;
    }

    protected class InetDeviceTableModel
    extends DevicePanel.DeviceTableModel {
        protected InetDeviceTableModel() {
            super((DevicePanel)InetDevicePanel.this);
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", Device.class, -1, 300, -1, "title", false);
            this.addColumn("SVLAN", -1, 60, 80, "svlan", false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", false);
            if (InetDevicePanel.this.mode != 3) {
                this.addColumn("SVLAN", 80, 80, 80, "svlan", false);
                this.addColumn("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430", 100, 100, 100, "sort", false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
                if (!InetDevicePanel.this.isLibrary() && InetDevicePanel.this.mode == 1) {
                    this.addColumn("InvDeviceID", 100, 100, 100, "invDeviceId", false).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
                    this.invDeviceIdCol = 3;
                }
                this.addColumnId(false);
            }
        }

        public Object getValue(InetDevice val, int column) throws BGException {
            if (column == 0) {
                return super.getValue((Device)val, column);
            }
            if (column == 1) {
                return val.getSvlan() < 0 ? "" : Integer.valueOf(val.getSvlan());
            }
            return super.getValue((Device)val, column);
        }
    }

    class MenuForm
    extends BGUPanel {
        AbstractBGUPanel.MenuAction copyFromLibrary = new AbstractBGUPanel.MenuAction("device.copyFromLibrary", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0437 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438", ClientUtils.getIcon((String)"fugue/servers-network")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InvDevicePanel.COPY_DEVICE_IDS.clear();
                List selectedRows = InetDevicePanel.this.model.getSelectedRows();
                if (selectedRows == null) {
                    return;
                }
                for (InetDevice d : selectedRows) {
                    InvDevicePanel.COPY_DEVICE_IDS.add(d.getInvDeviceId());
                }
            }
        };
        AbstractBGUPanel.MenuAction pasteFromLibrary = new AbstractBGUPanel.MenuAction("device.pasteFromLibrary", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0437 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438", ClientUtils.getIcon((String)"fugue/server--plus")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetDevice parent = (InetDevice)InetDevicePanel.this.model.getSelectedRow();
                if (parent == null || InvDevicePanel.COPY_DEVICE_IDS.size() == 0) {
                    return;
                }
                for (Integer deviceId : InvDevicePanel.COPY_DEVICE_IDS) {
                    InvDevice device = (InvDevice)InetDevicePanel.this.getInetDeviceService().deviceGet(deviceId.intValue());
                    InetDevice inetDevice = new InetDevice();
                    inetDevice.fromInvDevice(device);
                    inetDevice.setParentId(parent.getId());
                    inetDevice.setDeviceTypeId(-1);
                    inetDevice.setConfig("");
                    InetDevicePanel.this.getInetDeviceService().inetDeviceUpdate(inetDevice, false);
                }
                InetDevicePanel.this.performAction("refresh");
            }
        };

        MenuForm() {
        }

        protected void jbInit() throws Exception {
        }
    }

    class MenuForm2
    extends BGUPanel {
        AbstractBGUPanel.MenuAction inetReload = new AbstractBGUPanel.MenuAction("device.inetReload", "\u041f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e", ClientUtils.getIcon((String)"fugue/arrow-circle-double")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetDevice device = (InetDevice)InetDevicePanel.this.model.getSelectedRow();
                if (device != null && device.getId() > 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445 InetAccess/InetAccounting?\n\u0415\u0441\u043b\u0438 \u0432\u044b \u0432\u044b\u0431\u0440\u0430\u043b\u0438 \u043d\u0435 \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e, \u0442\u043e \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0439\u0434\u0435\u0442.", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                    InetDevicePanel.this.getInetDeviceService().deviceReload(device.getId());
                }
            }
        };

        MenuForm2() {
        }

        protected void jbInit() throws Exception {
        }
    }
}

