/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetOption;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class OptionPanel
extends BGUPanel {
    private BGUTable table;
    private Integer inetServId;
    private InetServService servService;
    private InetServOptionTableModel model;
    private boolean isPatternPanel = false;
    private List<InetOption> optionList = new ArrayList<InetOption>();
    private BGUComboBox<InetOption> option = new BGUComboBox();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private boolean isNew = false;

    public OptionPanel(ClientContext context, Integer inetServId, boolean isPatternPanel) {
        super(context);
        this.inetServId = inetServId;
        this.servService = (InetServService)context.getPort(InetServService.class);
        this.isPatternPanel = isPatternPanel;
        this.model = new InetServOptionTableModel(InetServOptionTableModel.class.getName(), isPatternPanel);
    }

    public List<InetServOption> getInetServOptionList() {
        return this.model.getRows();
    }

    public void setInetServOptionList(List<InetServOption> data) {
        this.model.setData(data);
    }

    public void setInetOptionList(List<InetOption> data) {
        this.optionList = data;
    }

    protected void jbInit() {
        this.table = new BGUTable((TableModel)((Object)this.model));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)((Object)this));
        toolBar.compact();
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this);
        this.setLayout(new GridBagLayout());
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public InetServOption getInetServOption() {
        InetServOption inetServOption = new InetServOption();
        inetServOption.setDateFrom(this.period.getDateFrom());
        inetServOption.setDateTo(this.period.getDateTo());
        if (this.option.getSelectedItem() != null) {
            inetServOption.setOptionId(((InetOption)this.option.getSelectedItem()).getId());
        }
        if (this.inetServId != null) {
            inetServOption.setServiceId(this.inetServId.intValue());
        }
        return inetServOption;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u041e\u043f\u0446\u0438\u044e", ClientUtils.getIcon((String)"item_add")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                OptionPanel.this.period.setLocalDateFrom(LocalDate.now());
                OptionPanel.this.period.setLocalDateTo(null);
                OptionPanel.this.option.setData(OptionPanel.this.optionList);
                OptionPanel.this.isNew = true;
                OptionPanel.this.performActionOpen();
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", ClientUtils.getIcon((String)"item_edit")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetServOption servOption = (InetServOption)OptionPanel.this.model.getSelectedRow();
                if (servOption != null) {
                    OptionPanel.this.option.setData(OptionPanel.this.optionList);
                    OptionPanel.this.option.setSelectedItem((Object)servOption.getOptionId());
                    OptionPanel.this.period.setLocalDateFrom(TimeUtils.convertDateToLocalDate((Date)servOption.getDateFrom()));
                    OptionPanel.this.period.setLocalDateTo(TimeUtils.convertDateToLocalDate((Date)servOption.getDateTo()));
                    OptionPanel.this.isNew = false;
                    OptionPanel.this.performActionOpen();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", ClientUtils.getIcon((String)"item_delete")){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                OptionPanel.this.model.deleteSelectedRows();
            }
        };
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (OptionPanel.this.inetServId != null) {
                    OptionPanel.this.model.setData(OptionPanel.this.servService.inetServOptionList(OptionPanel.this.inetServId.intValue()));
                } else {
                    OptionPanel.this.model.setData(new ArrayList());
                }
                OptionPanel.this.optionList = OptionPanel.this.servService.inetOptionList();
            }
        };
        new AbstractBGUPanel.DefaultAction("open", "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                JPanel editorPanel = new JPanel(new GridBagLayout());
                editorPanel.add((Component)new JLabel("\u041e\u043f\u0446\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
                editorPanel.add((Component)OptionPanel.this.option, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
                if (!OptionPanel.this.isPatternPanel) {
                    editorPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
                    editorPanel.add((Component)OptionPanel.this.period, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
                }
                BGOptionPane optionPane = new BGOptionPane((Object)editorPanel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0438");
                JDialog dialog = optionPane.getDialog();
                ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
                    InetServOption servOption = OptionPanel.this.getInetServOption();
                    if (OptionPanel.this.isNew) {
                        OptionPanel.this.model.addRow(servOption);
                    } else {
                        OptionPanel.this.model.setRow(OptionPanel.this.table.getSelectedRow(), servOption);
                    }
                    dialog.setVisible(false);
                });
                dialog.setVisible(true);
                dialog.dispose();
            }
        };
    }

    public List<InetOption> getOptionList() {
        return this.optionList;
    }

    public void setInetServId(Integer id) {
        this.inetServId = id;
    }

    class InetServOptionTableModel
    extends BGTableModel<InetServOption> {
        private boolean isPatternPanel;

        public InetServOptionTableModel(String name, boolean isPatternPanel) {
            super(name);
            this.isPatternPanel = false;
            this.isPatternPanel = isPatternPanel;
        }

        protected void initColumns() {
            this.addColumn("\u041e\u043f\u0446\u0438\u044f", -1, 30, -1, "optionId", true);
            if (!this.isPatternPanel) {
                this.addColumn("\u0421 \u0434\u0430\u0442\u044b", 150, 150, 150, "dateFrom", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
                this.addColumn("\u041f\u043e \u0434\u0430\u0442\u0443", 150, 150, 150, "dateTo", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            }
        }

        public Object getValue(InetServOption inetServOption, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("optionId".equals(identifier)) {
                for (InetOption option : OptionPanel.this.optionList) {
                    if (option.getId() != inetServOption.getOptionId()) continue;
                    return option.getTitle();
                }
                return "";
            }
            return super.getValue((Object)inetServOption, column);
        }
    }
}

