/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.ActionPerformer;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.contract.directory.AddressList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class GateEditor
extends BGPanel
implements ActionPerformer {
    private JTextArea comment_TA = new JTextArea();
    private BGConfigEditorPane config = new BGConfigEditorPane();
    private JPasswordField keyword = new JPasswordField();
    private JTextField host = new JTextField();
    private IntTextField port = new IntTextField();
    private BGComboBox<ComboBoxItem> type_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> cityComboBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> streetComboBox = new BGComboBox();
    private JTextField houseField = new JTextField();
    private IntTextField podField = new IntTextField();
    private IntTextField floorField = new IntTextField();
    private AddressList streetsList = null;
    private String parentId;
    private int houseId = -1;
    private AddressList streets = null;
    private transient Vector<ActionListener> actionListeners;

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public GateEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.comment_TA.setRows(3);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel hostPortPanel = new JPanel(new GridBagLayout());
        JPanel keyPanel = new JPanel(new GridBagLayout());
        hostPortPanel.setBorder((Border)new BGTitleBorder(" \u0425\u043e\u0441\u0442 \u0438 \u043f\u043e\u0440\u0442 \u0448\u043b\u044e\u0437\u0430 "));
        this.port.setMinimumSize(new Dimension(77, 24));
        this.port.setPreferredSize(new Dimension(77, 24));
        this.port.setColumns(7);
        this.port.setHorizontalAlignment(0);
        BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
        bGControlPanel_02.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GateEditor.this.bGControlPanel_02_actionPerformed(e);
            }
        });
        keyPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043b\u044e\u0447\u0435\u0432\u043e\u0435 \u0441\u043b\u043e\u0432\u043e "));
        this.keyword.setMinimumSize(new Dimension(110, 24));
        this.keyword.setPreferredSize(new Dimension(110, 24));
        this.keyword.setColumns(10);
        JPanel typePanel = new JPanel(new GridBagLayout());
        typePanel.setBorder((Border)new BGTitleBorder(" \u0422\u0438\u043f \u0448\u043b\u044e\u0437\u0430 "));
        typePanel.add((Component)this.type_CB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.host.setMinimumSize(new Dimension(150, 24));
        this.host.setPreferredSize(new Dimension(150, 24));
        this.add(hostPortPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(keyPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(typePanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JTabbedPane tabbedPane = new JTabbedPane();
        JScrollPane commentScroll = new JScrollPane(this.comment_TA);
        JPanel commentPanel = new JPanel(new GridBagLayout());
        commentPanel.add((Component)commentScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        tabbedPane.add((Component)commentPanel, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        JScrollPane configScroll = new JScrollPane((Component)this.config);
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.add((Component)configScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        tabbedPane.add((Component)configPanel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        JPanel addresPanel = this.createAddressPanel();
        tabbedPane.add((Component)addresPanel, "\u0410\u0434\u0440\u0435\u0441");
        this.add(tabbedPane, new GridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)bGControlPanel_02, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        keyPanel.add((Component)this.keyword, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        hostPortPanel.add((Component)this.host, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        hostPortPanel.add((Component)this.port, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        hostPortPanel.add((Component)new JLabel(" : "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel createAddressPanel() {
        JPanel addressPanel = new JPanel(new GridBagLayout());
        this.houseField.setColumns(7);
        this.houseField.setMaximumSize(new Dimension(70, 25));
        JLabel cityLabel = new JLabel();
        JLabel streetLabel = new JLabel();
        JLabel areaLabel = new JLabel();
        JLabel quarterLabel = new JLabel();
        JLabel houseLabel = new JLabel();
        JLabel podLabel = new JLabel();
        JLabel floorLabel = new JLabel();
        cityLabel.setText(" \u0413\u043e\u0440\u043e\u0434: ");
        streetLabel.setText(" \u0423\u043b\u0438\u0446\u0430: ");
        areaLabel.setText(" \u0420\u0430\u0439\u043e\u043d: ");
        quarterLabel.setText(" \u041a\u0432\u0430\u0440\u0442\u0430\u043b: ");
        houseLabel.setText(" \u0414\u043e\u043c / \u0414\u0440\u043e\u0431\u044c: ");
        podLabel.setText("\u041f\u043e\u0434\u044a\u0435\u0437\u0434");
        floorLabel.setText("\u042d\u0442\u0430\u0436");
        this.cityComboBox.setMaximumSize(new Dimension(120, 24));
        this.cityComboBox.setPreferredSize(new Dimension(120, 24));
        this.streetComboBox.setMaximumSize(new Dimension(120, 24));
        this.streetComboBox.setPreferredSize(new Dimension(120, 24));
        addressPanel.add((Component)cityLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        addressPanel.add((Component)this.cityComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        addressPanel.add((Component)streetLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        addressPanel.add((Component)this.streetComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        addressPanel.add((Component)houseLabel, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        addressPanel.add((Component)this.houseField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        addressPanel.add((Component)podLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        addressPanel.add((Component)this.podField, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        addressPanel.add((Component)floorLabel, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        addressPanel.add((Component)this.floorField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        addressPanel.add((Component)new JPanel(), new GridBagConstraints(0, 4, 4, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.cityComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GateEditor.this.setAddressToFilter();
            }
        });
        return addressPanel;
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("GateTypeList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.type_CB, (Node)XMLUtils.selectElement((Node)doc, (String)"//list"), (String)"");
            this.type_CB.insertItemAt((Object)new ComboBoxItem((Object)"0", "\u041f\u0430\u043f\u043a\u0430"), 0);
            this.type_CB.setSelectedIndex(0);
        }
        request = new Request();
        request.setModule("admin");
        request.setAction("GetAddressInfo");
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.streetsList = new AddressList(XMLUtils.selectNode((Node)doc, (String)"//streets"));
            ClientUtils.buildComboBox(this.cityComboBox, (Node)XMLUtils.selectNode((Node)doc, (String)"//cities"), null);
            this.cityComboBox.setSelectedIndex(0);
        }
        request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("GetGate");
        if (this.id != null) {
            request.setAttribute("id", this.id);
        }
        if (ClientUtils.checkStatus((Document)(doc = this.getDocument(request)))) {
            Element gate = XMLUtils.selectElement((Node)doc, (String)"//gate");
            if (gate != null) {
                this.host.setText(XMLUtils.getAttribute((Element)gate, (String)"host", (String)""));
                this.port.setText(XMLUtils.getAttribute((Element)gate, (String)"port", (String)""));
                this.keyword.setText(XMLUtils.getAttribute((Element)gate, (String)"keyword", (String)""));
                this.comment_TA.setText(XMLUtils.getAttribute((Element)gate, (String)"comment", (String)""));
                Element config = XMLUtils.selectElement((Node)gate, (String)"//config");
                this.config.setText(ClientUtils.linesToString((Element)config));
                ClientUtils.setComboBoxSelection(this.type_CB, (Object)gate.getAttribute("type"));
            } else {
                this.host.setText(null);
                this.port.setText(null);
                this.keyword.setText(null);
                this.comment_TA.setText(null);
                this.config.setText(null);
            }
            Element address = XMLUtils.selectElement((Node)doc, (String)"//address");
            if (address != null) {
                this.houseField.setText(XMLUtils.getAttribute((Element)address, (String)"house", (String)""));
                this.podField.setText(XMLUtils.getAttribute((Element)address, (String)"pod", (String)""));
                this.floorField.setText(XMLUtils.getAttribute((Element)address, (String)"floor", (String)""));
                String cityid = XMLUtils.getAttribute((Element)address, (String)"cityId", (String)"0");
                this.houseId = Integer.parseInt(XMLUtils.getAttribute((Element)address, (String)"hid", (String)"-1"));
                this.streets = new AddressList(XMLUtils.selectNode((Node)doc, (String)"//streets"));
                this.setCityComboBox(cityid);
                String streetId = XMLUtils.getAttribute((Element)address, (String)"streetId", (String)"0");
                this.setStreetComboBox(streetId);
            } else {
                this.houseField.setText("");
                this.podField.setText("");
                this.floorField.setText("");
                this.houseId = -1;
                this.setCityComboBox("0");
                this.setStreetComboBox("0");
            }
        }
    }

    private void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.setData();
        } else if ("ok".equals(actionCommand)) {
            Request request;
            ComboBoxItem type = (ComboBoxItem)this.type_CB.getSelectedItem();
            if (type == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0438\u043f \u0448\u043b\u044e\u0437\u0430!");
                return;
            }
            if (this.cityComboBox.getSelectedIndex() > 0 && Utils.isBlankString((String)this.houseField.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412 \u0430\u0434\u0440\u0435\u0441\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0431\u044b\u0442\u044c \u0434\u043e\u043c");
                return;
            }
            this.houseId = -1;
            if (Utils.notBlankString((String)this.houseField.getText())) {
                request = new Request();
                request.setModule("admin");
                request.setAction("GetArea");
                request.setAttribute("cityid", ((ComboBoxItem)this.cityComboBox.getSelectedItem()).getObject());
                ComboBoxItem streetItem = (ComboBoxItem)this.streetComboBox.getSelectedItem();
                request.setAttribute("streetid", streetItem.getObject());
                request.setAttribute("houseAndFrac", this.houseField.getText());
                Document doc = this.getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Element address = XMLUtils.selectElement((Node)doc, (String)"//address");
                    this.houseId = Integer.parseInt(XMLUtils.getAttribute((Element)address, (String)"hid", (String)"-1"));
                }
                if (this.houseId < 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0422\u0430\u043a\u043e\u0439 \u0434\u043e\u043c \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u0434\u043e\u043c\u043e\u0432");
                    return;
                }
            }
            request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateGate");
            request.setAttribute("id", this.id);
            request.setModuleId(this.getModuleId());
            request.setAttribute("host", this.host.getText().trim());
            request.setAttribute("port", this.port.getText().trim());
            request.setAttribute("keyword", new String(this.keyword.getPassword()));
            request.setAttribute("comment", this.comment_TA.getText().trim());
            request.setAttribute("type", type.getObject());
            request.setAttribute("config", this.config.getText());
            request.setAttribute("parent_id", this.parentId);
            request.setAttribute("houseId", this.houseId);
            request.setAttribute("pod", this.podField.getText());
            request.setAttribute("floor", this.floorField.getText());
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.fireActionPerformed(new ActionEvent((Object)this, 0, "ok"));
            }
        } else if ("cancel".equals(actionCommand)) {
            this.fireActionPerformed(new ActionEvent((Object)this, 0, "cancel"));
        } else if ("help".equals(actionCommand)) {
            this.openHelp(GateEditor.class.getName());
        }
    }

    private void setAddressToFilter() {
        int cityid = Integer.valueOf(((ComboBoxItem)this.cityComboBox.getSelectedItem()).getObject().toString());
        this.streetsList.buildComboBox(this.streetComboBox, cityid, false, true);
    }

    private void setCityComboBox(String cityId) {
        if (!ClientUtils.setComboBoxSelection(this.cityComboBox, (Object)cityId)) {
            this.cityComboBox.setSelectedIndex(1);
            this.cityComboBox.setSelectedIndex(0);
        }
    }

    private void setStreetComboBox(String streetId) {
        if (!ClientUtils.setComboBoxSelection(this.streetComboBox, (Object)streetId)) {
            Map val = this.streets.getAddressById(Integer.valueOf(streetId).intValue());
            if (val != null) {
                ComboBoxItem item = new ComboBoxItem((Object)streetId, (String)val.get("title") + "[\u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0433\u043e\u0440\u043e\u0434]");
                for (String key : val.keySet()) {
                    item.put(key, val.get(key));
                }
                ((DefaultComboBoxModel)this.streetComboBox.getModel()).insertElementAt(item, 1);
                this.streetComboBox.setSelectedIndex(1);
            } else {
                this.streetComboBox.setSelectedIndex(0);
            }
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector<ActionListener> v = new Vector<ActionListener>(this.actionListeners);
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector<ActionListener> v = new Vector<ActionListener>();
        if (this.actionListeners != null) {
            v.addAll(this.actionListeners);
        }
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    public void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector<ActionListener> listeners = new Vector<ActionListener>(this.actionListeners);
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).actionPerformed(e);
            }
        }
    }
}

