/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.util.MailMsg;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateTypeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNContractStatusManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleTypeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRuleManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class IPNTestGates
extends TaskBase {
    private int maxThreadCount = 0;
    private String email;
    private Connection con;
    private Connection conSlave;
    private boolean lockStatus = true;
    private boolean readRealStatusBeforeSync = false;

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c IPN. \u0417\u0430\u0434\u0430\u0447\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 IPN \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    protected boolean initTask() {
        boolean result = true;
        if (this.moduleId < 0) {
            result = false;
            this.log.error("Param mid not found!");
        }
        this.email = this.taskSetup.get("email", null);
        this.maxThreadCount = this.taskSetup.getInt("thread.count", 100);
        this.log.debug("thread.count=" + this.maxThreadCount);
        this.lockStatus = this.taskSetup.getInt("lock.status", 1) > 0;
        this.readRealStatusBeforeSync = this.taskSetup.getInt("read.real.status.before.sync", 0) > 0;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        this.con = this.setup.getDBConnectionFromPool();
        this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        try (BalanceUtils bu = new BalanceUtils(this.conSlave);){
            IPNContractStatusManager csm = new IPNContractStatusManager(this.con, this.moduleId, (Preferences)new ModuleSetup(this.con, this.moduleId));
            ContractManager cm = new ContractManager(this.conSlave);
            try {
                String query = "SELECT DISTINCT cid FROM contract_module WHERE mid = " + this.moduleId;
                PreparedStatement psSelect = this.conSlave.prepareStatement(query);
                StringBuffer lockContracts = new StringBuffer();
                HashMap<Integer, Integer> contractsStatus = new HashMap<Integer, Integer>(100, 20.0f);
                ResultSet rs = psSelect.executeQuery();
                while (rs.next()) {
                    int cid = rs.getInt(1);
                    Contract contract = cm.getContractById(cid);
                    if (contract == null) continue;
                    BigDecimal balance = bu.getBalance(this.getOperatingTime().getTime(), cid);
                    int currentStatus = csm.getContractStatus(cid);
                    if (this.lockStatus) {
                        currentStatus = this.lockGateStatus(csm, lockContracts, cid, contract, balance, currentStatus);
                    }
                    contractsStatus.put(cid, currentStatus);
                }
                psSelect.close();
                String gateErrors = this.testGates(contractsStatus, csm);
                this.log.info("Locked clients:");
                this.log.info(lockContracts.toString());
                if (this.email != null && (lockContracts.length() > 0 || gateErrors.length() > 0)) {
                    StringBuffer msg = new StringBuffer(lockContracts.length() + gateErrors.length() + 50);
                    if (lockContracts.length() > 0) {
                        msg.append("\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u043a\u043b\u0438\u0435\u043d\u0442\u044b:\n");
                        msg.append(lockContracts.toString());
                    }
                    if (gateErrors.length() > 0) {
                        msg.append("\n\u041e\u0448\u0438\u0431\u043a\u0438 \u0448\u043b\u044e\u0437\u043e\u0432:\n");
                        msg.append(gateErrors);
                    }
                    new MailMsg((Preferences)this.setup).sendMessage(this.email, "IPN TestGates", msg.toString());
                }
            }
            catch (Exception ex) {
                this.log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)this.con, (Connection)this.conSlave);
        }
    }

    protected int lockGateStatus(IPNContractStatusManager csm, StringBuffer lockContracts, int cid, Contract contract, BigDecimal balance, int currentStatus) {
        boolean open;
        boolean bl = open = balance.subtract(contract.getBalanceLimit()).compareTo(BigDecimal.ZERO) >= 0;
        if (!open && currentStatus != 2 && currentStatus != 4 && currentStatus != 3) {
            this.log.info("Locking " + contract.getTitle() + " balance: " + Utils.formatBigDecimalSumm((BigDecimal)balance) + " limit " + Utils.formatBigDecimalSumm((BigDecimal)contract.getBalanceLimit()));
            lockContracts.append(contract.getTitle());
            lockContracts.append(";balance:");
            lockContracts.append(Utils.formatBigDecimalSumm((BigDecimal)balance));
            lockContracts.append(";limit:");
            lockContracts.append(Utils.formatBigDecimalSumm((BigDecimal)contract.getBalanceLimit()));
            lockContracts.append("\n");
            csm.changeStatus(cid, 2, 0, false);
            currentStatus = csm.getContractStatus(cid);
        }
        return currentStatus;
    }

    /*
     * WARNING - void declaration
     */
    private String testGates(Map<Integer, Integer> status, IPNContractStatusManager csm) {
        StringBuffer gateErrors = new StringBuffer();
        GateManager gm = new GateManager(this.con, this.moduleId);
        GateTypeManager gateTypeManager = new GateTypeManager(this.con, this.moduleId);
        RuleTypeManager ruleTypeManager = new RuleTypeManager(this.con, this.moduleId);
        UserGateRuleManager ugrm = new UserGateRuleManager(this.con, this.moduleId);
        try {
            Map<Integer, GateType> gateTypeMap = gateTypeManager.getTypeMap();
            Map<Integer, RuleType> ruleTypeMap = ruleTypeManager.getTypeMap();
            ArrayList<GateWorker> workers = new ArrayList<GateWorker>();
            ArrayList futures = new ArrayList();
            List<Gate> gates = gm.getGatesList();
            HashMap<Integer, Gate> gateMap = new HashMap<Integer, Gate>();
            for (Gate gate : gates) {
                gateMap.put(gate.getId(), gate);
            }
            HashSet<Integer> parentGates = new HashSet<Integer>();
            Iterator<Gate> iterator = gates.iterator();
            while (iterator.hasNext()) {
                Gate gate;
                Gate g = gate = iterator.next();
                while (g.getParentId() > 0) {
                    Gate parentGate = (Gate)gateMap.get(g.getParentId());
                    g.setParent(parentGate);
                    if (g.getParent() != null) {
                        parentGates.add(gate.getParentId());
                        parentGate.setGateType(gateTypeMap.get(parentGate.getTypeId()));
                    }
                    g = parentGate;
                }
            }
            this.log.debug("Loading gate list");
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.maxThreadCount, this.maxThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            for (Gate gate : gates) {
                this.log.debug(gate.getTitle());
                try {
                    Preferences setup = new Preferences(gate.getConfig(), "\r\n");
                    int doNotSkipParent = setup.getInt("scheduler.do.not.skip", 0);
                    if (doNotSkipParent == 0 && parentGates.contains(gate.getId())) {
                        this.log.debug("Skipping parent gate..");
                        continue;
                    }
                    GateType type = gateTypeMap.get(gate.getTypeId());
                    if (type == null) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Not foung type for gate: " + gate.getTitle());
                        continue;
                    }
                    GateWorker worker = (GateWorker)Utils.newInstance((String)type.getGateManager(), GateWorker.class);
                    if (worker == null) {
                        this.log.error("Not found gate manager for gate: " + gate.getTitle());
                        continue;
                    }
                    List<UserGateRule> userGateRules = ugrm.getUserGateRulesForGate(gate.getId());
                    if (userGateRules.size() == 0) continue;
                    gate.setGateType(type);
                    worker.init(gate, ruleTypeManager.getTypeMap(gate.getTypeId()), gateTypeMap, this.moduleId);
                    for (UserGateRule rule : userGateRules) {
                        Integer contractStatus;
                        if (this.readRealStatusBeforeSync) {
                            contractStatus = csm.getContractStatus(rule.getContractId());
                        } else {
                            contractStatus = status.get(rule.getContractId());
                            if (contractStatus == null) {
                                contractStatus = 1;
                            }
                        }
                        RuleType ruleType = ruleTypeMap.get(rule.getRuleTypeId());
                        worker.addUserStatus(rule.getContractId(), contractStatus, ruleType, type, rule, this.moduleId);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Contract: " + rule.getContractId() + "; status: " + contractStatus + "; ruleType: " + ruleType + "; rule: " + rule);
                    }
                    if (worker.statusList.size() == 0) continue;
                    Future<?> f = threadPoolExecutor.submit(worker);
                    workers.add(worker);
                    futures.add(f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log.error("error while gate sync :" + e.getMessage(), (Throwable)e);
                }
            }
            while (workers.size() != 0) {
                void var16_22;
                boolean bl = false;
                while (var16_22 < workers.size()) {
                    GateWorker worker = (GateWorker)workers.get((int)var16_22);
                    Future future = (Future)futures.get((int)var16_22);
                    if (future.isDone()) {
                        this.log.info("Gate: " + worker.getGate().getTitle() + " - checking end..");
                        workers.remove((int)var16_22);
                        futures.remove((int)var16_22);
                        gateErrors.append(worker.getGateErrors());
                        continue;
                    }
                    ++var16_22;
                }
                Thread.sleep(1000L);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Now " + workers.size() + " gates..");
                Object ids = "";
                for (GateWorker worker : workers) {
                    ids = (String)ids + worker.gate.getId() + " ";
                }
                this.log.debug("working gate ids: " + (String)ids);
            }
            threadPoolExecutor.shutdown();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return gateErrors.toString();
    }
}

