<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%><!doctype html>
<html>
<head>
	<style>
		.line { border-bottom: solid 2px #333; margin-bottom: 1rem; }
	</style>
</head>
<body>
	<div class="tile" style="padding: 1rem 2rem;">
	<c:choose>
	<c:when test="${errorId eq 'parameterLoginAndPasswordNotFound'}">
		<h2 class="line">ОШИБКА: Отсутствует параметры</h2>
		<div>Полученный запрос не содержит параметров с данными необходимыми для авторизации</div>
		<div>Попробуйте <a href="webexecuter">войти еще раз</a></div>
	</c:when>
	
	<c:when test="${errorId eq 'loginNotFound'}">
		<h2 class="line">ОШИБКА: Договор не найден</h2>
		<div>Введенный Вами номер договора ${userName} не найден в базе данных.</div>
		<div>Возможные причины:</div>
		<ul style="padding-left: 2rem; padding-top: 0.5rem; padding-bottom: 0.5rem;">
			<li>Договор не существует (или удален)</li>
			<li>Неправильно введен номер договора.</li>
			<li>Другие причины, для выяснения свяжитесь с расчетной службой</li>
		</ul>
		<div>Попробуйте <a href="webexecuter">войти еще раз</a></div>
	</c:when>
	
	<c:when test="${errorId eq 'passwordInvalid'}">
		<h2 class="line">ОШИБКА: Неправильный пароль</h2>
		<div>Вы ввели неправильный пароль для договора - ${userName}</div>
		<div>Возможные причины:</div>
		<ul style="padding-left: 2rem; padding-top: 0.5rem; padding-bottom: 0.5rem;">
			<li>Ошибка при вводе пароля</li>
			<li>Ошибка в номере договора</li>
			<li>Проверьте состояние клавиши Caps Lock и языковую раскладку клавиатуры</li>
			<li>Внимание пароль для доступа к серверу статистики может ОТЛИЧАЕТСЯ от пароля для доступа в интернет. Пароль для доступа к серверу статистики указывается в карте регистрации выдаваемой при заключении договора.</li>
			<li>Попробуйте воспользоваться <a href="pubexecuter?module=contract.function&amp;action=AccessRestore">системой восстановления пароля</a></li>
			<li>Другие причины, для выяснения свяжитесь с расчетной службой по тел. +X (XXX) XXX-XX-XX</li>
		</ul>
		<div>Попробуйте <a href="webexecuter">войти еще раз</a></div>
	</c:when>
	
	<c:when test="${errorId eq 'denyStatus'}">
        <h2 class="line">ОШИБКА: Доступ закрыт</h2>
        <div>Доступ к личному кабинету для договора ${userName} закрыт по статусу.</div>
        <div>Войти по <a href="webexecuter">другому договору.</a></div>
	</c:when>
	
	<c:when test="${errorId eq 'denyClosedPeriod'}">
        <h2 class="line">ОШИБКА: Доступ закрыт</h2>
        <div>Доступ к личному кабинету для договора ${userName} закрыт. Период действия договора завершился.</div>
        <div>Войти по <a href="webexecuter">другому договору.</a></div>
	</c:when>
	
	<c:when test="${errorId eq 'accountLock'}">
		<h2 class="line">ОШИБКА: Доступ заблокирован</h2>
		<div>Доступ к статистике по договору ${userName} заблокирован, до разблокировки осталось - <span id="miniclock"></span></div>
		<div>Возможные причины:</div>
		<ul style="padding-left: 2rem; padding-top: 0.5rem; padding-bottom: 0.5rem;">
			<li>Для защиты от подбора пароля к серверу статистики методом перебора, после каждой попытки войти на сервер статистики с неправильным паролем, доступ к серверу блокируется на некоторое время. После истечения этого времени дается возможность провести еще одну попытку войти на сервер, если будет вновь введен неправильный пароль доступ снова будет заблокирован на более длительный промежуток времени и т.д. После нескольких последовательных попыток входа на сервер с неправильным паролем, доступ на сервер блокируется на несколько часов.</li>
			<li>Доступ заблокирован администратором, свяжитесь с службой поддержки</li>
			<li>Другие причины, для выяснения свяжитесь с расчетной службой</li>
		</ul>
		<div>После окончания времени блокировки Вы можете попробовать войти еще раз. Предварительно убедитесь, в правильности вводимых данных.</div>
		<div>Обратите внимание на:</div>
		<ul style="padding-left: 2rem; padding-top: 0.5rem; padding-bottom: 0.5rem;">
			<li>Состояние клавиши Caps Lock и языковую раскладку клавиатуры</li>
			<li>Пароль для доступа к серверу статистики может ОТЛИЧАЕТСЯ от пароля для доступа в интернет. Пароль для доступа к серверу статистики указывается в карте регистрации выдаваемой при заключении договора.</li>
			<li>Если не уверены в корректности вводимого пароля, попробуйте воспользоваться <a href="pubexecuter?module=contract.function&amp;action=AccessRestore">системой восстановления пароля</a></li>
		</ul>
		<script type="text/javascript">
		var lockTime = ${lockSeconds};
		var logonUrl = "webexecuter"; 
		function runMiniClock()
		{
			lockTime=lockTime-1;
			if ( lockTime == 0 )
			{
				document.location=logonUrl;
				return;
			} 
		    var hours = Math.floor(lockTime / 3600);
		    var minutes = Math.floor((lockTime - 3600 * hours) / 60);
		    var seconds = lockTime % 60;
		    seconds=((seconds < 10) ? "0" : "") + seconds;
		    minutes=((minutes < 10) ? "0" : "") + minutes;
		    hours=(hours > 24) ? hours-24 : hours;
		    hours=(hours == 0) ? 0 : hours;
		    var clock = hours + ":" + minutes + ":" + seconds;
		    document.getElementById('miniclock').innerHTML = clock;
		    timer = setTimeout("runMiniClock()",1000);
		}
		runMiniClock();
		</script>
	</c:when>

	<c:otherwise>
		<h2 class="line">ОШИБКА: Неизвестная</h2>
		<div>Это что то новенькое!!! [error = '${errorId}'] Свяжитесь с разработчиками!</div>
	</c:otherwise>
	</c:choose>

<!--  style="width: 45em; height: 20em; margin: auto; border: 1px solid #888; background-color: #fff; border-radius: 10px; box-shadow: 5px 5px 5px #333;" -->
<!-- <xsl:variable name="activateType" select="/data/@activateType"/>  -->
<!-- 	<div style="padding: 10px 30px; font-size: 15pt; background-color: #eee; border-radius: 10px 10px 0px 0px;">Ошибка</div>  -->
<!-- 	<div style="padding: 20px; color: #444;">webMode=${webMode}<br>requestURI="${requestURI}<br>queryString=${queryString}<br></div>  -->
	</div>	
</body>
</html>