/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComponentBorder;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ListItem;
import bitel.billing.module.contract.ContractEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractOpen;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginBase;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;

public class ContractGroupOperation
extends BGUTabPanel {
    private static final String PREFIX_BITEL_BILLING_MODULE_SERVICES = "bitel.billing.module.services.";
    public static final String TAB_ID = "groupOperation";
    private BGFileChooser fileChooser = new BGFileChooser(this);
    private BGControlPanelListSelect contractList = new BGControlPanelListSelect();
    private Collection<ContractGroupOperationItem> operations = new ArrayList<ContractGroupOperationItem>();
    private Map<String, Element> elements = new HashMap<String, Element>();

    public ContractGroupOperation() {
        super(new ClientContext("admin", 0, 0, ClientUtils.getRBName(ContractGroupOperation.class)), TAB_ID, "\u0413\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
    }

    @Override
    protected void jbInit() throws Exception {
        BGButton all = new BGButton("\u0412\u0441\u0435");
        BGButton next = new BGButton("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439");
        BGButton contractsFromSearch = new BGButton("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        BGButton openedContracts = new BGButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        BGButton loadIdsFromFile = new BGButton("\u0418\u0437 \u0444\u0430\u0439\u043b\u0430 (\u043a\u043e\u0434\u044b)");
        BGButton loadNumbersFromFile = new BGButton("\u0418\u0437 \u0444\u0430\u0439\u043b\u0430 (\u043d\u043e\u043c\u0435\u0440\u0430)");
        next.setPreferredSize(new Dimension(200, next.getPreferredSize().height));
        all.setPreferredSize(new Dimension(200, all.getPreferredSize().height));
        BGSwingUtilites.wrapBorder(this.contractList, " \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b ");
        JPanel panelLeft = new JPanel(new GridBagLayout());
        panelLeft.add((Component)contractsFromSearch, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelLeft.add((Component)openedContracts, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelLeft.add((Component)this.contractList, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelLeft.add((Component)loadNumbersFromFile, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelLeft.add((Component)loadIdsFromFile, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)next, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)all, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(null);
        JPanel panelRight = new JPanel(new GridBagLayout());
        panelRight.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        panelRight.add((Component)buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        for (Element itemElement : XMLUtils.selectElements(((ClientContext)this.getContext()).getModuleDoc(), "/module/ContractGroupOperation/item")) {
            String className = itemElement.getAttribute("class");
            if (className == null) continue;
            try {
                ContractGroupOperationItem item = (ContractGroupOperationItem)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                item.init(this.elements);
                this.operations.add(item);
            }
            catch (Exception item) {}
        }
        this.loadModules();
        for (ContractGroupOperationItem operationItem : this.operations) {
            operationItem.setVisible(false);
            panel.add((Component)operationItem, new GridBagConstraints(0, panel.getComponentCount(), 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            JCheckBox ocb = new JCheckBox(operationItem.getOperationTitle(), false);
            panel.add((Component)ocb, new GridBagConstraints(0, panel.getComponentCount(), 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 5), 0, 0));
            ocb.setVisible(true);
            JCheckBox checkBox = new JCheckBox(operationItem.getOperationTitle(), true);
            checkBox.setFocusPainted(false);
            BGComponentBorder componentBorder = new BGComponentBorder(checkBox, operationItem, BorderFactory.createEtchedBorder());
            checkBox.addActionListener(e -> {
                operationItem.setVisible(false);
                ocb.setVisible(true);
                ocb.setSelected(false);
            });
            operationItem.setBorder(componentBorder);
            ocb.addActionListener(e -> {
                operationItem.build();
                operationItem.setVisible(true);
                ocb.setVisible(false);
                checkBox.setSelected(true);
            });
        }
        panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, panel.getComponentCount(), 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, panelLeft, (Component)panelRight, 300L), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        next.addActionListener(e -> {
            DefaultListModel<ListItem> model = this.contractList.getListModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ListItem item = model.getElementAt(i);
                if (!item.isSelected()) continue;
                String id = (String)item.getAttribute("id");
                if (id != null && !this.doOperation(id)) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e");
                }
                item.setSelected(false);
                this.contractList.repaint();
                break;
            }
        });
        all.addActionListener(e -> {
            boolean result = this.doOperation(this.contractList.getListValues());
            this.contractList.setListItemSelected(false);
            if (!result) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e");
            }
        });
        contractsFromSearch.addActionListener(e -> this.getContracts());
        openedContracts.addActionListener(e -> this.getOpenedContracts());
        loadNumbersFromFile.addActionListener(e -> this.loadFromFile(true));
        loadIdsFromFile.addActionListener(e -> this.loadFromFile(false));
    }

    public void loadModules() {
        Request request = new Request();
        request.setModule("service");
        request.setAction("GetModules");
        Document doc = TransferManager.getDocument(request);
        for (Element element : XMLUtils.selectElements(doc, "/data/table/data/row")) {
            String moduleId = element.getAttribute("f0");
            String title = element.getAttribute("f1");
            String pkg = element.getAttribute("f4");
            this.addGroupOperation(pkg + ".ContractGroupOperationFactory", moduleId, title);
            if (!pkg.startsWith(PREFIX_BITEL_BILLING_MODULE_SERVICES)) continue;
            String moduleName = pkg.substring(PREFIX_BITEL_BILLING_MODULE_SERVICES.length());
            this.addGroupOperation("ru.bitel.bgbilling.modules." + moduleName + ".client.ContractGroupOperationFactory", moduleId, title);
        }
        for (BGPluginBase bGPluginBase : BGPluginManagerClient.getManager().getPluginsMap().values()) {
            this.addGroupOperation(bGPluginBase.getId() + ".client.ContractGroupOperationFactory", "", bGPluginBase.getName());
        }
    }

    private void addGroupOperation(String className, String moduleId, String title) {
        try {
            Class<?> clazz = Class.forName(className);
            if (ContractGroupOperationFactory.class.isAssignableFrom(clazz)) {
                ContractGroupOperationFactory groupOperationFactory = (ContractGroupOperationFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (ContractGroupOperationItem operationItem : groupOperationFactory.getContractGroupOperations(moduleId, title)) {
                    this.operations.add(operationItem.init(this.elements));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getContracts() {
        ContractOpen contractOpen = (ContractOpen)BGClientBase.getFrame().getTabbedPane().getTab("findContract");
        if (contractOpen == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0414\u041e\u0413\u041e\u0412\u041e\u0420\u042b \u0432 \u043f\u0430\u043d\u0435\u043b\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        } else {
            ContractOpen.SearchData searchData = contractOpen.getSearchData();
            if (searchData != null && Utils.notEmptyCollection(searchData.getDataOfUI())) {
                List<JSONObject> contracts = searchData.getDataOfUI();
                this.fillContracts(contracts);
            }
        }
    }

    public void getOpenedContracts() {
        List<JPanel> panels = BGClientBase.getFrame().getTabbedPane().getTabList();
        if (Utils.notEmptyCollection(panels)) {
            ArrayList<JSONObject> contracts = new ArrayList<JSONObject>();
            for (JPanel contractEditorPanel : panels.stream().filter(p -> p instanceof ContractEditor).collect(Collectors.toList())) {
                ContractEditor contractEditor = (ContractEditor)contractEditorPanel;
                JSONObject contract = new JSONObject();
                contract.put("cid", contractEditor.getContractId());
                contract.put("contractTitle", (Object)contractEditor.getContractTitle());
                contracts.add(contract);
            }
            this.fillContracts(contracts);
        }
    }

    private void fillContracts(List<JSONObject> contracts) {
        if (Utils.isEmptyCollection(contracts)) {
            return;
        }
        DefaultListModel<ListItem> model = this.contractList.getListModel();
        model.clear();
        for (JSONObject contract : contracts) {
            ListItem listItem = new ListItem(contract.optString("contractTitle"), true);
            listItem.setAttribute("id", String.valueOf(contract.optInt("cid")));
            model.addElement(listItem);
        }
        int size = model.getSize();
        if (size > 0) {
            BGSwingUtilites.wrapBorder(this.contractList, " \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435: " + contracts.size());
        } else {
            BGSwingUtilites.wrapBorder(this.contractList, " \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b ");
        }
    }

    public void loadFromFile(boolean needConvertToIds) {
        try {
            StringBuilder contracts = new StringBuilder();
            if (this.fileChooser.showOpenDialog() == 0) {
                File file = this.fileChooser.getSelectedFile();
                FileReader fr = new FileReader(file);
                BufferedReader reader = new BufferedReader(fr);
                this.parseFile(needConvertToIds, contracts, reader);
                Request request = new Request();
                request.setModule("contract");
                request.setAction("GetContractEntries");
                request.setAttribute("byTitle", needConvertToIds);
                request.setAttribute("values", contracts.toString());
                ArrayList<JSONObject> contractList = new ArrayList<JSONObject>();
                Document doc = TransferManager.getDocument(request);
                if (ClientUtils.checkStatus(doc)) {
                    for (Element elem : XMLUtils.selectElements(doc, "//contracts/entry")) {
                        JSONObject contract = new JSONObject();
                        contract.put("cid", Utils.parseInt(elem.getAttribute("id")));
                        contract.put("contractTitle", (Object)elem.getAttribute("title"));
                        contractList.add(contract);
                    }
                }
                this.fillContracts(contractList);
            }
        }
        catch (IOException ex) {
            ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430!");
        }
    }

    private void parseFile(boolean needConvertToIds, StringBuilder contracts, BufferedReader reader) throws IOException {
        String delim = needConvertToIds ? "','" : ",";
        boolean append = false;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (append) {
                contracts.append(delim);
            } else if (needConvertToIds) {
                contracts.append('\'');
            }
            contracts.append(line);
            append = true;
        }
        if (needConvertToIds) {
            contracts.append('\'');
        }
    }

    private boolean doOperation(String cids) {
        if (cids.isEmpty()) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
            return false;
        }
        List operations = this.operations.stream().filter(ContractGroupOperationItem::isOperationEnabled).collect(Collectors.toList());
        if (operations.size() == 1 && cids.length() < 20 && Utils.toIntegerList(cids).size() == 1) {
            for (ContractGroupOperationItem item : operations) {
                if (item.doItemOperation(cids)) continue;
                return false;
            }
        } else {
            for (ContractGroupOperationItem item : operations) {
                item.doItemOperation(cids);
            }
        }
        return true;
    }

    public static abstract class ContractGroupOperationItem
    extends AbstractBGUPanel<ClientContext, BGUPanel> {
        protected Map<String, Element> elements;

        public ContractGroupOperationItem(LayoutManager layoutManager) {
            super(layoutManager, new ClientContext("admin", 0, 0, null, null));
        }

        public ContractGroupOperationItem(String module, int moduleId, LayoutManager layoutManager) {
            super(layoutManager, new ClientContext(module, moduleId, 0, null, null));
        }

        protected ContractGroupOperationItem init(Map<String, Element> elements) {
            this.elements = elements;
            return this;
        }

        protected void setData() {
        }

        @Override
        protected void build() {
            super.build();
            this.setData();
        }

        @Override
        protected Future<BGUPanel> buildAsync() {
            return null;
        }

        protected abstract boolean doItemOperation(String var1);

        protected JTextArea getTextArea(String text) {
            JTextArea textArea = new JTextArea();
            textArea.setEnabled(false);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setBackground(this.getBackground());
            textArea.setForeground(this.getForeground());
            textArea.setDisabledTextColor(this.getForeground());
            textArea.setText(text);
            return textArea;
        }

        protected abstract String getOperationTitle();

        protected boolean isOperationEnabled() {
            return this.isVisible();
        }
    }

    public static interface ContractGroupOperationFactory {
        public Collection<ContractGroupOperationItem> getContractGroupOperations(String var1, String var2);
    }
}

