/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ListItem;
import bitel.billing.module.contract.ParameterEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class ServiceEditor
extends ParameterEditor {
    private String service_id = null;
    private Vector<Properties> parameterList = new Vector();
    BGTitleBorder bGTitleBorder1 = new BGTitleBorder();
    BGTitleBorder bGTitleBorder2 = new BGTitleBorder();
    DefaultListModel<ListItem> listModel = new DefaultListModel();
    JList<ListItem> serviceList = new JList<ListItem>(this.listModel);
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel servicePanel = new JPanel();
    BGControlPanelListSelect addressPanel = new BGControlPanelListSelect();

    public ServiceEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.bGTitleBorder1.setTitle(" \u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u044e\u0449\u0438\u0435 \u043b\u0438\u0446\u0430 ");
        this.bGTitleBorder2.setTitle(" \u0410\u0434\u0440\u0435\u0441\u0430 ");
        this.setLayout(new GridBagLayout());
        this.servicePanel.setLayout(new GridBagLayout());
        this.servicePanel.setBorder(this.bGTitleBorder1);
        this.addressPanel.setBorder(this.bGTitleBorder2);
        this.addressPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ServiceEditor.this.addressPanel_propertyChange(e);
            }
        });
        this.jScrollPane1.setMinimumSize(new Dimension(200, 131));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 131));
        this.serviceList.setSelectionMode(0);
        this.serviceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ServiceEditor.this.serviceList_valueChanged(e);
            }
        });
        this.add((Component)this.servicePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.servicePanel.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add(this.serviceList, null);
        this.add((Component)this.addressPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ServiceList");
        request.setContractId(this.getContractId());
        request.setAttribute("pid", this.id);
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.serviceList, XMLUtils.selectNode(doc, "//serviceList"));
            this.parameterList = new Vector();
            this.addressPanel.getList().setModel(new DefaultListModel());
            Element node = XMLUtils.selectElement(doc, "//parameterList");
            if (node != null && node.hasChildNodes()) {
                for (Element item : XMLUtils.elements(node.getChildNodes())) {
                    Properties prop = new Properties();
                    prop.setProperty("id", XMLUtils.getAttribute(item, "id", null));
                    prop.setProperty("sid", XMLUtils.getAttribute(item, "sid", null));
                    prop.setProperty("title", XMLUtils.getAttribute(item, "title", null));
                    this.parameterList.addElement(prop);
                }
            }
        }
    }

    void serviceList_valueChanged(ListSelectionEvent e) {
        this.listModel = (DefaultListModel)this.serviceList.getModel();
        if (!this.serviceList.isSelectionEmpty()) {
            int index = this.serviceList.getMinSelectionIndex();
            ListItem li = this.listModel.elementAt(index);
            this.service_id = (String)li.getAttribute("id");
            if (this.service_id != null && this.parameterList != null && this.parameterList.size() > 0) {
                DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
                for (int i = 0; i < this.parameterList.size(); ++i) {
                    Properties prop = this.parameterList.elementAt(i);
                    String sid = prop.getProperty("sid", null);
                    boolean check = this.service_id.equals(sid);
                    if (sid != null && !check && !"0".equals(sid)) continue;
                    ListItem item = new ListItem(prop.getProperty("title", "-"), check);
                    item.setAttribute("prop", prop);
                    model.addElement(item);
                }
                this.addressPanel.getList().setModel(model);
            }
        }
    }

    void addressPanel_propertyChange(PropertyChangeEvent e) {
        if (this.service_id == null) {
            return;
        }
        if ("itemChange".equals(e.getPropertyName())) {
            DefaultListModel model = (DefaultListModel)this.addressPanel.getList().getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ListItem item = (ListItem)model.getElementAt(i);
                Properties prop = (Properties)item.getAttribute("prop");
                prop.setProperty("sid", item.isSelected() ? this.service_id : "0");
            }
        }
    }

    @Override
    public boolean updateData() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.parameterList.size(); ++i) {
            Properties prop = this.parameterList.elementAt(i);
            buf.append(prop.getProperty("id"));
            buf.append("=");
            buf.append(prop.getProperty("sid"));
            buf.append(";");
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateServiceInfo");
        request.setAttribute("pid", this.id);
        request.setContractId(this.getContractId());
        request.setAttribute("value", buf.toString());
        boolean result = ClientUtils.checkStatus(TransferManager.getDocument(request));
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        return result;
    }
}

