/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.script;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGControlPanelPluginControls;
import bitel.billing.module.common.BSHEditor;
import bitel.billing.module.common.CheckListener;
import bitel.billing.module.script.BackupHistoryBGPanel;
import bitel.billing.module.script.ScriptFunctions;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.script.common.bean.Revision;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.bgbilling.kernel.script.common.service.ScriptService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.xml.JAXBUtils;

public class FunctionEditor
extends BGPanel {
    private CardLayout cardLayout = new CardLayout();
    private BackupHistoryBGPanel bhPanel;
    private ScriptFunctions scriptFunctions;
    private String scriptId;
    private JTextField title_TF = new JTextField();
    private BSHEditor code_TA = new BSHEditor();
    private BGControlPanelListSelect eventTypes = new BGControlPanelListSelect();
    private Revision currentRevision = new Revision();
    private JButton saveButton = new JButton();
    private BGControlPanelPluginControls bgPluginnedPanel;

    public FunctionEditor(ScriptFunctions scriptFunctions) {
        this.scriptFunctions = scriptFunctions;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.code_TA.getTextPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 83) {
                    FunctionEditor.this.save();
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(this.cardLayout);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel paramPanel = new JPanel();
        paramPanel.setBorder(new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b "));
        paramPanel.setLayout(new GridBagLayout());
        paramPanel.setMinimumSize(new Dimension(300, 400));
        paramPanel.setPreferredSize(new Dimension(300, 400));
        JPanel codePanel = new JPanel();
        codePanel.setBorder(new BGTitleBorder(" \u041a\u043e\u0434 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 "));
        codePanel.setLayout(new GridBagLayout());
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        this.eventTypes.setBorder(new BGTitleBorder(" \u0421\u043e\u0431\u044b\u0442\u0438\u044f "));
        this.title_TF.setMinimumSize(new Dimension(150, 24));
        this.title_TF.setPreferredSize(new Dimension(200, 24));
        JButton closeButton = new JButton();
        closeButton.setToolTipText("");
        closeButton.setText("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionEditor.this.cancelPressed();
            }
        });
        this.saveButton.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionEditor.this.save();
            }
        });
        this.buttonChange(false);
        JButton historyButton = new JButton();
        historyButton.setText("\u0418\u0441\u0442\u043e\u0440\u0438\u044f");
        historyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer scriptId = Integer.valueOf(FunctionEditor.this.id);
                if (scriptId > 0) {
                    FunctionEditor.this.bhPanel.currentId = scriptId;
                    FunctionEditor.this.bhPanel.setData();
                    FunctionEditor.this.cardLayout.show(FunctionEditor.this, "history");
                }
            }
        });
        JButton backupButton = new JButton();
        backupButton.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e");
        backupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer scriptId = Integer.valueOf(FunctionEditor.this.id);
                if (scriptId > 0) {
                    String comment = JOptionPane.showInputDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
                    if (Utils.isBlankString(comment)) {
                        return;
                    }
                    try {
                        ScriptBackup backup = new ScriptBackup();
                        backup.setId(-1);
                        backup.setScriptId(scriptId);
                        backup.setComment(comment);
                        backup.setTitle(FunctionEditor.this.title_TF.getText());
                        backup.setScript(FunctionEditor.this.code_TA.getText());
                        backup.setType(1);
                        FunctionEditor.this.getContext().getPort(ScriptService.class).backup(backup);
                    }
                    catch (BGException e1) {
                        FunctionEditor.this.getContext().processException(e1);
                    }
                }
            }
        });
        paramPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        paramPanel.add((Component)this.title_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        paramPanel.add((Component)this.eventTypes, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        codePanel.add((Component)this.code_TA, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        controlPanel.add((Component)backupButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        controlPanel.add((Component)historyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        controlPanel.add((Component)this.saveButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        controlPanel.add((Component)closeButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.bgPluginnedPanel = new BGControlPanelPluginControls(FunctionEditor.class.getName(), this, new Object[0]);
        this.bgPluginnedPanel.invokeInitBGPanel(null, -1);
        mainPanel.add((Component)paramPanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)codePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.bgPluginnedPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 0, 2), 0, 0));
        mainPanel.add((Component)controlPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        DocumentListener dlistener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FunctionEditor.this.buttonChange(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FunctionEditor.this.buttonChange(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FunctionEditor.this.buttonChange(true);
            }
        };
        this.code_TA.getTextPane().getDocument().addDocumentListener(dlistener);
        this.title_TF.getDocument().addDocumentListener(dlistener);
        new CheckListener(this.eventTypes.getList()){

            @Override
            public void keyPressed(KeyEvent e) {
                FunctionEditor.this.buttonChange(true);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FunctionEditor.this.buttonChange(true);
            }
        };
        this.add((Component)mainPanel, "main");
        this.bhPanel = new BackupHistoryBGPanel(1, this.cardLayout, this);
        this.add((Component)this.bhPanel, "history");
        this.cardLayout.show(this, "main");
    }

    @Override
    public void setData() {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        if (this.id.equals("new")) {
            this.title_TF.setText("");
            String defaultCode = "import bitel.billing.server.util.*;\n\npublic void onEvent( event, setup, con, conSlave )\n{\n\tprint( \"Hello, world!\" );\n}";
            this.code_TA.setText(defaultCode);
            this.eventTypes.setListValues(null);
        } else {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("GetFunction");
            req.setAttribute("id", this.id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus(doc)) {
                this.eventTypes.setListValues(XMLUtils.selectText(doc, "//function/@event_types"));
                this.title_TF.setText(XMLUtils.selectText(doc, "//function/@title"));
                this.code_TA.setText(ClientUtils.linesToString(XMLUtils.selectElement(doc, "//code")));
                this.currentRevision.setId(Utils.parseInt(this.id));
                this.currentRevision.setUserId(Utils.parseInt(XMLUtils.selectText(doc, "//function/@userId")));
                this.currentRevision.setTimeRevision(TimeUtils.convertStringToDate(XMLUtils.selectText(doc, "//function/@timeRevision"), "yyyy-MM-dd HH:mm:ss"));
            }
        }
        this.buttonChange(false);
        this.bgPluginnedPanel.invokeSetData(new Object[0]);
    }

    private void buttonChange(boolean enable) {
        if (this.saveButton.isEnabled() != enable) {
            this.saveButton.setEnabled(enable);
        }
    }

    private void init() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("EventTypeList");
        request.setAttribute("globalScript", this.scriptFunctions.isGlobalScript());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.eventTypes.getList(), XMLUtils.selectNode(doc, "//list"), "");
        }
    }

    private Request getUpdateRequest() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("UpdateFunction");
        req.setAttribute("id", this.id);
        req.setAttribute("script_id", this.scriptId);
        req.setAttribute("title", this.title_TF.getText());
        req.setAttribute("code", this.code_TA.getText());
        req.setAttribute("event_types", this.eventTypes.getListValues());
        return req;
    }

    private void save() {
        if (Utils.isEmptyString(this.title_TF.getText())) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u0438!");
            return;
        }
        Request req = this.getUpdateRequest();
        req.setAttribute("validate", "1");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            Element rootNode = doc.getDocumentElement();
            Object validationError = rootNode.getAttribute("validationError");
            if (Utils.notBlankString((String)validationError)) {
                int line2 = Utils.parseInt(rootNode.getAttribute("validationErrorEndLine"), -1);
                int column2 = Utils.parseInt(rootNode.getAttribute("validationErrorEndColumn"), -1);
                validationError = (String)validationError + "\n\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0441\u043a\u0440\u0438\u043f\u0442?";
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), validationError, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0441\u043a\u0440\u0438\u043f\u0442\u0430", 0, 3) == 1) {
                    this.code_TA.select(line2, column2, line2, column2);
                    return;
                }
                this.code_TA.select(line2, column2, line2, column2);
            }
            if (this.isActual() && ClientUtils.checkStatus(doc = this.getDocument(req = this.getUpdateRequest()))) {
                this.currentRevision = JAXBUtils.unmarshal(doc, "/data/revision", Revision.class);
                this.id = String.valueOf(this.currentRevision.getId());
                this.buttonChange(false);
            }
        }
    }

    private void cancelPressed() {
        if (this.saveButton.isEnabled() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?", "\u0412\u044b\u0445\u043e\u0434", 0) == 0) {
            this.save();
        }
        this.scriptFunctions.hideEditor();
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    private boolean isActual() {
        if (!this.id.equals("new")) {
            Revision sr = this.getLastRevision();
            Date newTime = sr.getTimeRevision();
            Date oldTime = this.currentRevision.getTimeRevision();
            if (newTime != null && (oldTime == null || oldTime.compareTo(newTime) != 0)) {
                return JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043a\u0440\u0438\u043f\u0442 \u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d " + sr.getUserName() + " \u043f\u043e\u043a\u0430 \u0432\u044b \u043f\u0440\u0430\u0432\u0438\u043b\u0438, \u0432\u0441\u0435 \u0440\u0430\u0432\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c?", "\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c \u0432\u0435\u0440\u0441\u0438\u0439", 0) == 0;
            }
        }
        return true;
    }

    private Revision getLastRevision() {
        if (this.id != null) {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("GetFunction");
            req.setAttribute("id", this.id);
            req.setAttribute("revision", "1");
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus(doc)) {
                return JAXBUtils.unmarshal(doc, "/data/revision", Revision.class);
            }
        }
        return null;
    }

    @Override
    public void deleteItem() {
        if (this.bhPanel.isShowing()) {
            this.bhPanel.deleteItem();
            return;
        }
        super.deleteItem();
    }
}

