/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGClientHistoryResultPopup;
import ru.bitel.bgbilling.client.common.BGClientOpenedResultPopup;
import ru.bitel.bgbilling.client.common.BGClientSearchResultPopup;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class BGClientSearchPanel
extends JPanel {
    private JTextField searchTextField;
    private BGClientSearchResultPopup searchResultPopup;
    private BGClientHistoryResultPopup historyResultPopup;
    private BGClientOpenedResultPopup openedResultPopup;
    private ClientContext clientContext = null;

    public BGClientSearchPanel() {
        super(new GridBagLayout());
        SearchButton configButton = new SearchButton("silk/wrench");
        SearchButton historyButton = new SearchButton("fugue/clock");
        historyButton.setToolTipText("\u0438\u0441\u0442\u043e\u0440\u0438\u044f");
        historyButton.addActionListener(e -> {
            if (this.getSearchResultPopup().isShowing()) {
                this.getSearchResultPopup().setVisible(false);
            }
            if (!this.getHistoryResultPopup().isShowing()) {
                this.historyResultPopup.show(this, this.getWidth() / 2 - this.historyResultPopup.getPreferredSize().width / 2, this.getHeight());
                this.historyResultPopup.applyFilter(null);
            }
        });
        SearchButton openedButton = new SearchButton("opened");
        openedButton.setToolTipText("\u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        openedButton.addActionListener(e -> {
            if (this.getSearchResultPopup().isShowing()) {
                this.getSearchResultPopup().setVisible(false);
            }
            if (!this.getOpenedResultPopup().isShowing()) {
                this.openedResultPopup.show(this, this.getWidth() / 2 - this.openedResultPopup.getPreferredSize().width / 2, this.getHeight());
                this.openedResultPopup.doLoad();
            }
        });
        this.add((Component)new JLabel("\u041f\u043e\u0438\u0441\u043a: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getSearchTextField(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 3), 0, 0));
        this.add((Component)historyButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)openedButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)configButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new JTextField(20);
            this.searchTextField.setMinimumSize(new Dimension(300, 10));
            this.searchTextField.setHorizontalAlignment(0);
            this.searchTextField.addActionListener(e -> {
                if (!this.getSearchResultPopup().isShowing()) {
                    this.searchResultPopup.show(this, this.getWidth() / 2 - this.searchResultPopup.getPreferredSize().width / 2, this.getHeight());
                    this.searchTextField.requestFocus();
                } else {
                    this.searchResultPopup.openSelectedPanel();
                }
                this.searchResultPopup.doSearch(this.searchTextField.getText().trim());
            });
            this.searchTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (BGClientSearchPanel.this.getSearchResultPopup().isShowing() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                        BGClientSearchPanel.this.getSearchResultPopup().dispatchEvent(keyEvent);
                    } else if (keyEvent.getKeyCode() != 10) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BGClientSearchPanel.this.getSearchResultPopup().doSearch(BGClientSearchPanel.this.searchTextField.getText());
                            }
                        });
                    }
                }
            });
        }
        return this.searchTextField;
    }

    private BGClientSearchResultPopup getSearchResultPopup() {
        if (this.searchResultPopup == null) {
            this.searchResultPopup = new BGClientSearchResultPopup(this.getClientContext());
        }
        return this.searchResultPopup;
    }

    private BGClientHistoryResultPopup getHistoryResultPopup() {
        if (this.historyResultPopup == null) {
            this.historyResultPopup = new BGClientHistoryResultPopup(this.getClientContext());
        }
        return this.historyResultPopup;
    }

    private BGClientOpenedResultPopup getOpenedResultPopup() {
        if (this.openedResultPopup == null) {
            this.openedResultPopup = new BGClientOpenedResultPopup(this.getClientContext());
        }
        return this.openedResultPopup;
    }

    private ClientContext getClientContext() {
        if (this.clientContext == null) {
            this.clientContext = new ClientContext("kernel", 0, -1, null);
        }
        return this.clientContext;
    }

    class SearchButton
    extends JButton {
        public SearchButton(String icon) {
            super(ClientUtils.getIcon(icon));
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            Insets insets = this.getMargin();
            insets.left = 1;
            insets.right = 1;
            this.setMargin(insets);
        }
    }
}

