/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.loader.common.service.LoaderService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public abstract class UtilPanel
extends BGUPanel {
    private LoaderService loaderService = null;
    private ContractParameterService contractParameterService = null;
    private List<IdTitle> contractParameterList = null;

    protected LoaderService getLoaderService() {
        if (this.loaderService == null) {
            this.loaderService = ((ClientContext)this.getContext()).getPort(LoaderService.class);
        }
        return this.loaderService;
    }

    protected ContractParameterService getContractParameterService() {
        if (this.contractParameterService == null) {
            this.contractParameterService = ((ClientContext)this.getContext()).getPort(ContractParameterService.class);
        }
        return this.contractParameterService;
    }

    protected List<IdTitle> getContractParameterList(int[] types) {
        if (this.contractParameterList == null) {
            this.contractParameterList = new ArrayList<IdTitle>();
            try {
                ArrayList<Integer> typeIds = new ArrayList<Integer>();
                int count = types.length;
                for (int i = 0; i < count; ++i) {
                    typeIds.add(types[i]);
                }
                for (ContractParameterGroupAttr attr : this.getContractParameterService().contractParameterGroupAttrList()) {
                    if (types.length != 0 && !typeIds.contains(attr.getType())) continue;
                    this.contractParameterList.add((IdTitle)((Object)attr));
                }
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
        return this.contractParameterList;
    }

    protected byte[] getDataFromFile(File file) {
        byte[] bytes = null;
        try {
            bytes = Utils.readByBlock(new FileInputStream(file));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        return bytes;
    }

    protected PanelContractParameter getContractParameterPanel(String title, int[] types) {
        PanelContractParameter panel = new PanelContractParameter(title);
        DefaultListModel listModel = new DefaultListModel();
        this.getContractParameterList(types).forEach(i -> listModel.addElement(i));
        panel.getList().setModel(listModel);
        return panel;
    }

    protected PanelContractParameters getPanelContractParameters(int[] types) {
        PanelContractParameters panel = new PanelContractParameters();
        panel.model.setData(this.getContractParameterList(types));
        return panel;
    }

    protected JPanel getTextPanel(String title, BGTextField textField) {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        panel.add((Component)textField, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        return panel;
    }

    protected JPanel getHelpPanel(String title, String text) {
        JTextArea help = new JTextArea(5, 5);
        help.setMargin(new Insets(3, 3, 3, 3));
        help.setLineWrap(true);
        help.setWrapStyleWord(true);
        help.setText(text);
        help.setEditable(false);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        panel.add((Component)new JScrollPane(help), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        return panel;
    }

    protected JPanel getButtonPanel() {
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        okCancelPanel.addActionListener(actionEvent -> {
            if (actionEvent.getActionCommand().equals("ok")) {
                this.doUtil();
            } else {
                this.doClearForm();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)okCancelPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    protected void doUtil() {
    }

    protected void doClearForm() {
    }

    public class PanelContractParameter
    extends JPanel {
        JList<IdTitle> list;

        public PanelContractParameter() {
            this(null);
        }

        public PanelContractParameter(String title) {
            super(new GridBagLayout());
            this.list = new JList();
            this.list.setSelectionMode(0);
            int gridy = 0;
            this.add((Component)new JLabel(title == null ? "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:" : title), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
            this.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        }

        public JList<IdTitle> getList() {
            return this.list;
        }
    }

    public class PanelContractParameters
    extends JPanel {
        ContractParameterTableModel model;
        BGUTable table;

        public PanelContractParameters() {
            super(new GridBagLayout());
            this.model = new ContractParameterTableModel(ContractParameterTableModel.class.getName());
            this.table = new BGUTable(this.model);
            int gridy = 0;
            this.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
            this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        }
    }

    public class ContractParameterTableModel
    extends BGTableModel<IdTitle> {
        public ContractParameterTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", -1, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class PanelTitleLabel
    extends JLabel {
        public PanelTitleLabel(String text) {
            super(text);
            this.setFont(new Font("Dialog", 1, 15));
        }
    }
}

