/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.kernel.script.common.bean.GlobalScriptLink;
import ru.bitel.bgbilling.kernel.script.common.service.GlobalScriptService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class GlobalScriptPanel
extends BGUPanel {
    private GlobalScriptLinkTableModel model = new GlobalScriptLinkTableModel(GlobalScriptPanel.class.getName());
    private GlobalScriptEditor scriptEditor = new GlobalScriptEditor();

    @Override
    protected void jbInit() {
        BGUTable table = new BGUTable(this.model);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    GlobalScriptPanel.this.performAction("edit");
                }
            }
        });
        BGEditor editor = new BGEditor();
        editor.addForm(BGSwingUtilites.wrapBorder(this.scriptEditor, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        editor.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List<GlobalScriptLink> data = ((ClientContext)GlobalScriptPanel.this.getContext()).getPort(GlobalScriptService.class).getGlobalScriptLinkList();
                GlobalScriptPanel.this.model.setData(data);
                GlobalScriptPanel.this.scriptEditor.performAction("refresh");
            }
        };
    }

    private class GlobalScriptLinkTableModel
    extends BGTableModel<GlobalScriptLink> {
        public GlobalScriptLinkTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043b\u0430\u0441\u0441", "className", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    private class GlobalScriptEditor
    extends BGUPanel {
        private static final String EXECUTE = "execute";
        private GlobalScriptLink current;
        private BGTextField titleField = new BGTextField(50);
        private DynamicClassChooser chooser = new DynamicClassChooser(false, 1);
        private JButton execute = new JButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0435\u0439\u0447\u0430\u0441");
        private JTextArea logArea = new JTextArea();
        private JScrollPane logAreaPane = new JScrollPane(this.logArea);

        private GlobalScriptEditor() {
        }

        @Override
        protected void jbInit() {
            this.setLayout(new GridLayout(1, 2));
            this.add(this.getLeftPanel());
            this.add(this.getClassPanel());
            this.execute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GlobalScriptEditor.this.performAction(GlobalScriptEditor.EXECUTE);
                }
            });
        }

        private JPanel getLeftPanel() {
            this.logArea.setEditable(false);
            this.logAreaPane.setPreferredSize(new Dimension(100, 200));
            this.logAreaPane.setMinimumSize(new Dimension(100, 200));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.titleField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)this.execute, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 15, 5), 0, 0));
            panel.add((Component)new JLabel("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.logAreaPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getClassPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043b\u0430\u0441\u0441: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.chooser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    GlobalScriptEditor.this.chooser.setIfaceName(((ClientContext)GlobalScriptEditor.this.getContext()).getPort(GlobalScriptService.class).getInterfaceName());
                    GlobalScriptEditor.this.chooser.setSuperclassName(((ClientContext)GlobalScriptEditor.this.getContext()).getPort(GlobalScriptService.class).getSuperclassName());
                    GlobalScriptEditor.this.chooser.performAction("refresh");
                }
            };
            new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    GlobalScriptEditor.this.current = new GlobalScriptLink();
                    GlobalScriptEditor.this.titleField.setText("");
                    GlobalScriptEditor.this.chooser.setSelectedIndex(0);
                    GlobalScriptEditor.this.logArea.setText("");
                    GlobalScriptEditor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    GlobalScriptEditor.this.current = (GlobalScriptLink)GlobalScriptPanel.this.model.getSelectedRow();
                    if (GlobalScriptEditor.this.current == null) {
                        throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043a\u0440\u0438\u043f\u0442!");
                    }
                    GlobalScriptEditor.this.titleField.setText(GlobalScriptEditor.this.current.getTitle());
                    GlobalScriptEditor.this.chooser.setSelectedItem(GlobalScriptEditor.this.current.getClassName());
                    GlobalScriptEditor.this.logArea.setText("");
                    GlobalScriptEditor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    GlobalScriptEditor.this.current = (GlobalScriptLink)GlobalScriptPanel.this.model.getSelectedRow();
                    if (GlobalScriptEditor.this.current != null) {
                        ((ClientContext)GlobalScriptEditor.this.getContext()).getPort(GlobalScriptService.class).deleteGlobalScriptLink(GlobalScriptEditor.this.current.getId());
                        GlobalScriptPanel.this.performAction("refresh");
                    }
                    GlobalScriptEditor.this.performActionClose();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (Utils.isBlankString(GlobalScriptEditor.this.chooser.getSelectedClass())) {
                        throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043a\u043b\u0430\u0441\u0441!");
                    }
                    GlobalScriptEditor.this.current.setTitle(GlobalScriptEditor.this.titleField.getText());
                    GlobalScriptEditor.this.current.setClassName(GlobalScriptEditor.this.chooser.getSelectedClass());
                    ((ClientContext)GlobalScriptEditor.this.getContext()).getPort(GlobalScriptService.class).updateGlobalScriptLink(GlobalScriptEditor.this.current);
                    GlobalScriptEditor.this.performActionClose();
                    GlobalScriptPanel.this.performAction("refresh");
                }
            };
            new AbstractBGUPanel.DefaultAction(EXECUTE, "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (GlobalScriptEditor.this.current.getId() <= 0) {
                        throw new BGMessageException("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0435 \u0441\u043a\u0440\u0438\u043f\u0442!");
                    }
                    GlobalScriptEditor.this.logArea.setText(((ClientContext)GlobalScriptEditor.this.getContext()).getPort(GlobalScriptService.class).executeGlobalScript(GlobalScriptEditor.this.current.getId()));
                }
            };
        }
    }
}

