/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class StatusTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<?>, TariffContext> {
    private List<Integer> statusIds = new ArrayList<Integer>();

    public StatusTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.statusIds = Utils.toIntegerList(parameterMap.get("status", ""));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int executeImpl(Long treeNodeId, AbstractTariffRequest<?> tariffRequest, TariffContext tariffContext) {
        int contractId = tariffRequest.contractId;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("contractId = {}", (Object)contractId);
            this.logger.debug("statusIds = {}", (Object)Utils.toString(this.statusIds));
        }
        try (ContractStatusDao contractStatusDao = new ContractStatusDao(tariffRequest.getConnection());){
            Date date = tariffRequest.getTime().getTime();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("date = {}", (Object)date);
            }
            for (ContractStatus contractStatus : contractStatusDao.list(contractId, date)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("contractStatus = {}", (Object)contractStatus);
                }
                if (contractStatus.getDateFrom() != null && !contractStatus.getDateFrom().before(date) || !this.statusIds.contains(contractStatus.getStatus())) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("result = {}", (Object)1);
                }
                int n = 1;
                return n;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        if (!this.logger.isDebugEnabled()) return 0;
        this.logger.debug("result = {}", (Object)1);
        return 0;
    }
}

