/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;

public class BGControlPanelTextArea
extends JPanel {
    private TitledBorder titledBorder;
    private JTextArea jTextArea = new JTextArea();
    private transient Vector<FocusListener> focusListeners;

    public BGControlPanelTextArea() {
        this(null, 0);
    }

    public BGControlPanelTextArea(int top) {
        this(null, top);
    }

    public BGControlPanelTextArea(String borderText) {
        this(borderText, 0);
    }

    public BGControlPanelTextArea(String borderText, int top) {
        this.jTextArea.setMargin(new Insets(3, 3, 3, 3));
        if (borderText != null) {
            this.setTitle(borderText);
        }
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(true);
        this.jTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                BGControlPanelTextArea.this.jTextArea_focusLost(e);
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.jTextArea), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(top, 5, 5, 5), 0, 0));
    }

    public String getText() {
        return this.jTextArea.getText();
    }

    public void setText(String txt) {
        this.jTextArea.setText(txt);
    }

    public JTextArea getJTextArea() {
        return this.jTextArea;
    }

    public void setTitle(String title) {
        if (this.titledBorder == null) {
            this.titledBorder = new BGTitleBorder(title);
            this.setBorder(this.titledBorder);
        } else {
            this.titledBorder.setTitle(title);
        }
    }

    public void setWidthSize(int width) {
        int height = this.getPreferredSize().height;
        this.setMinimumSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, height));
    }

    public void setHeightSize(int height) {
        int width = this.getPreferredSize().width;
        this.setMinimumSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        super.removeFocusListener(l);
        if (this.focusListeners != null && this.focusListeners.contains(l)) {
            Vector<FocusListener> v = new Vector<FocusListener>();
            v.addAll(this.focusListeners);
            v.removeElement(l);
            this.focusListeners = v;
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        Vector<FocusListener> v = new Vector<FocusListener>();
        if (this.focusListeners != null) {
            v.addAll(this.focusListeners);
        }
        if (!v.contains(l)) {
            v.addElement(l);
            this.focusListeners = v;
        }
    }

    protected void fireFocusGained(FocusEvent e) {
        if (this.focusListeners != null) {
            Vector<FocusListener> listeners = this.focusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).focusGained(e);
            }
        }
    }

    protected void fireFocusLost(FocusEvent e) {
        if (this.focusListeners != null) {
            Vector<FocusListener> listeners = this.focusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).focusLost(e);
            }
        }
    }

    private void jTextArea_focusLost(FocusEvent e) {
        this.fireFocusLost(e);
    }
}

