/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.domain.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;
import ru.bitel.oss.kernel.directories.domain.common.service.DomainService;

public class DomainPanel
extends BGUPanel {
    private BGTreeTableModel<Domain> model = new BGTreeTableModel<Domain>("domain"){
        private Icon folder2;
        private Icon leaf;
        private Domain rootDomain;
        {
            this.folder2 = ClientUtils.getIcon("fugue/tree");
            this.leaf = ClientUtils.getIcon("fugue/leaf");
        }

        @Override
        protected void initColumns() {
            this.rootDomain = new Domain();
            this.rootDomain.setId(0);
            this.rootDomain.setTitle("\u0414\u043e\u043c\u0435\u043d\u044b");
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", Domain.class, false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", false);
            this.addColumnId();
        }

        @Override
        public Object getValue(Domain val, int column) throws BGException {
            switch (column) {
                case 0: {
                    return val == this.root ? this.rootDomain : val;
                }
            }
            return super.getValue(val, column);
        }

        @Override
        public Icon getIcon(Domain value) {
            if (value == this.root) {
                return this.folder2;
            }
            if (value.getChildren() == null || value.getChildren().size() == 0) {
                return this.leaf;
            }
            return this.folder2;
        }
    };

    public DomainPanel() {
        super(new BorderLayout());
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                DomainPanel.this.model.setData(((ClientContext)DomainPanel.this.getContext()).getPort(DomainService.class).domainTree());
            }
        };
        final HashSet cutSet = new HashSet();
        new AbstractBGUPanel.MenuAction("domain.cut", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", (Icon)ClientUtils.getIcon("cut")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                cutSet.clear();
                List selectedRows = DomainPanel.this.model.getSelectedRows();
                if (selectedRows == null) {
                    return;
                }
                for (Domain d : selectedRows) {
                    cutSet.add(d.getId());
                }
            }
        };
        new AbstractBGUPanel.MenuAction("domain.paste", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("paste")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Domain parent = (Domain)DomainPanel.this.model.getSelectedRow();
                if (parent != null && cutSet.size() > 0) {
                    ((ClientContext)DomainPanel.this.getContext()).getPort(DomainService.class).domainMove(parent.getId(), cutSet);
                    cutSet.clear();
                    DomainPanel.this.performAction("refresh");
                }
            }
        };
    }

    @Override
    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        BGUTreeTable table = new BGUTreeTable(this.model);
        BGEditor editor = new BGEditor();
        editor.setVisible(false);
        editor.addForm(new TrafficTypeForm());
        this.add((Component)BGSwingUtilites.wrapEmptyBorder(new JScrollPane(table)), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.7, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.3, 18, 1, new Insets(0, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit(table, editor);
    }

    @Override
    public boolean performAction(String action) {
        if ("newItem".equals(action)) {
            action = "new";
        } else if ("editItem".equals(action)) {
            action = "edit";
        } else if ("deleteItem".equals(action)) {
            action = "delete";
        }
        return super.performAction(action);
    }

    class TrafficTypeForm
    extends BGUPanel {
        private Domain current;
        private BGTextField title;
        private BGConfigEditorPane config;
        private JTextArea comment;

        public TrafficTypeForm() {
            super(new GridLayout(1, 0));
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    TrafficTypeForm.this.current = new Domain();
                    Domain parent = (Domain)DomainPanel.this.model.getSelectedRow();
                    if (parent != null) {
                        TrafficTypeForm.this.current.setParentId(parent.getId());
                    }
                    TrafficTypeForm.this.title.setText("");
                    TrafficTypeForm.this.config.setText("");
                    TrafficTypeForm.this.comment.setText("");
                    TrafficTypeForm.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    TrafficTypeForm.this.current = (Domain)DomainPanel.this.model.getSelectedRow();
                    if (TrafficTypeForm.this.current != null && TrafficTypeForm.this.current.getId() != 0) {
                        TrafficTypeForm.this.current = ((ClientContext)TrafficTypeForm.this.getContext()).getPort(DomainService.class).domainGet(TrafficTypeForm.this.current.getId());
                        TrafficTypeForm.this.title.setText(TrafficTypeForm.this.current.getTitle());
                        TrafficTypeForm.this.comment.setText(TrafficTypeForm.this.current.getComment());
                        TrafficTypeForm.this.performActionOpen();
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    TrafficTypeForm.this.current.setTitle(TrafficTypeForm.this.title.getText());
                    TrafficTypeForm.this.current.setComment(TrafficTypeForm.this.comment.getText());
                    int id = ((ClientContext)TrafficTypeForm.this.getContext()).getPort(DomainService.class).domainUpdate(TrafficTypeForm.this.current);
                    TrafficTypeForm.this.performActionClose();
                    DomainPanel.this.performAction("refresh");
                    DomainPanel.this.model.setSelectedRow(id);
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    TrafficTypeForm.this.current = (Domain)DomainPanel.this.model.getSelectedRow();
                    if (TrafficTypeForm.this.current != null && TrafficTypeForm.this.current.getId() != 0 && BGSwingUtilites.confirmDelete("\u0434\u043e\u043c\u0435\u043d", TrafficTypeForm.this.current)) {
                        TrafficTypeForm.this.title.setText(TrafficTypeForm.this.current.getTitle());
                        ((ClientContext)TrafficTypeForm.this.getContext()).getPort(DomainService.class).domainDelete(TrafficTypeForm.this.current.getId());
                        DomainPanel.this.performAction("refresh");
                    }
                }
            };
        }

        @Override
        protected void jbInit() {
            BGSwingUtilites.wrapBorder(this, " \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 ");
            this.title = new BGTextField();
            this.config = new BGConfigEditorPane();
            this.comment = new JTextArea();
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 3, 3, 3), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 3, 3, 3), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 3, 3, 3), 0, 0));
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 3, 3, 3), 0, 0));
            this.add(panel);
        }
    }
}

