/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.autopayment.client.ContractAutopaymentMethods;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentModeParameter;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.PeriodWithTime;

public class ContractAutopaymentCurrentModePanel
extends BGUPanel {
    private JPanel manualAutopaymentPanel = null;
    private ContractAutopaymentMethods contractAutopaymentMenhods = null;
    private ModeTextField activeTextFild = new ModeTextField();
    private ModeTextField modeTextFild = new ModeTextField();
    private ModeParameterTableModel modeParameterTableModel = new ModeParameterTableModel();
    private BGUTable modeParameterTable = new BGUTable((TableModel)((Object)this.modeParameterTableModel));
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            Autopayment autopayment = ContractAutopaymentCurrentModePanel.this.contractAutopaymentMenhods.getAutopaymentCurrentMode(((ClientContext)ContractAutopaymentCurrentModePanel.this.getContext()).getContractId());
            if (autopayment != null) {
                ArrayList<String> data = new ArrayList<String>();
                AutopaymentMode autopaymentMode = autopayment.getMode();
                if (autopaymentMode != null) {
                    ContractAutopaymentCurrentModePanel.this.modeTextFild.setText(autopaymentMode.toString());
                    ContractAutopaymentCurrentModePanel.this.manualAutopaymentPanel.setVisible(autopaymentMode.getCode() == AutopaymentMode.AUTO.getCode());
                    Preferences preferences = new Preferences(autopayment.getModeData(), "\n");
                    if (AutopaymentMode.WEEK.getCode() == autopaymentMode.getCode()) {
                        ContractAutopaymentCurrentModePanel.this.setDataForModeParameterTableModel(preferences, data, "autopayment.mode.week.");
                    } else if (AutopaymentMode.MONTH.getCode() == autopaymentMode.getCode()) {
                        ContractAutopaymentCurrentModePanel.this.setDataForModeParameterTableModel(preferences, data, "autopayment.mode.month.");
                    } else if (AutopaymentMode.AUTO.getCode() == autopaymentMode.getCode()) {
                        ContractAutopaymentCurrentModePanel.this.setDataForModeParameterTableModel(preferences, data, "autopayment.mode.auto.");
                    }
                }
                ContractAutopaymentCurrentModePanel.this.modeParameterTableModel.setData(data);
                ContractAutopaymentCurrentModePanel.this.activeTextFild.setText("\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d");
                PeriodWithTime period = autopayment.getPeriod();
                if (period != null && period.getDateFrom() != null) {
                    ContractAutopaymentCurrentModePanel.this.activeTextFild.setText(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(period.getDateFrom()));
                }
            }
        }
    };

    public ContractAutopaymentCurrentModePanel(ContractAutopaymentMethods contractAutopaymentMenhods) {
        this.contractAutopaymentMenhods = contractAutopaymentMenhods;
    }

    protected void jbInit() throws Exception {
        this.modeTextFild.setText("\u041d\u0415\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d");
        this.activeTextFild.setText("\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d");
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0440\u0435\u0436\u0438\u043c"));
        this.add(this.getModePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getModeParameterPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getManualAutopaymentPanel(), new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 5, 5, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getModePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.modeTextFild, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0441:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.activeTextFild, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getModeParameterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane((Component)this.modeParameterTable);
        scrollPane.setMinimumSize(new Dimension(300, 80));
        scrollPane.setPreferredSize(new Dimension(300, 80));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getManualAutopaymentPanel() {
        if (this.manualAutopaymentPanel == null) {
            BGTextField sumField = new BGTextField(10);
            sumField.setHorizontalAlignment(0);
            BGButton button = new BGButton("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c");
            button.addActionListener(e -> {
                try {
                    BigDecimal sum = new BigDecimal(sumField.getText());
                    DecimalFormat decimalFormat = new DecimalFormat("###,###,###,##0.00");
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 - " + decimalFormat.format(sum), "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                        this.contractAutopaymentMenhods.doManualAutopayment(((ClientContext)this.getContext()).getContractId(), sum);
                        this.performAction("refresh");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0443\u043c\u043c\u0430.");
                }
                catch (BGException exception) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), exception.getMessage());
                }
            });
            this.manualAutopaymentPanel = new JPanel(new GridBagLayout());
            this.manualAutopaymentPanel.setBorder(new TitledBorder("\u0420\u0443\u0447\u043d\u043e\u0439 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436"));
            this.manualAutopaymentPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.manualAutopaymentPanel.add((Component)sumField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.manualAutopaymentPanel.add((Component)button, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.manualAutopaymentPanel.setVisible(false);
        }
        return this.manualAutopaymentPanel;
    }

    private void setDataForModeParameterTableModel(Preferences preferences, List<String> data, String prefix) {
        ParameterMap parameterMap = preferences.sub(prefix);
        for (Map.Entry entry : parameterMap.entrySet()) {
            data.add(prefix + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }

    class ModeTextField
    extends JTextField {
        public ModeTextField() {
            this.setColumns(15);
            this.setEditable(false);
            this.setBackground(Color.WHITE);
            this.setHorizontalAlignment(0);
        }
    }

    class ModeParameterTableModel
    extends BGTableModel<String> {
        public ModeParameterTableModel() {
            super(ModeParameterTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 50, 200, -1, "name", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 50, 100, -1, "value", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.RIGHT);
        }

        public Object getValue(String value, int column) throws BGException {
            int pos = value.indexOf(61);
            if ("name".equals(this.getIdentifier(column))) {
                AutopaymentModeParameter modeParameter = AutopaymentModeParameter.getAutopaymentModeParameterByKey(value.substring(0, pos));
                return modeParameter != null ? modeParameter.getTitle() : value.substring(0, pos);
            }
            if ("value".equals(this.getIdentifier(column))) {
                return value.substring(pos + 1);
            }
            return super.getValue((Object)value, column);
        }
    }
}

