/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.AddressUtils;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrAddressDao
extends EntityAttrDefaultDao<EntityAttrAddress> {
    final String addressHouseIdName;
    private final String addressTitleName;
    private PreparedStatement addressPS;
    private PreparedStatement insertAddressPS;
    private PreparedStatement updateAddressPS;

    public EntityAttrAddressDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String addressTable, String addressHouseIdName, String addressTitleName) {
        super(con, entityAttrDao, addressTable);
        this.addressHouseIdName = addressHouseIdName;
        this.addressTitleName = addressTitleName;
    }

    @Override
    protected void createTable() {
        try (Statement createStatement = this.con.createStatement();){
            createStatement.execute("CREATE TABLE IF NOT EXISTS `" + this.table + "` ( `entityId` int(11) NOT NULL DEFAULT 0, `entitySpecAttrId` int(11) NOT NULL DEFAULT 0, `houseId` int(10) unsigned DEFAULT NULL, `flat` varchar(10) DEFAULT NULL, `room` varchar(5) NOT NULL DEFAULT '', `pod` int(10) DEFAULT 0, `floor` int(10) DEFAULT 0, `value` varchar(255) DEFAULT NULL, `comment` varchar(255) DEFAULT NULL, `format_key` varchar(45) DEFAULT '', PRIMARY KEY (`entityId`,`entitySpecAttrId`) )");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PreparedStatement getAddressPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.addressPS == null) {
            this.addressPS = this.con.prepareStatement("SELECT " + this.addressHouseIdName + ", pod, floor, flat, room, comment, format_key, " + this.addressTitleName + " FROM " + this.table + "  WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        }
        this.addressPS.setInt(1, entityId);
        this.addressPS.setInt(2, entitySpecAttrId);
        return this.addressPS;
    }

    @Override
    public EntityAttrAddress get(int entityId, int attrSpecId) throws SQLException {
        PreparedStatement ps = this.getAddressPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        EntityAttrAddress result = rs.next() ? new EntityAttrAddress(entityId, attrSpecId, rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8)) : null;
        rs.close();
        return result;
    }

    private PreparedStatement getInsertAddressPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.insertAddressPS == null) {
            this.insertAddressPS = this.con.prepareStatement("INSERT INTO " + this.table + " (" + this.idName() + ", " + this.typeName() + ", " + this.addressHouseIdName + ", pod, floor, flat, room, comment, format_key, " + this.addressTitleName + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        this.insertAddressPS.setInt(1, entityId);
        this.insertAddressPS.setInt(2, entitySpecAttrId);
        return this.insertAddressPS;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        EntityAttrAddress address = (EntityAttrAddress)a;
        PreparedStatement ps = this.getInsertAddressPS(entityId, a.getEntitySpecAttrId());
        ps.setInt(3, address.getHouseId());
        ps.setInt(4, address.getPod());
        ps.setInt(5, address.getFloor());
        ps.setString(6, address.getFlat());
        ps.setString(7, address.getRoom());
        ps.setString(8, address.getComment());
        ps.setString(9, address.getFormatKey());
        ps.setString(10, address.getTitle());
        ps.executeUpdate();
    }

    private PreparedStatement getUpdateAddressPS() throws SQLException {
        if (this.updateAddressPS == null) {
            this.updateAddressPS = this.con.prepareStatement("UPDATE " + this.table + " SET " + this.addressHouseIdName + "=?, pod=?, floor=?, flat=?, room=?, comment=?, format_key=?, " + this.addressTitleName + "=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND ( " + this.addressHouseIdName + "<>? OR pod<>? OR floor<>? OR flat<>? OR room<>? OR comment<>? OR format_key<>? OR " + this.addressTitleName + "<>? )");
        }
        return this.updateAddressPS;
    }

    @Override
    protected boolean updateImpl(int entityId, EntityAttrAddress address) throws SQLException {
        if (address != null && this.get(entityId, address.getEntitySpecAttrId()) != null) {
            PreparedStatement psUpdate = this.getUpdateAddressPS();
            int parameterIndex = 1;
            psUpdate.setInt(parameterIndex++, address.getHouseId());
            psUpdate.setInt(parameterIndex++, address.getPod());
            psUpdate.setInt(parameterIndex++, address.getFloor());
            psUpdate.setString(parameterIndex++, address.getFlat());
            psUpdate.setString(parameterIndex++, address.getRoom());
            psUpdate.setString(parameterIndex++, address.getComment());
            psUpdate.setString(parameterIndex++, address.getFormatKey());
            psUpdate.setString(parameterIndex++, address.getTitle());
            psUpdate.setInt(parameterIndex++, entityId);
            psUpdate.setInt(parameterIndex++, address.getEntitySpecAttrId());
            psUpdate.setInt(parameterIndex++, address.getHouseId());
            psUpdate.setInt(parameterIndex++, address.getPod());
            psUpdate.setInt(parameterIndex++, address.getFloor());
            psUpdate.setString(parameterIndex++, address.getFlat());
            psUpdate.setString(parameterIndex++, address.getRoom());
            psUpdate.setString(parameterIndex++, address.getComment());
            psUpdate.setString(parameterIndex++, address.getFormatKey());
            psUpdate.setString(parameterIndex++, address.getTitle());
            return psUpdate.executeUpdate() > 0;
        }
        PreparedStatement psInsert = this.getInsertAddressPS(entityId, address.getEntitySpecAttrId());
        psInsert.setInt(3, address.getHouseId());
        psInsert.setInt(4, address.getPod());
        psInsert.setInt(5, address.getFloor());
        psInsert.setString(6, address.getFlat());
        psInsert.setString(7, address.getRoom());
        psInsert.setString(8, address.getComment());
        psInsert.setString(9, address.getFormatKey());
        psInsert.setString(10, address.getTitle());
        psInsert.executeUpdate();
        return true;
    }

    void onUpdate(ServerContext context, Class<?> clazz, int id) throws SQLException, BGException {
        List<House> houseList;
        AddressUtils addressUtils;
        Setup setup;
        block12: {
            setup = context.getSetup();
            addressUtils = new AddressUtils(context);
            try (HouseDao houseDao = new HouseDao(this.con);){
                if (City.class.isAssignableFrom(clazz)) {
                    houseList = houseDao.list(id, 0, 0, 0, 0, null, null);
                    break block12;
                }
                if (Area.class.isAssignableFrom(clazz)) {
                    houseList = houseDao.list(0, id, 0, 0, 0, null, null);
                    break block12;
                }
                if (Street.class.isAssignableFrom(clazz)) {
                    houseList = houseDao.list(id, 0, id, 0, 0, null, null);
                    break block12;
                }
                if (Quarter.class.isAssignableFrom(clazz)) {
                    houseList = houseDao.list(0, 0, 0, id, 0, null, null);
                    break block12;
                }
                if (House.class.isAssignableFrom(clazz)) {
                    houseList = Collections.singletonList(houseDao.get(id));
                    break block12;
                }
                throw new IllegalArgumentException();
            }
        }
        PreparedStatement ps = this.con.prepareStatement("SELECT pod, floor, flat, room, comment, format_key, " + this.idName() + ", " + this.typeName() + " FROM " + this.table + "  WHERE " + this.addressHouseIdName + "=?");
        PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.table + " SET " + this.addressTitleName + "=?  WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        for (House house : houseList) {
            ps.setInt(1, house.getId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int pod = rs.getInt(1);
                int floor = rs.getInt(2);
                String flat = rs.getString(3);
                String room = rs.getString(4);
                String comment = rs.getString(5);
                String formatKey = rs.getString(6);
                int entityId = rs.getInt(7);
                int entitySpecAttrId = rs.getInt(8);
                String title = addressUtils.getAddress((ParameterMap)setup, formatKey, house, pod, floor, flat, room, comment);
                updatePS.setString(1, title);
                updatePS.setInt(2, entityId);
                updatePS.setInt(3, entitySpecAttrId);
                updatePS.executeUpdate();
            }
            rs.close();
        }
        ps.close();
        updatePS.close();
    }
}

