/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.client;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelMonth;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megogo.client.MegogoSetupTab;
import ru.bitel.common.TimeUtils;

public class RecalculateSetupTab
extends MegogoSetupTab {
    private BGControlPanelMonth panelMonth = new BGControlPanelMonth();
    private BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect();

    public RecalculateSetupTab() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.getContext().processException((Throwable)e);
        }
    }

    private void jbInit() {
        this.panelMonth.setBorder((Border)new BGTitleBorder(" \u041c\u0435\u0441\u044f\u0446: "));
        JButton recalcButton = new JButton("\u0417\u0430\u043f\u0443\u0441\u043a");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)recalcButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 15, 5, 15), 0, 0));
        buttonPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0443\u0441\u043a"));
        recalcButton.addActionListener(e -> {
            Set contractSet = this.contractSelect.getContractSet();
            if (contractSet.size() < 1) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d, \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u0438\u043d, \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0451\u0442\u0430");
                return;
            }
            try {
                this.getMegogoService().recalculate(TimeUtils.convertLocalDateToDate((LocalDate)this.panelMonth.getLocalDate()), contractSet);
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d", "", 1);
            }
            catch (BGException e1) {
                ClientUtils.showErrorMessageDialog((Throwable)e1);
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.panelMonth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.contractSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(buttonPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

