/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobimoney.server.service;

import bitel.billing.server.contract.bean.ContractModuleManager;
import java.sql.Connection;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.MobiServiceCode;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mobimoney.common.service.MobiService;
import ru.bitel.bgbilling.modules.mobimoney.server.bean.TransactionManager;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.mobimoney.common.service.MobiService")
public class MobiServiceImpl
extends AbstractService
implements MobiService {
    public SearchResult<Transaction> searchTransactions(int contractId, String contractTitle, String status, Period period, String[] sort, Page page) throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            SearchResult searchResult = new SearchResult(period, page, sort);
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, contractId, contractTitle, status);
            SearchResult searchResult2 = searchResult;
            return searchResult2;
        }
    }

    public Transaction getTransaction(String mobiPaymentId) throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            Transaction transaction = transactionManager.getTransaction(mobiPaymentId);
            return transaction;
        }
    }

    public void updateTransaction(Transaction transaction) throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            if (transaction.getId() > 0) {
                transactionManager.updateTransaction(transaction);
            } else {
                transactionManager.addTransaction(transaction);
            }
        }
    }

    public void checkStatus(Transaction transaction) throws BGException {
    }

    public int checkContract(String contractTitle) throws BGException {
        int result = -1;
        Connection con = this.getConnection();
        ContractDao contractDao = new ContractDao(con, this.userId);
        Contract contract = contractDao.getByTitle(contractTitle);
        contractDao.close();
        if (contract != null && new ContractModuleManager(con).getContractModuleSet(contract.getId()).contains(this.moduleId)) {
            result = contract.getId();
        }
        return result;
    }

    public boolean checkPayment(int contractId, String mobiPaymentId) throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            boolean bl = transactionManager.checkPayment(contractId, mobiPaymentId);
            return bl;
        }
    }

    public List<MobiServiceCode> getServiceCodeList() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            List<MobiServiceCode> list = transactionManager.getServiceCodeList();
            return list;
        }
    }

    public int updateServiceCode(MobiServiceCode mobiServiceCode) throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            transactionManager.updateServiceCode(mobiServiceCode);
            int n = mobiServiceCode == null ? 0 : mobiServiceCode.getId();
            return n;
        }
    }

    public void deleteServiceCode(List<Integer> ids) throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            transactionManager.deleteServiceCode(ids);
        }
    }
}

