/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.client;

import au.com.bytecode.opencsv.CSVReader;
import bitel.billing.module.common.BGFileFilter;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.payonline.common.bean.Transaction;
import ru.bitel.bgbilling.modules.payonline.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.payonline.common.service.PayOnlineService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

public class TransactionCheckMonitor
extends ServiceConfigTabbedPanel {
    private BGControlPanelPeriod periodPanel;
    private JButton chooseFileButton;
    private BGTextField fileNameTextField;
    private BGUTable missingPaymentsTable;
    private BGTableModel<Transaction> missingPaymentsTableModel;
    private BGUTable extraPaymentsTable;
    private BGTableModel<Transaction> extraPaymentsTableModel;
    private JLabel totalMissingPaymentLabel;
    private JLabel totalExtraPaymentLabel;
    private JButton runCheckButton;
    protected File selectedFile;

    public TransactionCheckMonitor() {
        this.setLayout(new GridBagLayout());
        this.periodPanel = new BGControlPanelPeriod();
        this.chooseFileButton = new JButton("...");
        this.fileNameTextField = new BGTextField(20);
        this.runCheckButton = new JButton("\u0421\u0432\u0435\u0440\u0438\u0442\u044c");
        this.totalMissingPaymentLabel = new JLabel();
        this.totalExtraPaymentLabel = new JLabel();
        this.fileNameTextField.setEnabled(false);
        this.runCheckButton.setEnabled(false);
        this.periodPanel.setLocalDateFrom(LocalDate.now());
        this.periodPanel.setLocalDateTo(LocalDate.now());
        this.missingPaymentsTableModel = new BGTableModel<Transaction>("missing"){

            protected void initColumns() {
                this.addColumn("ID \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435", -1, 150, 250, "id");
                this.addColumn("ID \u0432 \u041f\u0421", -1, 150, 250, "transactionId");
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, 150, -1, "contractTitle");
                this.addColumn("\u0421\u0443\u043c\u043c\u0430", -1, 200, 300, "summa").setTableCellRenderer((TableCellRenderer)new DecimalTableCellRenderer("####.##"));
                this.addColumn("\u0414\u0430\u0442\u0430/\u0412\u0440\u0435\u043c\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430", -1, 150, 200, "date").setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss"));
            }
        };
        this.missingPaymentsTable = new BGUTable(this.missingPaymentsTableModel);
        this.missingPaymentsTable.setSelectionMode(2);
        this.extraPaymentsTableModel = new BGTableModel<Transaction>("extra"){

            protected void initColumns() {
                this.addColumn("ID \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435", -1, 150, 250, "id");
                this.addColumn("ID \u0432 \u041f\u0421", -1, 150, 250, "transactionId");
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, 150, -1, "contractTitle");
                this.addColumn("\u0421\u0443\u043c\u043c\u0430", -1, 200, 300, "summa").setTableCellRenderer((TableCellRenderer)new DecimalTableCellRenderer("####.##"));
                this.addColumn("\u0414\u0430\u0442\u0430/\u0412\u0440\u0435\u043c\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430", -1, 150, 200, "date").setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss"));
            }
        };
        this.extraPaymentsTable = new BGUTable(this.extraPaymentsTableModel);
        this.extraPaymentsTable.setSelectionMode(2);
        JPanel chooseFilePanel = new JPanel(new GridBagLayout());
        chooseFilePanel.add((Component)this.fileNameTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        chooseFilePanel.add((Component)this.chooseFileButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        BGSwingUtilites.wrapBorder((JPanel)chooseFilePanel, (String)"\u0424\u0430\u0439\u043b \u0441\u0432\u0435\u0440\u043a\u0438");
        JPanel missingPaymentsPanel = new JPanel(new GridBagLayout());
        JPanel extraPaymentsPanel = new JPanel(new GridBagLayout());
        JTabbedPane resultTabbedPane = new JTabbedPane();
        resultTabbedPane.addTab("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438", missingPaymentsPanel);
        resultTabbedPane.addTab("\u041b\u0438\u0448\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438", extraPaymentsPanel);
        final JPopupMenu missingMenu = new JPopupMenu();
        final JPopupMenu extraMenu = new JPopupMenu();
        JMenuItem missingMenuItem = new JMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436");
        JMenuItem extraMenuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436");
        missingMenu.add(missingMenuItem);
        extraMenu.add(extraMenuItem);
        missingPaymentsPanel.add((Component)new JScrollPane((Component)this.missingPaymentsTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        missingPaymentsPanel.add((Component)this.totalMissingPaymentLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        extraPaymentsPanel.add((Component)new JScrollPane((Component)this.extraPaymentsTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        extraPaymentsPanel.add((Component)this.totalExtraPaymentLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(chooseFilePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add(this.runCheckButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add(resultTabbedPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        missingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List selectedPayments = TransactionCheckMonitor.this.missingPaymentsTableModel.getSelectedRows();
                if (selectedPayments != null && selectedPayments.size() > 0) {
                    Document document = XMLUtils.newDocument();
                    Element payments = XMLUtils.createElement((Document)document, (String)"payments");
                    for (Transaction poTransaction : selectedPayments) {
                        Element payment = XMLUtils.createElement((Element)payments, (String)"payment");
                        payment.setAttribute("trans_id", String.valueOf(poTransaction.getTransactionId()));
                        payment.setAttribute("cid", String.valueOf(poTransaction.getContractId()));
                        payment.setAttribute("datetime", TimeUtils.format((Date)poTransaction.getTransactionDate(), (String)"dd.MM.yyyy HH:mm:ss"));
                        payment.setAttribute("summa", Utils.formatCost((BigDecimal)poTransaction.getSum()));
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLUtils.serialize((Node)document, (OutputStream)baos, (String)"UTF-8");
                    try {
                        ((PayOnlineService)TransactionCheckMonitor.this.getContext().getPort(PayOnlineService.class)).addTransactions(baos.toString());
                        TransactionCheckMonitor.this.runCheck();
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                } else {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0434\u0435\u043b\u0438\u0442\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                }
            }
        });
        extraMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedPayments = TransactionCheckMonitor.this.extraPaymentsTableModel.getSelectedRows();
                if (selectedPayments != null && selectedPayments.size() > 0) {
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    for (Transaction poTransaction : selectedPayments) {
                        ids.add(poTransaction.getId());
                    }
                    try {
                        ((PayOnlineService)TransactionCheckMonitor.this.getContext().getPort(PayOnlineService.class)).deleteTransactions(ids);
                        TransactionCheckMonitor.this.runCheck();
                    }
                    catch (BGException ex) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getMessage(), "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0434\u0435\u043b\u0438\u0442\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                }
            }
        });
        this.missingPaymentsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    missingMenu.show((Component)TransactionCheckMonitor.this.missingPaymentsTable, e.getX(), e.getY());
                }
            }
        });
        this.extraPaymentsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    extraMenu.show((Component)TransactionCheckMonitor.this.extraPaymentsTable, e.getX(), e.getY());
                }
            }
        });
        this.runCheckButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TransactionCheckMonitor.this.runCheck();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.chooseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGFileChooser chooser = new BGFileChooser((Component)TransactionCheckMonitor.this.chooseFileButton);
                chooser.setFileFilter((FileFilter)new BGFileFilter("csv", "\u0424\u0430\u0439\u043b\u044b CSV"));
                if (chooser.showOpenDialog((Component)TransactionCheckMonitor.this.chooseFileButton) == 0) {
                    TransactionCheckMonitor.this.selectedFile = chooser.getSelectedFile();
                    TransactionCheckMonitor.this.fileNameTextField.setText(TransactionCheckMonitor.this.selectedFile.getName());
                    TransactionCheckMonitor.this.runCheckButton.setEnabled(true);
                }
            }
        });
    }

    private void runCheck() throws BGException {
        String fileName = this.fileNameTextField.getText();
        if (Utils.isEmptyString((String)fileName)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0440\u0435\u0435\u0441\u0442\u0440\u0430");
            return;
        }
        SearchResult searchResult = ((PayOnlineService)this.getContext().getPort(PayOnlineService.class)).searchTransactions(-1, null, TransactionStatus.ALL.getCode(), this.periodPanel.getPeriod(), null, null);
        List bgPaymentList = searchResult.getList();
        List<Transaction> registerPaymentList = this.getTransactionsFromFile();
        Iterator<Transaction> registerPaymentIterator = registerPaymentList.iterator();
        block2: while (registerPaymentIterator.hasNext()) {
            Transaction registerPayment = registerPaymentIterator.next();
            Iterator bgPaymentIterator = bgPaymentList.iterator();
            while (bgPaymentIterator.hasNext()) {
                Transaction bgPayment = (Transaction)bgPaymentIterator.next();
                if (registerPayment.getTransactionId() != bgPayment.getTransactionId()) continue;
                bgPaymentIterator.remove();
                registerPaymentIterator.remove();
                continue block2;
            }
        }
        this.extraPaymentsTableModel.setData(bgPaymentList);
        BigDecimal totalSumm = BigDecimal.ZERO;
        for (Transaction payment : bgPaymentList) {
            totalSumm = totalSumm.add(payment.getSum());
        }
        this.totalExtraPaymentLabel.setText("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 " + bgPaymentList.size() + " \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 " + Utils.formatCost((BigDecimal)totalSumm));
        if (registerPaymentList.size() > 0 || bgPaymentList.size() > 0) {
            String cids = "";
            cids = this.serializeContractIdFromPayments(cids, registerPaymentList);
            cids = this.serializeContractIdFromPayments(cids, bgPaymentList);
            cids = cids.substring(0, cids.lastIndexOf(","));
            try {
                List idTitles = ((PayOnlineService)this.getContext().getPort(PayOnlineService.class)).getContractTitles(Utils.toIntegerList((String)cids));
                this.setContractTitle(idTitles, registerPaymentList);
                this.setContractTitle(idTitles, bgPaymentList);
            }
            catch (Exception idTitles) {
                // empty catch block
            }
        }
        this.missingPaymentsTableModel.setData(registerPaymentList);
        totalSumm = BigDecimal.ZERO;
        for (Transaction payment : registerPaymentList) {
            totalSumm = totalSumm.add(payment.getSum());
        }
        this.totalMissingPaymentLabel.setText("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 " + registerPaymentList.size() + " \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 " + Utils.formatCost((BigDecimal)totalSumm));
    }

    private String serializeContractIdFromPayments(String cids, List<Transaction> paymentList) {
        for (Transaction payment : paymentList) {
            if (((String)cids).contains(String.valueOf(payment.getContractId()))) continue;
            cids = (String)cids + payment.getContractId() + ",";
        }
        return cids;
    }

    private void setContractTitle(List<IdTitle> idTitles, List<Transaction> paymentList) {
        block0: for (Transaction payment : paymentList) {
            for (IdTitle idTitle : idTitles) {
                if (idTitle.getId() != payment.getContractId()) continue;
                payment.setContractTitle(idTitle.getTitle());
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Transaction> getTransactionsFromFile() {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        CSVReader reader = null;
        try {
            reader = new CSVReader((Reader)new FileReader(this.selectedFile), ';');
            List allLines = reader.readAll();
            String dateFormat = "dd.MM.yyyy HH:mm:ss";
            if (!this.isRussianRegister(((String[])allLines.get(0))[0])) {
                dateFormat = "MM/dd/yyyy HH:mm:ss a";
            }
            for (int i = 1; i < allLines.size(); ++i) {
                String[] line = (String[])allLines.get(i);
                Transaction payment = new Transaction();
                payment.setTransactionId(line[2]);
                payment.setTransactionDate(TimeUtils.parseDate((String)line[0], (String)dateFormat));
                payment.setSum(new BigDecimal(line[10].contains(",") ? line[10].replaceAll(",", ".") : line[10]));
                String orderId = line[3];
                int contractId = Utils.parseInt((String)orderId.substring(0, orderId.indexOf("_")), (int)-1);
                payment.setContractId(contractId);
                result.add(payment);
            }
        }
        catch (IOException e) {
            this.getContext().processException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.getContext().processException((Throwable)e);
                }
            }
        }
        return result;
    }

    private boolean isRussianRegister(String firstLinePart) {
        boolean result = true;
        Pattern pattern = Pattern.compile("[\u0410-\u042f\u0430-\u044f]");
        Matcher matcher = pattern.matcher(firstLinePart);
        if (!matcher.find()) {
            result = false;
        }
        return result;
    }
}

