/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean.oper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.phone.server.bean.oper.Operator;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class OperatorManager {
    private static Logger log = LogManager.getLogger();
    private int mid;
    private Preferences moduleSetup;

    public OperatorManager(int mid, Preferences moduleSetup) {
        this.mid = mid;
        this.moduleSetup = moduleSetup;
    }

    public List<Operator> getOperatorList() throws BGException {
        ArrayList<Operator> result = new ArrayList<Operator>();
        for (Map operMap : this.moduleSetup.parseObjects("operator.")) {
            String operClass = (String)operMap.get("class");
            Operator operator = operClass != null ? (Operator)Utils.newInstance((String)operClass, Operator.class) : null;
            int id = Utils.parseInt((String)((String)operMap.get("id")));
            int cid = Utils.parseInt((String)((String)operMap.get("cid")));
            String title = (String)operMap.get("title");
            if (operator == null || id <= 0 || !Utils.notBlankString((String)title)) continue;
            operator.init(id, cid, title, this.mid, this.moduleSetup, new Preferences(operMap));
            try {
                operator.checkCorrectOperator();
                result.add(operator);
            }
            catch (BGException e) {
                log.error("error operator " + id + " config", (Throwable)e);
            }
        }
        return result;
    }

    public Map<Integer, Operator> getOperatorMap() throws BGException {
        HashMap<Integer, Operator> result = new HashMap<Integer, Operator>();
        for (Operator oper : this.getOperatorList()) {
            result.put(oper.getId(), oper);
        }
        return result;
    }
}

