/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client;

import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.phone.common.bean.Gate;
import ru.bitel.bgbilling.modules.phone.common.bean.GateType;
import ru.bitel.bgbilling.modules.phone.common.service.GatesService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class GatePanel
extends BGUPanel {
    private BGTableModel<Gate> model = null;
    private BGUTable table = null;
    private JPanel editor = new JPanel(new GridBagLayout());
    private JTextArea comment_TA = new JTextArea();
    private BGConfigEditorPane config = new BGConfigEditorPane();
    private JPasswordField keyword = new JPasswordField();
    private JTextField host = new JTextField();
    private IntTextField port = new IntTextField();
    private BGUComboBox<GateType> type_CB = new BGUComboBox();
    BGButtonPanelRestoreOkCancelHelp okCancelHelp = new BGButtonPanelRestoreOkCancelHelp();
    private int id = 0;

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.model = new BGTableModel<Gate>("gates"){

            protected void initColumns() {
                this.addColumn("\u0425\u043e\u0441\u0442:\u043f\u043e\u0440\u0442", -1, 150, -1, "host", true);
                this.addColumn("\u0422\u0438\u043f", -1, 150, -1, "type", false);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0440\u0438\u0439", -1, 150, 200, "comment", true);
            }

            public Object getValue(Gate val, int column) throws BGException {
                switch (column) {
                    case 0: {
                        return val.getHost() + ":" + val.getPort();
                    }
                    case 1: {
                        return val.getTypeTitle();
                    }
                    case 2: {
                        return val.getComment();
                    }
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        this.table.setSelectionMode(0);
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.createEditor();
        this.editor.setVisible(false);
        this.okCancelHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GatePanel.this.performAction("stop.edit", e.getActionCommand());
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GatePanel.this.performAction("edit");
                }
            }
        });
    }

    private void stopEdit(boolean save) throws BGException {
        if (save) {
            if (Utils.isEmptyString((String)this.host.getText())) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u0435 \u0445\u043e\u0441\u0442!");
                return;
            }
            if (Utils.isEmptyString((String)this.port.getText())) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u0435 \u043f\u043e\u0440\u0442!");
                return;
            }
            if (this.type_CB.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0443\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0442\u0438\u043f \u0448\u043b\u044e\u0437\u0430!");
                return;
            }
            Gate gate = new Gate();
            gate.setId(this.id);
            gate.setComment(this.comment_TA.getText());
            gate.setHost(this.host.getText());
            gate.setKeyword(new String(this.keyword.getPassword()));
            gate.setPort((int)this.port.getValue());
            gate.setConfig(this.config.getText());
            gate.setTypeId(((GateType)this.type_CB.getSelectedItem()).getId());
            ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).updateGate(gate);
            this.setData();
            this.editor.setVisible(false);
        } else {
            this.editor.setVisible(false);
        }
    }

    private void createEditor() {
        JPanel hostPortPanel = new JPanel(new GridBagLayout());
        JPanel keyPanel = new JPanel(new GridBagLayout());
        hostPortPanel.setBorder((Border)new BGTitleBorder(" \u0425\u043e\u0441\u0442 \u0438 \u043f\u043e\u0440\u0442 \u0448\u043b\u044e\u0437\u0430 "));
        this.port.setMinimumSize(new Dimension(77, 24));
        this.port.setPreferredSize(new Dimension(77, 24));
        this.port.setColumns(7);
        this.port.setHorizontalAlignment(0);
        keyPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043b\u044e\u0447\u0435\u0432\u043e\u0435 \u0441\u043b\u043e\u0432\u043e "));
        this.keyword.setMinimumSize(new Dimension(110, 24));
        this.keyword.setPreferredSize(new Dimension(110, 24));
        this.keyword.setColumns(10);
        JPanel typePanel = new JPanel(new GridBagLayout());
        typePanel.setBorder((Border)new BGTitleBorder(" \u0422\u0438\u043f \u0448\u043b\u044e\u0437\u0430 "));
        typePanel.add((Component)this.type_CB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.host.setMinimumSize(new Dimension(150, 24));
        this.host.setPreferredSize(new Dimension(150, 24));
        this.editor.add((Component)hostPortPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.add((Component)keyPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.add((Component)typePanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JTabbedPane tabbedPane = new JTabbedPane();
        JScrollPane commentScroll = new JScrollPane(this.comment_TA);
        JPanel commentPanel = new JPanel(new GridBagLayout());
        commentPanel.add((Component)commentScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        tabbedPane.add((Component)commentPanel, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        JScrollPane configScroll = new JScrollPane((Component)this.config);
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.add((Component)configScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        tabbedPane.add((Component)configPanel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        this.editor.add((Component)tabbedPane, new GridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.editor.add((Component)this.okCancelHelp, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        keyPanel.add((Component)this.keyword, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        hostPortPanel.add((Component)this.host, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        hostPortPanel.add((Component)this.port, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        hostPortPanel.add((Component)new JLabel(" : "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setData() throws BGException {
        List result = ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).listGates();
        this.model.setData(result);
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("stop.edit", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GatePanel.this.stopEdit(e.getActionCommand().equals("ok"));
            }
        };
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GatePanel.this.setData();
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GatePanel.this.id = 0;
                GatePanel.this.editor.setVisible(true);
                GatePanel.this.comment_TA.setText(null);
                GatePanel.this.config.setText(null);
                GatePanel.this.keyword.setText(null);
                GatePanel.this.host.setText(null);
                GatePanel.this.port.setText(null);
                GatePanel.this.buildCombobox();
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Gate gate = (Gate)GatePanel.this.model.getSelectedRow();
                if (gate != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0448\u043b\u044e\u0437:" + gate.getHost() + ":" + gate.getPort() + " ?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    ((GatesService)((ClientContext)GatePanel.this.getContext()).getPort(GatesService.class)).deleteGate(gate.getId());
                    GatePanel.this.setData();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GatePanel.this.editItem();
            }
        };
    }

    private void editItem() throws BGException {
        Gate type = (Gate)this.model.getSelectedRow();
        if (type != null) {
            this.id = type.getId();
            this.editor.setVisible(true);
            this.comment_TA.setText(type.getComment());
            this.config.setText(type.getConfig());
            this.keyword.setText(type.getKeyword());
            this.host.setText(type.getHost());
            this.port.setText(String.valueOf(type.getPort()));
            this.buildCombobox();
            this.type_CB.setSelectedItem((Object)type.getTypeId());
        }
    }

    private void buildCombobox() throws BGException {
        List types = ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).listTypes();
        this.type_CB.setData(types);
    }
}

