/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rfiec.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.modules.rfiec.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.rfiec.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.rfiec.server.bean.Constants;
import ru.bitel.bgbilling.modules.rfiec.server.bean.TransactionManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class ActionDoTransaction
extends AbstractAction {
    private final String moduleName = "rfiec";

    public void execute() throws BGException {
        if (this.context.getRequest().getAttribute("contentType") == null) {
            this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.jsp);
        }
        String[] sort = new String[]{"createDate:1", "transactionDate:1"};
        SearchResult searchResult = new SearchResult(this.getPeriod(), this.getPage(), sort);
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        transactionManager.searchTransaction(searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        transactionManager.close();
        this.setResultParam("transactions", searchResult.getList());
        this.setResultParam("gateUrl", this.moduleSetup.get("rfiec.url.gate", "https://partner.rficb.ru/alba/input/"));
        this.setMinMaxSum("rfiec", Constants.class);
        this.setCustomerAddress("rfiec", Constants.class);
        this.setCustomerEmail(true, true);
        boolean autopaymentEnable = this.moduleSetup.getBoolean("rfiec.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId)) {
            this.setCustomerEmail(true, true);
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            autopaymentManager.close();
            Preferences autopaymentModePreferences = new Preferences();
            this.setAutopaymentEnabled(autopayment, autopaymentModePreferences, "rfiec.autopayment.mode.default", 0);
            this.setAutopaymentModeWeek(autopayment, autopaymentModePreferences, "rfiec.autopayment.mode.week.enable", "rfiec.autopayment.mode.week.day.default", "rfiec.autopayment.mode.week.sum.default", 50, "rfiec.autopayment.mode.week.sum.min", 50, "rfiec.autopayment.mode.week.sum.max", 3000);
            this.setAutopaymentModeMonth(autopayment, autopaymentModePreferences, "rfiec.autopayment.mode.month.enable", "rfiec.autopayment.mode.month.day.default", "rfiec.autopayment.mode.month.sum.default", 50, "rfiec.autopayment.mode.month.sum.min", 50, "rfiec.autopayment.mode.month.sum.max", 10000);
            this.setAutopaymentModeAuto(autopayment, autopaymentModePreferences, "rfiec.autopayment.mode.auto.enable", "rfiec.autopayment.mode.auto.day.sum.default", 500, "rfiec.autopayment.mode.auto.week.sum.default", 1000, "rfiec.autopayment.mode.auto.month.sum.default", 3000, "rfiec.autopayment.mode.auto.day.sum.max", 3000, "rfiec.autopayment.mode.auto.week.sum.max", 5000, "rfiec.autopayment.mode.auto.month.sum.max", 10000);
        }
    }

    public void success() throws BGException {
        this.execute();
    }

    public void fail() throws BGException {
        this.execute();
    }

    public void getOrderId() throws Exception {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("rfiec.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("rfiec.sum.max", new BigDecimal(5000));
        ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        transactionManager.registerOrder(this.contractId, contract.getTitle(), null, null, sum, this.getResult(), false);
        transactionManager.close();
    }

    public void autopayment() throws Exception {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        boolean autopaymentEnable = this.moduleSetup.getBoolean("rfiec.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId)) {
            String customerEmail = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            int mode = this.req.getInt("mode", 0);
            this.setResultParam("mode", mode);
            if (mode > -1 && mode < 4) {
                Preferences modeDataMap;
                AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
                if (autopayment != null) {
                    if (autopayment.getMode() != AutopaymentMode.OFF) {
                        autopaymentManager.autopaymentOff(autopayment);
                    }
                    if (mode != autopayment.getMode().getCode()) {
                        autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                        autopaymentManager.updateAutopayment(autopayment);
                        autopayment = null;
                    }
                }
                if (autopayment == null) {
                    autopayment = new Autopayment();
                    autopayment.setContractId(this.contractId);
                }
                TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
                String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle();
                Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
                if (mode == AutopaymentMode.OFF.getCode()) {
                    autopayment.setMode(AutopaymentMode.OFF);
                    autopayment.setSum(BigDecimal.ZERO);
                    autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                    autopayment.setAccessToken(null);
                } else if (mode == AutopaymentMode.WEEK.getCode()) {
                    int autopaymentWeekDay = this.moduleSetup.getInt("rfiec.autopayment.mode.week.day.default", 1);
                    modeDataMap.set("autopayment.mode.week.day", String.valueOf(this.req.getInt("dayOfWeek", autopaymentWeekDay)));
                    BigDecimal autopaymentWeekSum = this.moduleSetup.getBigDecimal("rfiec.autopayment.mode.week.sum.default", new BigDecimal(50));
                    autopaymentWeekSum = this.req.getBigDecimal("weekSum", autopaymentWeekSum);
                    modeDataMap.set("autopayment.mode.week.sum", String.valueOf(autopaymentWeekSum));
                    autopayment.setSum(autopaymentWeekSum);
                    autopayment.setMode(AutopaymentMode.WEEK);
                    transactionManager.registerOrder(this.contractId, contractTitle, customerEmail, null, autopaymentWeekSum, this.getResult(), true);
                } else if (mode == AutopaymentMode.MONTH.getCode()) {
                    int autopaymentMonthDay = this.moduleSetup.getInt("rfiec.autopayment.mode.month.day.default", 1);
                    modeDataMap.set("autopayment.mode.month.day", String.valueOf(this.req.getInt("dayOfMonth", autopaymentMonthDay)));
                    BigDecimal autopaymentMonthSum = this.moduleSetup.getBigDecimal("rfiec.autopayment.mode.month.sum.default", new BigDecimal(50));
                    autopaymentMonthSum = this.req.getBigDecimal("monthSum", autopaymentMonthSum);
                    modeDataMap.set("autopayment.mode.month.sum", String.valueOf(autopaymentMonthSum));
                    autopayment.setSum(autopaymentMonthSum);
                    autopayment.setMode(AutopaymentMode.MONTH);
                    transactionManager.registerOrder(this.contractId, contractTitle, customerEmail, null, autopaymentMonthSum, this.getResult(), true);
                } else if (mode == AutopaymentMode.AUTO.getCode()) {
                    BigDecimal autopaymentAutoMaxDaySum = this.moduleSetup.getBigDecimal("rfiec.autopayment.mode.auto.day.sum.default", new BigDecimal(500));
                    autopaymentAutoMaxDaySum = this.req.getBigDecimal("maxDaySum", autopaymentAutoMaxDaySum);
                    modeDataMap.set("autopayment.mode.auto.day.sum", String.valueOf(autopaymentAutoMaxDaySum));
                    BigDecimal autopaymentAutoMaxWeekSum = this.moduleSetup.getBigDecimal("rfiec.autopayment.mode.auto.week.sum.default", new BigDecimal(1000));
                    autopaymentAutoMaxWeekSum = this.req.getBigDecimal("maxWeekSum", autopaymentAutoMaxWeekSum);
                    modeDataMap.set("autopayment.mode.auto.week.sum", String.valueOf(autopaymentAutoMaxWeekSum));
                    BigDecimal autopaymentAutoMaxMonthSum = this.moduleSetup.getBigDecimal("rfiec.autopayment.mode.auto.month.sum.default", new BigDecimal(3000));
                    autopaymentAutoMaxMonthSum = this.req.getBigDecimal("maxMonthSum", autopaymentAutoMaxMonthSum);
                    modeDataMap.set("autopayment.mode.auto.month.sum", String.valueOf(autopaymentAutoMaxMonthSum));
                    autopayment.setSum(autopaymentAutoMaxDaySum);
                    autopayment.setMode(AutopaymentMode.AUTO);
                    transactionManager.registerOrder(this.contractId, contractTitle, customerEmail, null, autopaymentAutoMaxDaySum, this.getResult(), true);
                }
                autopayment.setModeData(modeDataMap.toString());
                autopaymentManager.updateAutopayment(autopayment);
                autopaymentManager.close();
                transactionManager.close();
            }
        }
    }
}

