/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGSummaTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.runtel.client.ServicePropertiesBaseTabPanel;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelIdPeriod;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.TariffAdditionalItem;
import ru.bitel.bgbilling.modules.runtel.common.bean.TariffNumberItem;
import ru.bitel.bgbilling.modules.runtel.common.bean.TariffServiceItem;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.PeriodWithTime;

public class ServicePropertiesTariffTabPanel
extends ServicePropertiesBaseTabPanel {
    private int tariffId = 0;
    private List<RunTelIdPeriod> periods = null;
    private JTextField tariffTitle = null;
    private BGSummaTextField summa = null;
    private BGButton prevTariffButton = null;
    private BGButton nextTariffButton = null;
    private ServiceTableModel serviceTableModel = null;
    private PeriodPanel currentPeriod = null;
    private RunTelContractTariff runTelContractTariff = null;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            ServicePropertiesTariffTabPanel.this.periods = ServicePropertiesTariffTabPanel.this.getRunTelService().getContractTariffIds(((ClientContext)ServicePropertiesTariffTabPanel.this.getContext()).getContractId());
            ServicePropertiesTariffTabPanel.this.tariffTitle.setText("");
            ServicePropertiesTariffTabPanel.this.currentPeriod.setPeriod(null);
            ServicePropertiesTariffTabPanel.this.serviceTableModel.setData(new ArrayList());
            ServicePropertiesTariffTabPanel.this.prevTariffButton.setEnabled(false);
            ServicePropertiesTariffTabPanel.this.nextTariffButton.setEnabled(false);
            if (ServicePropertiesTariffTabPanel.this.periods == null) {
                return;
            }
            int index = -1;
            LocalDateTime now = LocalDateTime.now();
            for (index = ServicePropertiesTariffTabPanel.this.periods.size(); index > 0; --index) {
                RunTelIdPeriod runTelIdPeriod = ServicePropertiesTariffTabPanel.this.periods.get(index - 1);
                LocalDateTime dateTo = runTelIdPeriod.getPeriod().getLocalDateTimeTo();
                if (dateTo == null || dateTo.compareTo(now) > -1) {
                    ServicePropertiesTariffTabPanel.this.tariffId = runTelIdPeriod.getId();
                    continue;
                }
                if (dateTo.compareTo(now) < 0) break;
            }
            ServicePropertiesTariffTabPanel.this.showRunTelTariff(index);
        }
    };
    AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            ServicePropertiesTariffTabPanel.this.showEditor(true);
        }
    };
    AbstractBGUPanel.DefaultAction editAction = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            ServicePropertiesTariffTabPanel.this.showEditor(false);
        }
    };
    AbstractBGUPanel.DefaultAction deleteAction = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            if (ServicePropertiesTariffTabPanel.this.runTelContractTariff == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0422\u0430\u0440\u0438\u0444 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d!");
            } else {
                LocalDateTime date = LocalDateTime.now();
                if (TimeUtils.dateInPeriod((LocalDateTime)date, (PeriodWithTime)ServicePropertiesTariffTabPanel.this.runTelContractTariff.getPeriod()) || ServicePropertiesTariffTabPanel.this.runTelContractTariff.getPeriod().getLocalDateTimeFrom().isBefore(date)) {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!");
                } else if (ServicePropertiesTariffTabPanel.this.runTelContractTariff.getPeriod().getLocalDateTimeFrom().isBefore(date)) {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0430\u0440\u0445\u0438\u0432\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!");
                } else if (ClientUtils.confirmDelete((Object)ServicePropertiesTariffTabPanel.this.tariffTitle.getText())) {
                    ServicePropertiesTariffTabPanel.this.getRunTelService().deleteContractTariff(ServicePropertiesTariffTabPanel.this.runTelContractTariff.getId());
                    ServicePropertiesTariffTabPanel.this.runTelContractTariff = null;
                    ServicePropertiesTariffTabPanel.this.performAction("refresh");
                }
            }
        }
    };

    @Override
    protected void jbInit() throws Exception {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getTariffPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getTariffPanel() {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getRow1Panel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getRow2Panel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.getRow3Panel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getNumberPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getRow1Panel() {
        this.prevTariffButton = new BGButton("\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439");
        this.prevTariffButton.addActionListener(e -> {
            if (this.periods != null) {
                for (int index = 0; index < this.periods.size(); ++index) {
                    if (this.periods.get(index).getId() != this.tariffId) continue;
                    if (index > 0) {
                        this.tariffId = this.periods.get(index - 1).getId();
                        this.showRunTelTariff(index - 1);
                        break;
                    }
                    ClientUtils.showErrorMessageDialog((String)"\u042d\u0442\u043e \u043f\u0435\u0440\u0432\u044b\u0439 \u0442\u0430\u0440\u0438\u0444!");
                    break;
                }
            }
        });
        this.nextTariffButton = new BGButton("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439");
        this.nextTariffButton.addActionListener(e -> {
            if (this.periods != null) {
                for (int index = 0; index < this.periods.size(); ++index) {
                    if (this.periods.get(index).getId() != this.tariffId) continue;
                    if (index < this.periods.size() - 1) {
                        this.tariffId = this.periods.get(index + 1).getId();
                        this.showRunTelTariff(index + 1);
                        break;
                    }
                    ClientUtils.showErrorMessageDialog((String)"\u042d\u0442\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0442\u0430\u0440\u0438\u0444!");
                    break;
                }
            }
        });
        this.tariffTitle = new JTextField(50);
        this.tariffTitle.setHorizontalAlignment(0);
        Color bgColor = this.tariffTitle.getBackground();
        this.tariffTitle.setEditable(false);
        this.tariffTitle.setBackground(bgColor);
        this.currentPeriod = new PeriodPanel();
        this.currentPeriod.setEnabled(false);
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.prevTariffButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.nextTariffButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.tariffTitle, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.currentPeriod, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getRow2Panel() {
        this.serviceTableModel = new ServiceTableModel(ServiceTableModel.class.getName());
        BGUTable table = new BGUTable((TableModel)((Object)this.serviceTableModel));
        table.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getRow3Panel() {
        this.summa = new BGSummaTextField();
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0418\u0442\u043e\u0433\u043e:"), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.summa, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getNumberPanel() {
        NumberTableModel numberTableModel = new NumberTableModel(NumberTableModel.class.getName());
        BGUTable table = new BGUTable((TableModel)((Object)numberTableModel));
        table.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane((Component)table);
        scrollPane.setMinimumSize(new Dimension(200, 200));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440\u0430:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void showEditor(boolean newTariff) {
        if (!newTariff && this.runTelContractTariff != null) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime dateFrom = this.runTelContractTariff.getPeriod().getLocalDateTimeFrom();
            LocalDateTime dateTo = this.runTelContractTariff.getPeriod().getLocalDateTimeTo();
            if (dateTo != null && dateTo.isBefore(now)) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0435\u0440\u0438\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0441\u044f, \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e.");
                return;
            }
            if (dateFrom == null || dateFrom.isBefore(now)) {
                this.showRuntelTariffDateToEditor();
                return;
            }
        }
        List runTelTariffs = null;
        List additionalServiceItems = null;
        try {
            additionalServiceItems = this.getRunTelService().getTariffAdditionalServiceItems();
            runTelTariffs = this.getRunTelService().searchRunTelTariff().getList();
        }
        catch (BGException e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
        JButton okButton = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        JButton cancelButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        RunTelContractTariff runTelContractTariff = new RunTelContractTariff();
        runTelContractTariff.setContractId(((ClientContext)this.getContext()).getContractId());
        EditorPanel editorPanel = new EditorPanel(runTelContractTariff, runTelTariffs, additionalServiceItems, okButton);
        if (!newTariff && runTelContractTariff != null) {
            editorPanel.setRunTelContractTariff(this.runTelContractTariff);
        }
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(editorPanel);
        optionPane.setMessageType(-1);
        optionPane.setOptions(new Object[]{okButton, cancelButton});
        optionPane.setInitialValue(okButton);
        JDialog dialog = optionPane.createDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430");
        okButton.setEnabled(!newTariff);
        okButton.addActionListener(e -> dialog.setVisible(false));
        cancelButton.addActionListener(e -> {
            okButton.setEnabled(false);
            dialog.setVisible(false);
        });
        dialog.setVisible(true);
        dialog.dispose();
        if (okButton.isEnabled()) {
            try {
                int id = this.getRunTelService().updateContractTariff(editorPanel.getRunTelContractTariff());
                this.periods = this.getRunTelService().getContractTariffIds(((ClientContext)this.getContext()).getContractId());
                this.setTariffId(id);
            }
            catch (BGException e1) {
                ClientUtils.showErrorMessageDialog((Throwable)e1);
            }
        }
    }

    private void showRuntelTariffDateToEditor() {
        BGControlPanelDateNoB dateTo = new BGControlPanelDateNoB();
        LocalDateTime localDateTime = this.runTelContractTariff.getPeriod().getLocalDateTimeTo();
        dateTo.setLocalDate(localDateTime == null ? null : localDateTime.toLocalDate());
        Component[][] components = new Component[][]{{new JLabel("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u0430:"), dateTo}};
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        ClientUtils.addComponentToPanel((JPanel)panel, (int)gridy, (Component[][])components, (boolean)true);
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u0430\u0442\u044b");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            LocalDate date = dateTo.getLocalDate();
            LocalDate now = LocalDate.now();
            if (date == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
                return;
            }
            if (date.compareTo(now) < 0) {
                ClientUtils.showErrorMessageDialog((String)String.format("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0442\u0430\u0440\u0438\u0444\u0430, \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u0430: \"%s\"", now.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"))));
                return;
            }
            try {
                this.getRunTelService().updateContractTariffDateTo(this.runTelContractTariff.getId(), date.atStartOfDay().plusDays(1L).minusSeconds(1L));
                this.performAction("refresh");
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        dialog.setVisible(true);
    }

    public void showRunTelTariff(int index) {
        try {
            this.runTelContractTariff = this.getRunTelService().getContractTariff(this.tariffId);
            if (this.runTelContractTariff != null) {
                BigDecimal sum = BigDecimal.ZERO;
                RunTelTariff runTelTariff = this.getRunTelService().getRunTelTariff(this.runTelContractTariff.getTariffId());
                this.tariffTitle.setText(runTelTariff != null ? runTelTariff.getTitle() : "!!! \u0422\u0410\u0420\u0418\u0424 \u041d\u0415 \u041d\u0410\u0419\u0414\u0415\u041d !!!");
                this.currentPeriod.setPeriod(this.runTelContractTariff.getPeriod());
                JSONObject runTelTariffConfig = new JSONObject(runTelTariff == null ? "{}" : runTelTariff.getConfig());
                JSONObject includeJsonObject = runTelTariffConfig.optJSONObject("include");
                JSONObject additionalJsonObject = runTelTariffConfig.optJSONObject("additional");
                JSONObject tariffJsonObject = new JSONObject(this.runTelContractTariff.getConfig());
                List items = this.getRunTelService().getTariffServiceItems();
                for (TariffServiceItem tariffServiceItem : items) {
                    String name = tariffServiceItem.getName();
                    if ("monthlyFee".equals(name)) {
                        tariffServiceItem.setIncluded(1);
                        tariffServiceItem.setSum(runTelTariff.getCost());
                    } else {
                        if (includeJsonObject.has(name)) {
                            tariffServiceItem.setIncluded(includeJsonObject.optInt(name));
                        }
                        if (tariffJsonObject.has(name)) {
                            tariffServiceItem.setAdditional(tariffJsonObject.optInt(name));
                            if (additionalJsonObject.has(name)) {
                                JSONObject jsonObject = additionalJsonObject.getJSONObject(name);
                                BigDecimal cost = jsonObject.optBigDecimal("cost", BigDecimal.ZERO);
                                tariffServiceItem.setSum(cost.multiply(new BigDecimal(tariffServiceItem.getAdditional())));
                            }
                        }
                    }
                    sum = sum.add(tariffServiceItem.getSum());
                }
                this.serviceTableModel.setData(items);
                this.summa.setText(Utils.getDecimalFormatSumma().format(sum));
                this.prevTariffButton.setEnabled(index > 0);
                this.nextTariffButton.setEnabled(index < this.periods.size() - 1);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void setTariffId(int tariffId) {
        this.tariffId = tariffId;
        for (int index = 0; index < this.periods.size(); ++index) {
            if (this.periods.get(index).getId() != tariffId) continue;
            this.showRunTelTariff(index);
            return;
        }
    }

    class ServiceTableModel
    extends BGTableModel<TariffServiceItem> {
        public ServiceTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 100, 300, -1, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0432 \u0442\u0430\u0440\u0438\u0444", 200, 200, 200, "included", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e", 200, 200, 200, "additional", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 100, 100, 100, "sum", true).setTableCellRenderer(DecimalTableCellRenderer.DEFAULT);
        }
    }

    class PeriodPanel
    extends JPanel {
        private JTextField fromField;
        private JTextField toField;

        public PeriodPanel() {
            super(new GridBagLayout());
            this.fromField = new JTextField(12);
            this.toField = new JTextField(12);
            Color bgColor = this.fromField.getBackground();
            this.fromField.setEditable(false);
            this.fromField.setBackground(bgColor);
            this.fromField.setHorizontalAlignment(0);
            this.toField.setEditable(false);
            this.toField.setBackground(bgColor);
            this.toField.setHorizontalAlignment(0);
            int gridx = 0;
            this.add((Component)new JLabel("c"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.fromField, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.toField, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        }

        public void setPeriod(PeriodWithTime period) {
            DateTimeFormatter formatter = TimeUtils.getDateTimeFormatter((String)"dd.MM.yyyy HH:mm");
            this.fromField.setText(period != null && period.getLocalDateTimeFrom() != null ? period.getLocalDateTimeFrom().format(formatter) : "");
            this.toField.setText(period != null && period.getLocalDateTimeTo() != null ? period.getLocalDateTimeTo().format(formatter) : "");
        }
    }

    class NumberTableModel
    extends BGTableModel<TariffNumberItem> {
        public NumberTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", 100, 300, -1, "number", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439", 100, 300, -1, "additional", true);
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 300, -1, "period", true);
        }
    }

    class EditorPanel
    extends JPanel {
        private JPanel addiPanel;
        private JButton okButton;
        private BGUComboBox<IdTitle> tariffComboBox;
        private RunTelContractTariff runTelContractTariff;
        private List<TariffAdditionalItem> additionalServiceItems;

        public EditorPanel(RunTelContractTariff runTelContractTariff, List<RunTelTariff> runTelTariffs, List<TariffAdditionalItem> additionalServiceItems, JButton okButton) {
            super(new GridBagLayout());
            this.addiPanel = null;
            this.okButton = null;
            this.tariffComboBox = null;
            this.runTelContractTariff = null;
            this.additionalServiceItems = null;
            this.okButton = okButton;
            this.runTelContractTariff = runTelContractTariff;
            this.additionalServiceItems = additionalServiceItems;
            this.addiPanel = new JPanel(new GridBagLayout());
            this.initAddiPanel(null);
            this.tariffComboBox = new BGUComboBox();
            this.tariffComboBox.setData(runTelTariffs);
            this.tariffComboBox.insertItemAt((Object)new IdTitle(0, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444"), 0);
            this.tariffComboBox.setSelectedIndex(0);
            this.tariffComboBox.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    if (((IdTitle)itemEvent.getItem()).getId() > 0) {
                        this.initAddiPanel(((RunTelTariff)itemEvent.getItem()).getConfig());
                        this.setOkButton();
                    }
                } else if (itemEvent.getStateChange() == 2) {
                    this.initAddiPanel(null);
                    okButton.setEnabled(false);
                }
            });
            this.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.tariffComboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.addiPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
        }

        public void setRunTelContractTariff(RunTelContractTariff runTelContractTariff) {
            if (runTelContractTariff != null) {
                for (int index = 0; index < this.tariffComboBox.getItemCount(); ++index) {
                    if (((IdTitle)this.tariffComboBox.getItemAt(index)).getId() != runTelContractTariff.getTariffId()) continue;
                    this.tariffComboBox.setSelectedIndex(index);
                    break;
                }
                JSONObject config = new JSONObject(runTelContractTariff.getConfig());
                for (int index = 0; index < this.additionalServiceItems.size(); ++index) {
                    JTextField serviceCount = this.addiPanel.getComponentCount() > 2 * index ? (JTextField)this.addiPanel.getComponent(2 * index + 1) : new JTextField();
                    serviceCount.setText(String.valueOf(config.optInt(this.additionalServiceItems.get(index).getName(), 0)));
                }
            }
        }

        private void setOkButton() {
            boolean ok = ((IdTitle)this.tariffComboBox.getSelectedItem()).getId() > 0;
            this.okButton.setEnabled(ok);
        }

        public RunTelContractTariff getRunTelContractTariff() {
            this.runTelContractTariff.setTariffId(((IdTitle)this.tariffComboBox.getSelectedItem()).getId());
            this.runTelContractTariff.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
            JSONObject jsonObject = new JSONObject();
            for (int index = 0; index < this.additionalServiceItems.size(); ++index) {
                JTextField serviceCount = this.addiPanel.getComponentCount() > 2 * index ? (JTextField)this.addiPanel.getComponent(2 * index + 1) : new JTextField();
                jsonObject.put(this.additionalServiceItems.get(index).getName(), Utils.parseInt((String)serviceCount.getText()));
            }
            this.runTelContractTariff.setConfig(jsonObject.toString());
            return this.runTelContractTariff;
        }

        private void initAddiPanel(String config) {
            JSONObject configJsonObject = new JSONObject(config == null ? "{}" : config);
            JSONObject additionalJsonObject = configJsonObject.optJSONObject("additional");
            JTextField field = new JTextField();
            Color bgEnColor = field.getBackground();
            field.setEditable(false);
            Color bgDeColor = field.getBackground();
            for (int index = 0; index < this.additionalServiceItems.size(); ++index) {
                TariffAdditionalItem additionalServiceItem = this.additionalServiceItems.get(index);
                JSONObject itemJsonObject = additionalJsonObject != null ? additionalJsonObject.optJSONObject(additionalServiceItem.getName()) : null;
                boolean editable = itemJsonObject != null && itemJsonObject.optBoolean("enable", false);
                JTextField serviceTitle = this.addiPanel.getComponentCount() > 2 * index ? (JTextField)this.addiPanel.getComponent(2 * index) : new JTextField(60);
                serviceTitle.setEditable(false);
                serviceTitle.setBackground(editable ? bgEnColor : bgDeColor);
                serviceTitle.setText(additionalServiceItem.getTitle());
                JTextField serviceCount = this.addiPanel.getComponentCount() > 2 * index ? (JTextField)this.addiPanel.getComponent(2 * index + 1) : new JTextField(5);
                serviceCount.setHorizontalAlignment(4);
                serviceCount.setText("0");
                serviceCount.setEditable(editable);
                if (this.addiPanel.getComponentCount() >= 2 * index + 1) continue;
                int gridx = 0;
                this.addiPanel.add((Component)serviceTitle, new GridBagConstraints(gridx++, index, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.addiPanel.add((Component)serviceCount, new GridBagConstraints(gridx++, index, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
    }
}

