/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api.sputnik;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class SputnikManager {
    private Logger logger = LogManager.getLogger();
    private String serverUrl = null;
    private String token = null;
    private int connectTimeout;
    private int readTimeout;

    public SputnikManager(int moduleId) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.serverUrl = moduleSetup.get("sputnik.server.url", "https://api.sputnik.systems/api/v1");
        this.token = moduleSetup.get("sputnik.token", null);
        this.readTimeout = moduleSetup.getInt("sputnik.request.timeout.read", 10000);
        this.connectTimeout = moduleSetup.getInt("sputnik.request.timeout.connect", 10000);
    }

    public boolean isEnabled() {
        return this.token != null;
    }

    public JSONObject getAccountTokens() throws Exception {
        return this.doRequest("/account/tokens", "GET");
    }

    public JSONObject getAccountDevicesIntercoms(int page) throws Exception {
        return this.doRequest("/account/devices/intercoms?page=" + page, "GET");
    }

    public JSONObject getAccountDevicesIntercomsFlats(String uuid) throws Exception {
        return this.doRequest("/account/devices/intercoms/" + uuid + "/flats", "GET");
    }

    public JSONObject getAccountDevicesIntercomsShadow(String uuid) throws Exception {
        return this.doRequest("/account/devices/intercoms/" + uuid + "/shadow", "GET");
    }

    public JSONObject patchAccountDevicesIntercomsChangeFlatConfig(String uuid, int flatNum, boolean blocked) throws BGException, Exception {
        JSONObject flat = null;
        JSONObject resultJson = this.getAccountDevicesIntercomsFlats(uuid);
        JSONObject flatsConfigJson = resultJson.getJSONObject("flats_config");
        JSONArray flats = flatsConfigJson.getJSONArray("flats");
        for (int index = 0; index < flats.length(); ++index) {
            JSONObject json = flats.getJSONObject(index);
            if (json.getInt("num") != flatNum) continue;
            flat = json;
            break;
        }
        if (flat == null) {
            throw new BGException("FlatConfig not found [uuid=" + uuid + "; flatNum=" + flatNum + "]");
        }
        flat.put("blocked", blocked);
        flat.getJSONObject("analog_settings").put("blocked", blocked);
        JSONObject json = new JSONObject();
        json.put("flats_config", (Object)flat);
        return this.doRequest("/account/devices/intercoms/" + uuid + "/change_flat_config", "PATCH", json.toString());
    }

    protected JSONObject doRequest(String uri, String httpMethod) throws Exception {
        return this.doRequest(uri, httpMethod, null);
    }

    protected JSONObject doRequest(String uri, String httpMethod, String outData) throws Exception {
        if (this.serverUrl == null) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"sputnik.server.url=\"");
        }
        if (this.token == null) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"sputnik.token=\"");
        }
        boolean error = false;
        StringBuilder result = new StringBuilder();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        if ("GET".equals(httpMethod)) {
            HttpGet httpGet = new HttpGet(this.serverUrl + uri);
            httpGet.addHeader("Authorization", "Bearer " + this.token);
            httpGet.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.readTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(10000).build());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
                result.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        } else if ("POST".equals(httpMethod)) {
            StringEntity stringEntity = new StringEntity(outData);
            stringEntity.setContentType("application/json");
            HttpPost httpPost = new HttpPost(this.serverUrl + uri);
            httpPost.addHeader("Authorization", "Bearer " + this.token);
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.readTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(10000).build());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                result.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        } else if ("PATCH".equals(httpMethod)) {
            StringEntity stringEntity = new StringEntity(outData);
            stringEntity.setContentType("application/json");
            HttpPatch httpPatch = new HttpPatch(this.serverUrl + uri);
            httpPatch.addHeader("Authorization", "Bearer " + this.token);
            httpPatch.setEntity((HttpEntity)stringEntity);
            httpPatch.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.readTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(10000).build());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPatch);){
                result.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        } else {
            InputStream inputStream;
            URL url = new URL(this.serverUrl + uri);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u0421\u041f\u0423\u0422\u041d\u0418\u041a: URL \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + this.serverUrl + uri);
            }
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.setRequestMethod(httpMethod);
            connection.setRequestProperty("Authorization", "Bearer " + this.token);
            connection.setDoInput(true);
            if ("POST".equals(httpMethod) || "PATCH".equals(httpMethod)) {
                connection.setDoOutput(true);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
                bw.write(outData.toCharArray());
                bw.close();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u0421\u041f\u0423\u0422\u041d\u0418\u041a: \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + outData);
                }
            }
            connection.connect();
            error = connection.getResponseCode() != 200;
            InputStream inputStream2 = inputStream = error ? connection.getErrorStream() : connection.getInputStream();
            if (inputStream != null) {
                this.logger.debug("\u0421\u041f\u0423\u0422\u041d\u0418\u041a: ContentLength = " + connection.getContentLength());
                result.append(new String(Utils.readByBlock((InputStream)inputStream), "UTF-8"));
            } else {
                this.logger.error("connection.getResponseCode() = " + connection.getResponseCode());
                this.logger.error("inputStream = " + inputStream);
            }
            connection.disconnect();
        }
        httpclient.close();
        if (error) {
            this.logger.error("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0421\u041f\u0423\u0422\u041d\u0418\u041a: " + result.toString());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0421\u041f\u0423\u0422\u041d\u0418\u041a: " + result.toString());
        }
        return new JSONObject(result.toString());
    }
}

