/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class SmartHousePackageBaseDao
extends AbstractIdDao<SmartHousePackageBase>
implements Directory<SmartHousePackageBase> {
    private Logger logger = LogManager.getLogger();

    public SmartHousePackageBaseDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_package");
    }

    public void searchPackageBases(SearchResult<SmartHousePackageBase> searchResult, String title, boolean showOld) throws BGException {
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE true " + (Utils.notBlankString((String)title) ? " AND title LIKE ?" : "") + (page == null ? "" : page.sqlLimit());
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            if (Utils.notBlankString((String)title)) {
                psSelect.setString(parameterIndex++, title);
            }
            ResultSet resultSet = psSelect.executeQuery();
            while (resultSet.next()) {
                list.add(this.getFromRS(resultSet));
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    protected SmartHousePackageBase getFromRS(ResultSet rs) throws SQLException, BGException {
        SmartHousePackageBase basePackage = new SmartHousePackageBase();
        basePackage.setId(rs.getInt("id"));
        basePackage.setTitle(rs.getString("title"));
        basePackage.setPeriod(new Period((Date)rs.getDate("date_from"), (Date)rs.getDate("date_to")));
        String optionNames = rs.getString("option_names");
        basePackage.setOptionNames(optionNames == null ? "[]" : optionNames);
        basePackage.setComment(rs.getString("comment"));
        basePackage.setDurationValue(rs.getInt("duration_value"));
        basePackage.setDurationUnitCode(rs.getInt("duration_unit_code"));
        return basePackage;
    }

    public void update(SmartHousePackageBase packageBase) throws BGException {
        super.update((Object)packageBase);
    }

    protected void updateImpl(SmartHousePackageBase packageBase) throws BGException, SQLException {
        if (packageBase == null) {
            throw new BGException("basePackage is null");
        }
        boolean update = packageBase.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, date_from=?, date_to=?, comment=?, duration_value=?, duration_unit_code=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            ps.setString(parameterIndex++, packageBase.getTitle());
            Period period = packageBase.getPeriod();
            ps.setDate(parameterIndex++, period == null ? null : TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(parameterIndex++, period == null ? null : TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            ps.setString(parameterIndex++, packageBase.getComment());
            ps.setInt(parameterIndex++, packageBase.getDurationValue());
            ps.setInt(parameterIndex++, packageBase.getDurationUnitCode());
            if (update) {
                ps.setInt(parameterIndex++, packageBase.getId());
            }
            ps.executeUpdate();
        }
    }

    public void updateOptions(int packageBaseId, String optionNames) throws BGException {
        String query = "UPDATE " + this.tableName + " SET option_names=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            ps.setString(parameterIndex++, optionNames);
            ps.setInt(parameterIndex++, packageBaseId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public SmartHousePackageBase get(String title) throws BGException {
        return null;
    }

    public List<SmartHousePackageBase> list() throws BGException {
        ArrayList<SmartHousePackageBase> list = new ArrayList<SmartHousePackageBase>();
        String query = "SELECT * FROM " + this.tableName + " ORDER BY `title`";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            ResultSet resultSet = psSelect.executeQuery();
            while (resultSet.next()) {
                list.add(this.getFromRS(resultSet));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
        return list;
    }
}

