/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.softline.common.bean.Product;
import ru.bitel.bgbilling.modules.softline.common.bean.SubscriptionPeriodType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ProductDao
extends AbstractIdDao<Product> {
    public ProductDao(Connection con, int moduleId) {
        this(con, moduleId, "softline_product");
    }

    private ProductDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    protected Product getFromRS(ResultSet rs) throws SQLException, BGException {
        Product product = new Product();
        product.setId(rs.getInt("id"));
        product.setTitle(rs.getString("title"));
        product.setDescription(rs.getString("description"));
        product.setSoftLineCode(rs.getString("softLineCode"));
        product.setPrice(rs.getBigDecimal("price"));
        product.setServiceId(rs.getInt("serviceId"));
        product.setPeriodType(SubscriptionPeriodType.valueOf((int)rs.getInt("periodType")));
        product.setAmountOfDays(rs.getInt("periodCount"));
        product.setProductCategoryId(rs.getInt("product_category_id"));
        return product;
    }

    protected void updateImpl(Product product) throws BGException, SQLException {
        String query = product.getId() > 0 ? "UPDATE " + this.tableName + " SET title=?, description=?, softLineCode=?, price=?, serviceId=?, periodType=?, periodCount=?, product_category_id=? WHERE id=?" : "INSERT INTO " + this.tableName + " (title, description, softLineCode, price, serviceId, periodType, periodCount, product_category_id) VALUES (?,?,?,?,?,?,?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, product.getTitle());
            ps.setString(index++, product.getDescription());
            ps.setString(index++, product.getSoftLineCode());
            ps.setBigDecimal(index++, product.getPrice());
            ps.setInt(index++, product.getServiceId());
            ps.setInt(index++, product.getPeriodType().getCode());
            ps.setInt(index++, product.getAmountOfDays());
            ps.setInt(index++, product.getProductCategoryId());
            if (product.getId() > 0) {
                ps.setInt(index, product.getId());
            }
            ps.executeUpdate();
        }
    }

    public List<Product> getProducts(SearchResult<Product> searchResult) throws BGException {
        List result = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName;
        if (page != null) {
            query = query + page.sqlLimit();
        }
        try (Statement statement = this.con.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            while (resultSet.next()) {
                result.add(this.getFromRS(resultSet));
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<Product> getProductsOfCategory(int productCategoryId) throws BGException {
        ArrayList<Product> result = new ArrayList<Product>();
        String query = "SELECT * FROM " + this.tableName + " WHERE product_category_id=" + productCategoryId;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

