/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.service;

import bitel.billing.server.util.MailMsg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import net.sf.jasperreports.engine.util.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.softline.common.SoftLineUtils;
import ru.bitel.bgbilling.modules.softline.common.bean.Product;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.bean.SubscriptionSuspendReason;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService;
import ru.bitel.bgbilling.modules.softline.server.bean.ErrorCodes;
import ru.bitel.bgbilling.modules.softline.server.bean.ProductDao;
import ru.bitel.bgbilling.modules.softline.server.bean.SoftLineSubscriptionDao;
import ru.bitel.bgbilling.modules.softline.server.bean.SoftLineURL;
import ru.bitel.bgbilling.modules.softline.server.bean.SubscriptionHistoryDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService")
public class SoftLineSubscriptionServiceImpl
extends AbstractService
implements SoftLineSubscriptionService {
    private static final Logger logger = LogManager.getLogger();
    private SoftLineSubscriptionDao softLineSubscriptionDao;
    private ProductDao productDao;

    @PostConstruct
    public void init() {
        this.softLineSubscriptionDao = new SoftLineSubscriptionDao(this.getConnection(), this.moduleId);
        this.productDao = new ProductDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<SoftLineSubscription> searchSubscriptions(Page page, Period period, int contractId, int subscriptionId, SubscriptionStatus status, int productId) throws BGException {
        SearchResult searchResult = new SearchResult();
        if (page != null) {
            searchResult.setPage(page);
        }
        if (period != null) {
            searchResult.setPeriod(period);
        }
        this.softLineSubscriptionDao.searchSubscriptions((SearchResult<SoftLineSubscription>)searchResult, contractId, subscriptionId, status, productId);
        return searchResult;
    }

    public void activateSubscription(SoftLineSubscription subscription) throws BGException {
        int productId = subscription.getProductId();
        int contractId = subscription.getContractId();
        Product product = (Product)this.productDao.get(productId);
        if (product == null) {
            throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        if (!SoftLineUtils.checkActivation((Connection)this.getConnection(), (SoftLineSubscription)subscription, (Product)product)) {
            throw new BGException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
        }
        try {
            HttpURLConnection connection = this.getURLConnection(SoftLineURL.ACTIVATE, this.getActivateHeader(contractId, product.getSoftLineCode()));
            String response = this.getResponse(connection);
            JSONObject responseJson = new JSONObject(response);
            int errorCode = responseJson.getInt("code");
            if (errorCode == 0) {
                this.softLineSubscriptionDao.update(subscription);
                SoftLineUtils.addContractAccount((Connection)this.getConnection(), (int)this.moduleId, (SoftLineSubscription)subscription, (Date)new Date());
                this.insertDownloadData(subscription);
            } else {
                String errorMessage = ErrorCodes.getMessage(errorCode);
                if (Utils.isBlankString((String)errorMessage)) {
                    errorMessage = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
                }
                this.processException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043e\u0442\u0432\u0435\u0442\u0435 \u043e\u0442 SoftLine \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + ". \u041e\u0448\u0438\u0431\u043a\u0430: " + errorMessage + ". \u0422\u0435\u043a\u0441\u0442 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043e\u0442\u0432\u0435\u0442\u0435 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + responseJson.get("message"), null);
            }
        }
        catch (IOException e) {
            this.processException(e.getMessage(), e);
        }
    }

    private String getActivateHeader(int contractId, String softLineCode) throws BGException {
        return "?userId=" + contractId + "&productCode=" + softLineCode + "&sign=" + this.getSignString(softLineCode, String.valueOf(contractId));
    }

    public void insertDownloadData(SoftLineSubscription subscription) throws BGException {
        if (subscription.getStatus() != SubscriptionStatus.ACTIVE.getCode()) {
            throw new BGMessageException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.");
        }
        Product product = (Product)this.productDao.get(subscription.getProductId());
        if (product == null) {
            throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        try {
            HttpURLConnection connection = this.getURLConnection(SoftLineURL.GET_SHIPPING_DATA, this.getHeaderShippingData(String.valueOf(subscription.getContractId()), product.getSoftLineCode()));
            String response = this.getResponse(connection);
            JSONObject responseJson = new JSONObject(response);
            int responseCode = responseJson.getInt("code");
            if (responseCode != 0) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0438\u0441\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u0432\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438. \u041a\u043e\u0434 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 SoftLine: " + responseCode + " \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: " + ErrorCodes.getMessage(responseCode));
            }
            subscription.setDownloadData(responseJson.toString());
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void subscriptionPause(SoftLineSubscription subscription, SubscriptionSuspendReason reason) throws BGException {
        Product product = (Product)this.productDao.get(subscription.getProductId());
        if (product == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
        }
        try {
            String header = this.getPauseHeader(subscription.getContractId(), product.getSoftLineCode(), reason == null ? SubscriptionSuspendReason.fin_block : reason);
            HttpURLConnection connection = this.getURLConnection(SoftLineURL.PAUSE, header);
            JSONObject response = new JSONObject(this.getResponse(connection));
            int errorCode = response.getInt("code");
            if (errorCode == 0 || errorCode == -6) {
                if (this.checkSuspendSubscription(subscription)) {
                    subscription.setStatus(SubscriptionStatus.SUSPEND.getCode());
                    subscription.setSuspendReason(reason);
                    subscription.setEndDate(new Date());
                    this.softLineSubscriptionDao.update(subscription);
                }
            } else {
                this.processException(ErrorCodes.getMessage(errorCode), null);
            }
        }
        catch (IOException e) {
            this.processException(e.getMessage(), e);
        }
    }

    private boolean checkSuspendSubscription(SoftLineSubscription subscription) throws BGException {
        try {
            HttpURLConnection connection = this.getURLConnection(SoftLineURL.GET_ACCOUNT_INFO, this.getAccountInfoHeader(subscription.getContractId()));
            JSONObject response = new JSONObject(this.getResponse(connection));
            int errorCode = response.getInt("code");
            if (errorCode == 0) {
                JSONArray subscriptions = response.getJSONArray("subscriptions");
                if (subscriptions == null) {
                    return false;
                }
                ProductDao productDao = new ProductDao(this.getConnection(), this.moduleId);
                Product product = (Product)productDao.get(subscription.getProductId());
                for (int x = 0; x < subscriptions.length(); ++x) {
                    String status;
                    JSONObject sub = subscriptions.getJSONObject(x);
                    if (!sub.getString("productCode").equals(product.getSoftLineCode()) || !(status = sub.getString("status")).equals("suspend")) continue;
                    return true;
                }
            } else {
                this.processException(ErrorCodes.getMessage(errorCode), null);
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            throw new BGException((Throwable)ex);
        }
        return false;
    }

    private String getAccountInfoHeader(int contractId) throws BGException {
        return "?userId=" + contractId + "&sign=" + this.getSignString(String.valueOf(contractId));
    }

    private String getPauseHeader(int contractId, String productCode, SubscriptionSuspendReason reason) throws BGException {
        return "?userId=" + contractId + "&productCode=" + productCode + "&reason=" + reason + "&sign=" + this.getSignString(productCode, reason.toString(), String.valueOf(contractId));
    }

    public void deleteSubscription(SoftLineSubscription subscription, boolean cancelActiveSubscription) throws BGException {
        if (cancelActiveSubscription && subscription.getStatus() == SubscriptionStatus.ACTIVE.getCode()) {
            this.subscriptionPause(subscription, SubscriptionSuspendReason.fin_block);
        }
        SoftLineSubscription actual = (SoftLineSubscription)this.softLineSubscriptionDao.get(subscription.getId());
        if (cancelActiveSubscription && actual.getStatus() == SubscriptionStatus.ACTIVE.getCode()) {
            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443. \u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0431\u044b\u043b\u043e \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u043e");
        }
        SubscriptionHistoryDao historyDao = new SubscriptionHistoryDao(this.getConnection(), this.moduleId);
        historyDao.deleteHistoryOfSubscription(subscription.getId());
        this.softLineSubscriptionDao.delete(subscription.getId());
    }

    public void updateSubscription(SoftLineSubscription actualSubscription) throws BGException {
        int subsId = actualSubscription.getId();
        if (subsId > 0) {
            SoftLineSubscription oldSubs = (SoftLineSubscription)this.softLineSubscriptionDao.get(subsId);
            if (oldSubs.getStatus() != actualSubscription.getStatus()) {
                switch (actualSubscription.getStatus()) {
                    case 0: {
                        Product product = (Product)this.productDao.get(actualSubscription.getProductId());
                        if (!SoftLineUtils.checkActivation((Connection)this.getConnection(), (SoftLineSubscription)actualSubscription, (Product)product)) {
                            throw new BGMessageException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443. \u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432");
                        }
                        this.activateSubscription(actualSubscription);
                        break;
                    }
                    case 1: {
                        this.subscriptionPause(actualSubscription, SubscriptionSuspendReason.user_refuse);
                    }
                }
            }
            this.softLineSubscriptionDao.update(actualSubscription);
        } else if (actualSubscription.getStatus() == SubscriptionStatus.ACTIVE.getCode()) {
            this.activateSubscription(actualSubscription);
        } else {
            this.softLineSubscriptionDao.update(actualSubscription);
        }
    }

    public void checkStatusSoftLine() throws BGException {
        try {
            HttpURLConnection connection = this.getURLConnection(SoftLineURL.CHECK_SYSTEM, "");
            JSONObject responseJson = new JSONObject(this.getResponse(connection));
            int responseCode = connection.getResponseCode();
            if (responseCode != 200 && !responseJson.get("status").equals("0")) {
                throw new BGMessageException("\u041d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b SoftLine \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b, \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430");
            }
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    private String getHeaderShippingData(String contractId, String softLineCode) throws BGException {
        return "?userId=" + contractId + "&productCode=" + softLineCode + "&sign=" + this.getSignString(softLineCode, contractId);
    }

    private HttpURLConnection getURLConnection(SoftLineURL method, String header) throws IOException, BGException {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        boolean isTestWork = moduleSetup.getBoolean("testWork", false);
        String softLineURL = moduleSetup.get("URL");
        if (!isTestWork && Utils.isBlankString((String)softLineURL)) {
            throw new BGException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0441\u044b\u043b\u043a\u0430 \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u0441 SoftLine!");
        }
        String body = method.getMethod() + header;
        URL url = new URL(isTestWork ? SoftLineURL.TEST_URL.getMethod() + body : softLineURL + body);
        if (logger.isDebugEnabled()) {
            logger.debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u043a SoftLine: " + url);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        return connection;
    }

    private String getResponse(HttpURLConnection connection) throws IOException {
        StringBuilder resultJson = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                resultJson.append(line);
            }
        }
        return resultJson.toString();
    }

    private String getSignString(String ... values) throws BGException {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        String secret = moduleSetup.get("secret");
        if (Utils.isBlankString((String)secret)) {
            throw new BGMessageException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0430 \u043c\u043e\u0434\u0443\u043b\u044f");
        }
        StringBuilder result = new StringBuilder();
        for (String value : values) {
            result.append(value);
            result.append(",");
        }
        result.append(secret);
        return DigestUtils.instance().md5(result.toString()).toString();
    }

    public void sendDownloadDataOnUserEmail(SoftLineSubscription subscription, String userEmail) throws BGException {
        if (subscription.getDownloadData() == null) {
            this.insertDownloadData(subscription);
        }
        ModuleSetup setup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        String headerText = setup.get("softline.email.header");
        String message = setup.get("softline.email.message");
        new MailMsg((Preferences)this.getSetup()).sendMessage(userEmail, Utils.isBlankString((String)headerText) ? "\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438" : headerText, this.getEmailMessage(subscription, message));
    }

    private String getEmailMessage(SoftLineSubscription subscription, String message) {
        Pair<String, String> pair;
        Map<String, String> distributionsList;
        StringBuilder mailBody = new StringBuilder();
        String guideLink = this.getGuideLink(subscription.getDownloadData());
        if (Utils.notBlankString((String)guideLink)) {
            mailBody.append("\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044f \u043f\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435:\t").append(this.getGuideLink(subscription.getDownloadData())).append("\n");
        }
        if ((distributionsList = this.getDistributionsList(subscription.getDownloadData())).size() > 0) {
            mailBody.append("\n\u0414\u0438\u0441\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u0432\u044b \u0434\u043b\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438:\n");
            distributionsList.forEach((key, value) -> mailBody.append((String)key).append("\t").append((String)value).append("\n"));
        }
        if ((pair = this.getInstallKey(subscription.getDownloadData())) != null) {
            mailBody.append("\n\u041a\u043b\u044e\u0447:\t");
            mailBody.append((String)pair.getSecond());
        }
        if (Utils.notBlankString((String)message)) {
            mailBody.append("\n\n\t").append(message);
        }
        return mailBody.toString();
    }

    public void recalculate(int contractId, Calendar month) throws BGException {
        throw new UnsupportedOperationException("\u041f\u043e\u043a\u0430 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e");
    }

    private void processException(String errorMessage, Exception exception) throws BGException {
        String exceptionMessage = exception == null ? "" : exception.getMessage();
        logger.error(errorMessage + " " + exceptionMessage);
        if (exception == null) {
            throw new BGException(errorMessage);
        }
        throw new BGException((Throwable)exception);
    }

    public String getGuideLink(String downloadData) {
        if (Utils.notBlankString((String)downloadData)) {
            JSONObject downloadDataJSON = new JSONObject(downloadData);
            JSONObject link = (JSONObject)downloadDataJSON.get("guideList");
            return link.getString("\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044f \u043f\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435");
        }
        return "";
    }

    public Map<String, String> getDistributionsList(String downloadData) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (Utils.notBlankString((String)downloadData)) {
            JSONObject downloadDataJSON = new JSONObject(downloadData);
            JSONArray distrList = downloadDataJSON.getJSONArray("distrList");
            for (int x = 0; x < distrList.length(); ++x) {
                JSONObject entry = distrList.getJSONObject(x);
                result.put(entry.getString("name"), entry.getString("value"));
            }
        }
        return result;
    }

    public Pair<String, String> getInstallKey(String downloadData) {
        JSONObject downloadDataJSON;
        int embeddedKey;
        Pair result = null;
        if (Utils.notBlankString((String)downloadData) && (embeddedKey = (downloadDataJSON = new JSONObject(downloadData)).getInt("embeddedKey")) == 0) {
            result = new Pair();
            JSONArray array = downloadDataJSON.getJSONArray("keyList");
            JSONObject json = array.getJSONObject(0);
            result.setFirst((Object)json.optString("name"));
            result.setSecond((Object)json.optString("value"));
        }
        return result;
    }
}

