/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.task;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.softline.common.SoftLineUtils;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService;

public class SubscriptionSuspendDailyTask
extends TaskBase {
    private SoftLineSubscriptionService subscriptionService;
    private int moduleId;

    protected boolean initTask() {
        this.moduleId = this.getModuleId();
        ServerContext serverContext = (ServerContext)ServerContext.get();
        try {
            this.subscriptionService = (SoftLineSubscriptionService)serverContext.getService(SoftLineSubscriptionService.class, this.moduleId);
        }
        catch (BGException e) {
            this.log.error(e.getMessage());
        }
        return true;
    }

    protected void executeTask() {
        for (SoftLineSubscription subscription : this.getActiveSubscriptions()) {
            if (!SoftLineUtils.checkTodayDate((Date)subscription.getEndDate())) continue;
            try {
                this.subscriptionService.subscriptionPause(subscription, subscription.getSuspendReason());
            }
            catch (BGException e) {
                this.log.error(e.getMessage());
            }
        }
    }

    private List<SoftLineSubscription> getActiveSubscriptions() {
        try {
            return this.subscriptionService.searchSubscriptions(null, null, -1, -1, SubscriptionStatus.ACTIVE, -1).getList();
        }
        catch (BGException e) {
            this.log.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    public String getDescription() {
        return null;
    }
}

