/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.client;

import bitel.billing.module.common.BGControlPanelMonth;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.softline.client.SoftLineSubscriptionPanel;
import ru.bitel.bgbilling.modules.softline.common.SoftLineUtils;
import ru.bitel.bgbilling.modules.softline.common.bean.Product;
import ru.bitel.bgbilling.modules.softline.common.bean.ProductCategory;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.bean.SubscriptionSuspendReason;
import ru.bitel.bgbilling.modules.softline.common.service.ProductService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class SoftLineSubscriptionContractPanel
extends SoftLineSubscriptionPanel {
    private ProductService productService;
    private List<Product> productList = new ArrayList<Product>();
    private SubscriptionEditor editor;
    private BGControlPanelMonth monthPanel = new BGControlPanelMonth();

    SoftLineSubscriptionContractPanel() throws BGException {
        this.tableModel = new SoftLineSubscriptionTableModel(SoftLineSubscriptionContractPanel.class.getName());
        this.productList.addAll(this.getProductService().getProducts(null).getList());
    }

    @Override
    protected void jbInit() throws Exception {
        super.jbInit();
        BGButton recalculate = new BGButton("\u041f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u0430\u0442\u044c");
        recalculate.addActionListener(e -> this.recalculate());
        final JPopupMenu menu = new JPopupMenu();
        final JMenuItem changeStatus = new JMenuItem();
        final JMenuItem sendSubscriptionData = new JMenuItem("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043e \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 email");
        sendSubscriptionData.addActionListener(event -> this.showEmailSenderDialog());
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SoftLineSubscription selected = (SoftLineSubscription)SoftLineSubscriptionContractPanel.this.tableModel.getSelectedRow();
                if (e.getButton() == 3 && selected != null) {
                    if (selected.getStatus() == SubscriptionStatus.ACTIVE.getCode()) {
                        changeStatus.setText("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
                    } else {
                        changeStatus.setText("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
                    }
                    if (selected.getStatus() == SubscriptionStatus.ACTIVE.getCode()) {
                        menu.add(sendSubscriptionData);
                    }
                    menu.add(changeStatus);
                    menu.show((Component)SoftLineSubscriptionContractPanel.this.table, e.getX(), e.getY());
                }
            }
        });
        changeStatus.addActionListener(event -> {
            SubscriptionStatus newStatus;
            String newStatusDescription;
            try {
                this.getService().checkStatusSoftLine();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((String)ex.getMessage());
            }
            SoftLineSubscription subscription = (SoftLineSubscription)this.tableModel.getSelectedRow();
            if (subscription.getStatus() == SubscriptionStatus.ACTIVE.getCode()) {
                newStatusDescription = SubscriptionStatus.SUSPEND.getDescription();
                newStatus = SubscriptionStatus.SUSPEND;
            } else {
                newStatusDescription = SubscriptionStatus.ACTIVE.getDescription();
                newStatus = SubscriptionStatus.ACTIVE;
            }
            if (ClientUtils.confirm((String)("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 " + newStatusDescription + " ?"), (String)"\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430")) {
                subscription.setStatus(newStatus.getCode());
                try {
                    this.getService().updateSubscription(subscription);
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((String)ex.getMessage());
                }
                this.performAction("refresh");
            }
        });
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) {
                try {
                    SoftLineSubscriptionContractPanel.this.tableModel.setData(SoftLineSubscriptionContractPanel.this.getService().searchSubscriptions(null, null, ((ClientContext)SoftLineSubscriptionContractPanel.this.getContext()).getContractId(), -1, null, -1).getList());
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((String)ex.getMessage());
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SoftLineSubscriptionContractPanel.this.showEditorDialog();
            }
        };
    }

    private void showEditorDialog() {
        this.editor = new SubscriptionEditor();
        BGOptionPane optionPane = new BGOptionPane((Object)this.editor, "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443");
        JDialog editorDialog = optionPane.getDialog();
        editorDialog.setModal(true);
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            try {
                this.editor.save(((ClientContext)this.getContext()).getContractId());
                editorDialog.dispose();
            }
            catch (BGException bGException) {
                // empty catch block
            }
        });
        editorDialog.setVisible(true);
    }

    private void showEmailSenderDialog() {
        JPanel panel = new JPanel(new GridBagLayout());
        JTextField email = new JTextField();
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        panel.add((Component)new JLabel("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 email"), constraints);
        panel.add((Component)email, constraints);
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0430 email");
        JDialog dialog = optionPane.getDialog();
        dialog.setModal(true);
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            try {
                this.getService().sendDownloadDataOnUserEmail((SoftLineSubscription)this.tableModel.getSelectedRow(), email.getText());
                dialog.dispose();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((String)ex.getMessage());
            }
        });
        dialog.setVisible(true);
    }

    private void recalculate() {
        LocalDate now = LocalDate.now();
        LocalDate selectedMonth = this.monthPanel.getLocalDate();
        if (selectedMonth != null && selectedMonth.isAfter(now)) {
            ClientUtils.showErrorMessageDialog((String)"\u041c\u0435\u0441\u044f\u0446 \u043f\u0435\u0440\u0435\u0440\u0430\u0441\u0447\u0451\u0442\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u044c\u0448\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u044f\u0446\u0430");
            return;
        }
        try {
            this.getService().recalculate(((ClientContext)this.getContext()).getContractId(), TimeUtils.convertLocalDateTimeToCalendar((LocalDateTime)selectedMonth.atStartOfDay()));
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((String)e.getMessage());
        }
        BGClientBase.getFrame().getTabbedPane().repaint();
    }

    private ProductService getProductService() {
        if (this.productService == null) {
            this.productService = (ProductService)((ClientContext)this.getContext()).getPort(ProductService.class);
        }
        return this.productService;
    }

    private class SoftLineSubscriptionTableModel
    extends BGTableModel<SoftLineSubscription> {
        SoftLineSubscriptionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430", -1, 200, -1, "startDate", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", -1, 200, -1, "endDate", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430", -1, 200, -1, "lastModifyDate", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", -1, 300, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 200, -1, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438", -1, 350, -1, "suspendReason", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(SoftLineSubscription sub, int column) throws BGException {
            switch (column) {
                case 1: {
                    return TimeUtils.formatFullDate((Date)sub.getStartDate());
                }
                case 2: {
                    return TimeUtils.formatFullDate((Date)sub.getEndDate());
                }
                case 3: {
                    return TimeUtils.formatFullDate((Date)sub.getLastModifyDate());
                }
                case 4: {
                    return SoftLineSubscriptionContractPanel.this.productList.stream().filter(p -> p.getId() == sub.getProductId()).findFirst().get().getTitle();
                }
                case 5: {
                    return SubscriptionStatus.getDescription((int)sub.getStatus());
                }
                case 6: {
                    return sub.getSuspendReason() == null ? "" : sub.getSuspendReason().getDescription();
                }
            }
            return super.getValue((Object)sub, column);
        }
    }

    class SubscriptionEditor
    extends BGUPanel {
        private BGUComboBox<ProductCategory> categories = new BGUComboBox();
        private BGUComboBox<Product> products = new BGUComboBox();
        private BGCalendarButton calendarButton = new BGCalendarButton();
        private JCheckBox checkBox = new JCheckBox("\u0421\u0447\u0438\u0442\u0430\u0442\u044c \u0434\u0430\u0442\u043e\u0439 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0434\u0430\u0442\u0443 \u0435\u0451 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f");
        private BGUComboBox<SubscriptionStatus> status = new BGUComboBox();
        private SoftLineSubscription current;
        AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) {
                SubscriptionEditor.this.current = new SoftLineSubscription();
                SubscriptionEditor.this.performActionOpen();
            }
        };

        SubscriptionEditor() {
        }

        protected void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
            List categoryList = SoftLineSubscriptionContractPanel.this.getProductService().getProductCategories(null).getList();
            categoryList.add(new ProductCategory(0, "\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u0431\u0435\u0437 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438"));
            this.categories.setData(categoryList);
            int firstCategoryId = categoryList.size() > 0 ? ((ProductCategory)categoryList.get(0)).getId() : 0;
            this.products.setData(SoftLineSubscriptionContractPanel.this.getProductService().getProductsOfCategory(firstCategoryId));
            this.categories.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ProductCategory selectedCategory = (ProductCategory)SubscriptionEditor.this.categories.getSelectedItem();
                        try {
                            if (selectedCategory != null) {
                                SubscriptionEditor.this.products.setData(SoftLineSubscriptionContractPanel.this.productService.getProductsOfCategory(selectedCategory.getId()));
                            }
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                }
            });
            this.status.setData(Arrays.asList(SubscriptionStatus.values()));
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0);
            this.add(new JLabel("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f"), constraints);
            this.add((Component)this.categories, constraints);
            this.add(new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442"), constraints);
            this.add((Component)this.products, constraints);
            this.add(new JLabel("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438"), constraints);
            this.add((Component)this.calendarButton, constraints);
            this.add(this.checkBox, constraints);
            this.add(new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438"), constraints);
            this.add((Component)this.status, constraints);
        }

        public void performActionOpen() {
            this.products.setSelectedItem((Object)SoftLineSubscriptionContractPanel.this.productList.stream().anyMatch(product -> product.getId() == this.current.getProductId()));
            this.status.setSelectedItem((Object)SubscriptionStatus.valueOf((int)this.current.getStatus()));
            this.calendarButton.setLocalDate(TimeUtils.convertDateToLocalDate((Date)this.current.getStartDate()));
            super.performActionOpen();
        }

        private void save(int contractId) throws BGException {
            Product selectedProduct;
            if (this.current == null) {
                this.current = new SoftLineSubscription();
            }
            if ((selectedProduct = (Product)this.products.getSelectedItem()) == null) {
                BGToolTip.showErrorMessage(this.products, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
                throw new BGException();
            }
            Date dateFrom = TimeUtils.convertLocalDateToDate((LocalDate)this.calendarButton.getLocalDate());
            if (dateFrom == null && !this.checkBox.isSelected()) {
                BGToolTip.showErrorMessage((JComponent)this.calendarButton, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
                throw new BGException();
            }
            this.current.setContractId(contractId);
            this.current.setProductId(selectedProduct.getId());
            if (this.checkBox.isSelected()) {
                this.current.setStartDate(new Date());
            } else {
                this.current.setStartDate(dateFrom);
            }
            this.current.setLastModifyDate(new Date());
            this.current.setStatus(((SubscriptionStatus)this.status.getSelectedItem()).getCode());
            if (this.current.getStatus() == SubscriptionStatus.SUSPEND.getCode()) {
                this.current.setSuspendReason(SubscriptionSuspendReason.user_refuse);
            }
            SoftLineUtils.setEndDate((SoftLineSubscription)this.current, (Product)selectedProduct);
            try {
                SoftLineSubscriptionContractPanel.this.getService().updateSubscription(this.current);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((String)e.getMessage());
            }
            this.setVisible(false);
            SoftLineSubscriptionContractPanel.this.performAction("refresh");
        }
    }
}

