/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.subscription.common.bean.RegistrationPeriod;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.PeriodWithTime;

public class SubscriptionPeriodDao
extends AbstractIdDao<RegistrationPeriod> {
    protected final int userId;

    public SubscriptionPeriodDao(Connection con, int moduleId, int userId) {
        super(con, moduleId, "subscription_period");
        this.userId = userId;
    }

    protected RegistrationPeriod getFromRS(ResultSet rs) throws SQLException, BGException {
        RegistrationPeriod result = new RegistrationPeriod();
        result.setId(rs.getInt("id"));
        result.setSubscriptionId(rs.getInt("subscription_id"));
        result.setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
        result.setDateCreate((Date)rs.getTimestamp("date_create"));
        result.setWhoCreate(rs.getInt("who_create"));
        return result;
    }

    protected void updateImpl(RegistrationPeriod registrationPeriod) throws BGException, SQLException {
        if (registrationPeriod == null) {
            throw new NullPointerException("registrationPeriod == null");
        }
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append(this.tableName);
        query.append(" SET ");
        query.append("subscription_id=?, date_from=?, date_to=?, date_create=?, who_create=?");
        int index = 1;
        PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
        ps.setInt(index++, registrationPeriod.getSubscriptionId());
        PeriodWithTime period = registrationPeriod.getPeriod();
        ps.setTimestamp(index++, period != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()) : null);
        ps.setTimestamp(index++, period != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateTo()) : null);
        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)registrationPeriod.getDateCreate()));
        ps.setInt(index++, registrationPeriod.getWhoCreate());
        ps.executeUpdate();
        registrationPeriod.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        ps.close();
    }

    public List<RegistrationPeriod> list(int subscriptionId) throws BGException {
        return super.list("subscription_id=?", "id", new Object[]{subscriptionId});
    }

    public Map<Integer, RegistrationPeriod> map(List<Integer> registrationPeriodIds) throws BGException {
        HashMap<Integer, RegistrationPeriod> result = new HashMap<Integer, RegistrationPeriod>();
        if (registrationPeriodIds != null && !registrationPeriodIds.isEmpty()) {
            StringBuilder sb = new StringBuilder().append("SELECT ").append("*").append(" FROM ").append(this.tableName).append(" WHERE ").append("id").append(" IN ").append("(").append(Utils.toString(registrationPeriodIds)).append(")");
            try {
                PreparedStatement ps = this.con.prepareStatement(sb.toString());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    RegistrationPeriod registrationPeriod = this.getFromRS(rs);
                    result.put(registrationPeriod.getId(), registrationPeriod);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                this.processException(e);
            }
        }
        return result;
    }
}

