/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client;

import bitel.billing.module.common.BGDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.xml.ws.soap.SOAPFaultException;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceType;
import ru.bitel.bgbilling.modules.tv.common.service.TvDeviceService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.function.Async;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;

public class TvDevicePanel
extends DevicePanel<TvDevice, TvDeviceType> {
    AbstractBGUPanel.DefaultAction reloadAction;
    AbstractBGUPanel.MenuAction saReinit;
    AbstractBGUPanel.MenuAction manage;

    public TvDevicePanel(ClientContext ctx) {
        this(ctx, 1, null);
    }

    public TvDevicePanel(ClientContext ctx, int mode, ActionListener actionListener) {
        super(ctx, mode, actionListener);
        if (mode == 1) {
            this.manage = new AbstractBGUPanel.MenuAction("device.manage", "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443", ClientUtils.getIcon((String)"fugue/terminal-network")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    String operation;
                    TvDevice device = (TvDevice)TvDevicePanel.this.model.getSelectedRow();
                    if (device != null && device.getId() > 0 && Utils.notBlankString((String)(operation = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443?", "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443", 3)))) {
                        TvDevicePanel.this.executeCommand(device, operation);
                    }
                }
            };
        }
    }

    protected void initActions() {
        super.initActions();
        this.reloadAction = new AbstractBGUPanel.DefaultAction("tvReload", "\u041f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((TvDeviceService)((ClientContext)TvDevicePanel.this.getContext()).getPort(TvDeviceService.class)).deviceReload();
            }
        };
    }

    protected boolean needInterfacePanel() {
        return false;
    }

    protected void jbInit() {
        super.jbInit();
        if (this.mode == 1) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JButton((Action)this.reloadAction), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
            panel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(panel, "South");
        }
    }

    protected Class<TvDevice> getDeviceClass() {
        return TvDevice.class;
    }

    public TvDevice newDevice() {
        return new TvDevice();
    }

    public TvDeviceType newDeviceType(int id, String title) {
        return new TvDeviceType(id, title);
    }

    public TvDeviceService getWs() {
        return (TvDeviceService)((ClientContext)this.getContext()).getPort(TvDeviceService.class);
    }

    public TvDevice deviceSourceRoot() throws BGException {
        return null;
    }

    protected Class<TvDeviceType> getDeviceTypeClass() {
        return TvDeviceType.class;
    }

    protected TvDevice getLoadingStateRoot() {
        TvDevice result = new TvDevice();
        result.setId(-1);
        return result;
    }

    private static void browse(ClientContext context, String url) {
        try {
            ClientUtils.openBrowser((URI)new URI(url));
        }
        catch (Exception e) {
            context.processException((Throwable)e);
        }
    }

    private static void telnet(ClientContext context, String telnet) {
        try {
            int port = 21;
            int index = telnet.lastIndexOf(32);
            if (index > 0) {
                port = Utils.parseInt((String)telnet.substring(index + 1), (int)21);
                telnet = telnet.substring(0, index);
            }
            ClientUtils.openTelnet((String)telnet, (int)port);
        }
        catch (Exception e) {
            context.processException((Throwable)e);
        }
    }

    protected void executeCommand(TvDevice device, String operation) throws BGException {
        TvDevicePanel.executeCommand((ClientContext)this.getContext(), device.getId(), operation, 0, 0);
    }

    public static void executeCommand(ClientContext context, int deviceId, String operation, int accountId, int connectionId) throws BGException {
        JTextPane textArea = new JTextPane();
        textArea.setEditable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane(textArea), (boolean)true), "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout());
        panel.add((Component)bottomPanel, "South");
        BGButton button = new BGButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        bottomPanel.add((Component)button, "South");
        BGDialog dialog = new BGDialog();
        dialog.add((Component)panel);
        dialog.pack();
        dialog.setMinimumSize(new Dimension(500, 400));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode mode = device.getDisplayMode();
        int width = mode.getWidth();
        int height = mode.getHeight();
        dialog.setLocation(width > 0 ? width >>> 1 : 0, height > 0 ? height >>> 1 : 0);
        dialog.setLocationRelativeTo((Component)JOptionPane.getRootFrame());
        textArea.setText("\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430...");
        Async future = Async.of(() -> ((TvDeviceService)context.getPort(TvDeviceService.class)).deviceManage(deviceId, operation, accountId, connectionId, TimeUnit.MINUTES.toMillis(3L))).handle((result, ex) -> {
            SwingUtilities.invokeLater(() -> {
                if (ex != null) {
                    Throwable t = ex;
                    if (t instanceof CompletionException) {
                        t = t.getCause();
                    }
                    if (t instanceof SOAPFaultException && t.getCause() != null) {
                        t = t.getCause();
                    }
                    if (t instanceof BGRuntimeException) {
                        t = t.getCause();
                    }
                    if (t instanceof BGMessageException) {
                        textArea.setText(t.getMessage());
                    } else {
                        StringWriter writer = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(writer);
                        t.printStackTrace(printWriter);
                        textArea.setText(((Object)writer).toString());
                    }
                } else if (Utils.notBlankString((String)result)) {
                    if (result.startsWith("browse:")) {
                        String result2 = result.substring(7);
                        TvDevicePanel.browse(context, result2);
                        dialog.dispose();
                    } else if (result.startsWith("telnet:")) {
                        String result2 = result.substring(7);
                        TvDevicePanel.telnet(context, result2);
                        dialog.dispose();
                    } else {
                        if (result.startsWith("<html>")) {
                            textArea.setContentType("text/html");
                        }
                        textArea.setText((String)result);
                        if (!dialog.isShowing()) {
                            dialog.showDialog();
                        }
                    }
                }
            });
            return result;
        });
        button.addActionListener(a -> {
            dialog.dispose();
            if (!future.getFuture().isDone()) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u043e\u043a\u043d\u0430 \u043d\u0435 \u043e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 2);
            }
        });
        String result2 = null;
        try {
            result2 = (String)future.getFuture().get(5L, TimeUnit.SECONDS);
            if (Utils.notBlankString((String)result2) && !dialog.isShowing()) {
                dialog.showDialog();
            }
        }
        catch (TimeoutException e) {
            if (!dialog.isShowing()) {
                dialog.showDialog();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

