/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.access.om;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.ProductEntry;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.common.bean.TvChannelSpec;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.service.common.bean.ServiceSpec;

public abstract class AbstractOrderEvent {
    final transient TvAccess tvAccess;
    final int eventType;
    final int contractId;
    final int tvAccountId;
    final TvAccountRuntime tvAccountRuntime;
    final int deviceId;
    final Set<Integer> oldDeviceOptionIds;
    Set<Integer> newDeviceOptionIds;
    List<Future<?>> futures;
    final Event event;
    protected boolean filterByDepends;

    public AbstractOrderEvent(TvAccess tvAccess, Event event, int deviceId, TvAccountRuntime tvAccountRuntime, int eventType, int tvAccountId, TvAccountSpec tvAccountSpec, Set<Integer> oldDeviceOptionIds, Set<Integer> newDeviceOptionIds) {
        this.tvAccess = tvAccess;
        this.event = event;
        this.deviceId = deviceId;
        this.tvAccountRuntime = tvAccountRuntime;
        this.eventType = eventType;
        this.tvAccountId = tvAccountId;
        this.contractId = tvAccountRuntime.getContractRuntime().contractId;
        this.oldDeviceOptionIds = oldDeviceOptionIds != null ? oldDeviceOptionIds : Collections.emptySet();
        this.newDeviceOptionIds = newDeviceOptionIds != null ? newDeviceOptionIds : oldDeviceOptionIds;
    }

    public int getContractId() {
        return this.contractId;
    }

    public int getTvAccountId() {
        return this.tvAccountId;
    }

    public TvAccountRuntime getTvAccountRuntime() {
        return this.tvAccountRuntime;
    }

    @Deprecated
    public final List<ProductEntry> getFullProductEntryList(short newState) throws BGException {
        return this.getFullProductEntryListToEnable();
    }

    public abstract List<ProductEntry> getFullProductEntryListToEnable() throws BGException;

    protected abstract Map<Integer, ProductSpecRuntime> getFullProductSpecRuntimeMapToEnable() throws BGException;

    public Set<ProductSpecRuntime> getFullProductSpecRuntimeSetToEnable() throws BGException {
        HashSet<ProductSpecRuntime> result = new HashSet<ProductSpecRuntime>();
        Map<Integer, ProductSpecRuntime> newProductSpecRuntimeMap = this.getFullProductSpecRuntimeMapToEnable();
        for (Map.Entry<Integer, ProductSpecRuntime> e : newProductSpecRuntimeMap.entrySet()) {
            result.add(e.getValue());
        }
        return result;
    }

    public Set<ProductSpec> getFullProductSpecSetToEnable() throws BGException {
        HashSet<ProductSpec> result = new HashSet<ProductSpec>();
        Map<Integer, ProductSpecRuntime> newProductSpecRuntimeMap = this.getFullProductSpecRuntimeMapToEnable();
        for (Map.Entry<Integer, ProductSpecRuntime> e : newProductSpecRuntimeMap.entrySet()) {
            result.add(e.getValue().productSpec);
        }
        return result;
    }

    public Set<ServiceSpec> getFullServiceSpecSetToEnable() throws BGException {
        HashSet<ServiceSpec> result = new HashSet<ServiceSpec>();
        long millis = this.event.getTimestamp();
        Map<Integer, ProductSpecRuntime> newProductSpecRuntimeMap = this.getFullProductSpecRuntimeMapToEnable();
        for (Map.Entry<Integer, ProductSpecRuntime> e : newProductSpecRuntimeMap.entrySet()) {
            ProductSpecRuntime productSpecRuntime = e.getValue();
            List<ProductSpecRuntime.ServiceLinkRuntime> serviceLinkRuntimeList = productSpecRuntime.serviceLinkList.list(millis, millis);
            for (ProductSpecRuntime.ServiceLinkRuntime serviceLinkRuntime : serviceLinkRuntimeList) {
                result.add(serviceLinkRuntime.serviceSpecRuntime.getServiceSpec());
            }
        }
        return result;
    }

    public Set<ServiceSpecRuntime> getFullServiceSpecRuntimeSetToEnable() throws BGException {
        HashSet<ServiceSpecRuntime> result = new HashSet<ServiceSpecRuntime>();
        long millis = this.event.getTimestamp();
        Map<Integer, ProductSpecRuntime> newProductSpecRuntimeMap = this.getFullProductSpecRuntimeMapToEnable();
        for (Map.Entry<Integer, ProductSpecRuntime> e : newProductSpecRuntimeMap.entrySet()) {
            ProductSpecRuntime productSpecRuntime = e.getValue();
            List<ProductSpecRuntime.ServiceLinkRuntime> serviceLinkRuntimeList = productSpecRuntime.serviceLinkList.list(millis, millis);
            for (ProductSpecRuntime.ServiceLinkRuntime serviceLinkRuntime : serviceLinkRuntimeList) {
                result.add(serviceLinkRuntime.serviceSpecRuntime);
            }
        }
        return result;
    }

    public Set<TvChannelSpec> getFullTvChannelSpecSetToEnable() throws BGException {
        HashSet<TvChannelSpec> result = new HashSet<TvChannelSpec>();
        long millis = this.event.getTimestamp();
        Map<Integer, ProductSpecRuntime> newProductSpecRuntimeMap = this.getFullProductSpecRuntimeMapToEnable();
        for (Map.Entry<Integer, ProductSpecRuntime> e : newProductSpecRuntimeMap.entrySet()) {
            ProductSpecRuntime productSpecRuntime = e.getValue();
            List<ProductSpecRuntime.ServiceLinkRuntime> serviceLinkRuntimeList = productSpecRuntime.serviceLinkList.list(millis, millis);
            for (ProductSpecRuntime.ServiceLinkRuntime serviceLinkRuntime : serviceLinkRuntimeList) {
                List<ServiceSpecRuntime.TvChannelSpecRuntime> tvChannelSpecList = serviceLinkRuntime.serviceSpecRuntime.getTvChannelSpecList().list(millis, millis);
                for (ServiceSpecRuntime.TvChannelSpecRuntime tvChannelSpecRuntime : tvChannelSpecList) {
                    result.add(tvChannelSpecRuntime.getTvChannelSpec());
                }
            }
        }
        return result;
    }

    public boolean isOptionsModified() {
        return this.oldDeviceOptionIds != null && this.newDeviceOptionIds != null && !this.oldDeviceOptionIds.equals(this.newDeviceOptionIds);
    }

    public Set<Integer> getOldDeviceOptionIds() {
        return this.oldDeviceOptionIds;
    }

    public Set<Integer> getNewDeviceOptionIds() {
        return this.newDeviceOptionIds;
    }

    public Set<Integer> getDeviceOptionIdsToEnable() {
        HashSet<Integer> optionsToAdd = new HashSet<Integer>(this.newDeviceOptionIds);
        optionsToAdd.removeAll(this.oldDeviceOptionIds);
        return optionsToAdd;
    }

    public Set<Integer> getDeviceOptionIdsToDisable() {
        HashSet<Integer> optionsToRemove = new HashSet<Integer>(this.oldDeviceOptionIds);
        optionsToRemove.removeAll(this.newDeviceOptionIds);
        return optionsToRemove;
    }

    public void setNewDeviceOptionIds(Set<Integer> newDeviceOptionIds) {
        this.newDeviceOptionIds = newDeviceOptionIds;
    }

    public List<ProductSpec> getProductSpecList(Collection<Integer> productSpecIds) throws BGException {
        ArrayList<ProductSpec> result = new ArrayList<ProductSpec>();
        for (Integer productSpecId : productSpecIds) {
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)this.tvAccess.productSpecRuntimeMap.get(productSpecId);
            ProductSpec productSpec = productSpecRuntime.getProductSpec();
            result.add(productSpec);
        }
        return result;
    }

    public List<ProductSpecRuntime> getProductSpecRuntimeList(Collection<Integer> productSpecIds) throws BGException {
        ArrayList<ProductSpecRuntime> result = new ArrayList<ProductSpecRuntime>();
        for (Integer productSpecId : productSpecIds) {
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)this.tvAccess.productSpecRuntimeMap.get(productSpecId);
            result.add(productSpecRuntime);
        }
        return result;
    }

    public List<ProductSpec> getDeviceOptionProductSpecSetToEnable() throws BGException {
        return this.getProductSpecList(this.getDeviceOptionIdsToEnable());
    }

    public List<ProductSpec> getDeviceOptionProductSpecSetToDisable() throws BGException {
        return this.getProductSpecList(this.getDeviceOptionIdsToDisable());
    }

    public List<ProductSpec> getNewDeviceOptionProductSpecs() throws BGException {
        return this.getProductSpecList(this.getNewDeviceOptionIds());
    }

    public List<ProductSpec> getOldDeviceOptionProductSpecs() throws BGException {
        return this.getProductSpecList(this.getOldDeviceOptionIds());
    }

    public boolean isFilterByDepends() {
        return this.filterByDepends;
    }

    public void setFilterByDepends(boolean filterByDepends) {
        this.filterByDepends = filterByDepends;
    }

    protected final Map<Integer, ProductSpecRuntime> filterProductSpecByDepends(Map<Integer, ProductSpecRuntime> map) {
        HashMap<Integer, ProductSpecRuntime> result;
        boolean needCheck;
        do {
            needCheck = false;
            result = new HashMap<Integer, ProductSpecRuntime>(map);
            for (ProductSpecRuntime productSpecRuntime : map.values()) {
                ProductSpec productSpec = productSpecRuntime.getProductSpec();
                if (productSpec.getDepends() == null || productSpec.getDepends().size() <= 0 || !Collections.disjoint(productSpec.getDepends(), result.keySet()) || result.remove(productSpec.getId()) == null) continue;
                needCheck = true;
            }
            map = result;
        } while (needCheck);
        return result;
    }

    public static List<TvAccount> getTvAccountChildren(TvAccountRuntimeMap tvAccountRuntimeMap, int tvAccountId, long millis) {
        List<TvAccountRuntime> childrenAccountRuntimes;
        List<TvAccountRuntime> list = childrenAccountRuntimes = millis <= 0L ? tvAccountRuntimeMap.listChildren(tvAccountId) : tvAccountRuntimeMap.listChildren(tvAccountId, millis);
        if (childrenAccountRuntimes == null || childrenAccountRuntimes.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<TvAccount> childrenAccounts = new ArrayList<TvAccount>(childrenAccountRuntimes.size());
        for (TvAccountRuntime accountRuntime : childrenAccountRuntimes) {
            childrenAccounts.add(accountRuntime.getTvAccount());
        }
        return childrenAccounts;
    }
}

