/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.action.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;
import ru.bitel.oss.systems.order.product.common.service.ProductOrderService;

@WebAction(title="TV")
public class ActionProduct
extends AbstractAction {
    private final String moduleName = "tv";
    @Resource
    private TvAccountService tvAccountService;
    @Resource
    ProductService productService;
    @Resource
    ProductOrderService productOrderService;

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b")
    public void list() throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        HashMap<Integer, List> products = new HashMap<Integer, List>();
        HashMap<Integer, BigDecimal> productPriceMap = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, Boolean> activationByCustomerMap = new HashMap<Integer, Boolean>();
        HashMap<Integer, Boolean> deactivationByCustomerMap = new HashMap<Integer, Boolean>();
        HashMap<Integer, ProductSpecActivationMode> productSpecActivationModeMap = new HashMap<Integer, ProductSpecActivationMode>();
        for (TvAccount tvAccount : this.accounts()) {
            List productList = this.productService.productList(this.moduleId, this.contractId, tvAccount.getId(), false, null, null, calendar.getTime(), null, false, true);
            products.put(tvAccount.getId(), productList);
            List productOfferings = this.productOrderService.productOfferingList(Integer.valueOf(this.moduleId), this.contractId, tvAccount.getId(), -1, new Date(), false, true);
            block1: for (Product product : productList) {
                for (ProductOffering productOffering : productOfferings) {
                    if (product.getProductSpecId() != productOffering.getProductSpec().getId()) continue;
                    ProductSpec productSpec = productOffering.getProductSpec();
                    if (productSpec != null) {
                        activationByCustomerMap.put(product.getId(), productSpec.isActivationByCustomer());
                        deactivationByCustomerMap.put(product.getId(), productSpec.isDeactivationByCustomer());
                        for (ProductSpecActivationMode productSpecActivationMode : productSpec.getActivationModeList()) {
                            if (product.getActivationModeId() != productSpecActivationMode.getId()) continue;
                            productSpecActivationModeMap.put(product.getId(), productSpecActivationMode);
                            break;
                        }
                    }
                    for (ProductOfferingActivationMode productOfferingActivationMode : productOffering.getActivationModeList()) {
                        if (productOfferingActivationMode.getProductSpecActivationMode().getId() != product.getActivationModeId()) continue;
                        productPriceMap.put(product.getId(), productOfferingActivationMode.getPrice());
                        continue block1;
                    }
                    continue block1;
                }
            }
        }
        this.context.getRequest().setAttribute("tvAccountProducts", products);
        this.context.getRequest().setAttribute("productPriceMap", productPriceMap);
        this.context.getRequest().setAttribute("activationByCustomerMap", activationByCustomerMap);
        this.context.getRequest().setAttribute("deactivationByCustomerMap", deactivationByCustomerMap);
        this.context.getRequest().setAttribute("productSpecActivationModeMap", productSpecActivationModeMap);
        this.requestDispatcher("tv", "list");
    }

    @WebOperation(title="\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b")
    public void available() throws BGException {
        HashMap<Integer, List> productOfferings = new HashMap<Integer, List>();
        Date time = new Date();
        for (TvAccount tvAccount : this.accounts()) {
            productOfferings.put(tvAccount.getId(), this.productOrderService.productOfferingList(Integer.valueOf(this.moduleId), this.contractId, tvAccount.getId(), -1, time, true, true));
        }
        this.context.getRequest().setAttribute("productOfferings", productOfferings);
        this.requestDispatcher("tv", "available");
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f")
    public void history() throws BGException {
        List<TvAccount> tvAccountList = this.accounts();
        HashMap<Integer, List> products = new HashMap<Integer, List>();
        for (TvAccount tvAccount : tvAccountList) {
            products.put(tvAccount.getId(), this.productService.productList(this.moduleId, this.contractId, tvAccount.getId(), false, null, new Date(), null, null, false, false));
        }
        this.context.getRequest().setAttribute("tvAccountProducts", products);
        this.requestDispatcher("tv", "history");
    }

    public void activate() throws BGException {
        int tvAccountId = this.req.getInt("tvAccountId", -1);
        if (tvAccountId <= 0) {
            this.execute();
            return;
        }
        TvAccount tvAccount = this.tvAccountService.tvAccountGet(this.contractId, tvAccountId);
        if (tvAccount == null || tvAccount.getContractId() != this.contractId) {
            throw new BGMessageException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
        }
        this.setResultParam("tvAccountId", tvAccountId);
        int productSpecId = this.req.getInt("productSpecId", -1);
        int activationModeId = this.req.getInt("activationModeId", -1);
        if (productSpecId <= 0 || activationModeId <= 0) {
            Date time = new Date();
            List productOfferingList = this.productOrderService.productOfferingList(Integer.valueOf(this.moduleId), this.contractId, tvAccountId, -1, time, true, true);
            if (productSpecId > 0) {
                if (productOfferingList.size() == 0) {
                    productSpecId = 0;
                    activationModeId = 0;
                } else if (productSpecId <= 0) {
                    productSpecId = ((ProductOffering)productOfferingList.get(0)).getProductSpec().getId();
                }
                if (productSpecId > 0) {
                    for (ProductOffering productOffering : productOfferingList) {
                        if (productOffering.getProductSpec().getId() != productSpecId) continue;
                        this.setResultParam("activationModeList", productOffering.getActivationModeList());
                    }
                }
            }
            this.setResultParam("productSpecId", productSpecId);
            this.setResultParam("activationModeId", activationModeId);
            this.setResultParam("productOfferingList", productOfferingList);
        } else {
            Product product = new Product();
            product.setContractId(this.contractId);
            product.setAccountId(tvAccountId);
            product.setProductSpecId(productSpecId);
            product.setActivationModeId(activationModeId);
            product.setTimeFrom(new Date());
            product.setComment("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c");
            try {
                this.productOrderService.productActivate(product, null, true, true);
                this.context.getRequest().setAttribute("message", (Object)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d");
            }
            catch (BGException ex) {
                this.context.getRequest().setAttribute("message", (Object)("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d [" + ex.getLocalizedMessage() + "]"));
            }
            this.requestDispatcher("tv", "message");
        }
    }

    public void deactivate() throws BGException {
        Object message = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d";
        Product product = this.productService.productGet(this.contractId, this.req.getInt("tvPproductId", -1));
        if (product == null) {
            message = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d [#" + this.req.getInt("tvPproductId", -1) + "]";
        } else {
            try {
                this.productOrderService.productDeactivate(this.contractId, product.getId(), new Date(), true, true, false);
            }
            catch (Exception ex) {
                message = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d [" + ex.getLocalizedMessage() + "]";
            }
        }
        this.context.getRequest().setAttribute("message", message);
        this.requestDispatcher("tv", "message");
    }

    public void reactivate() throws BGException {
        Object message = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u0440\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d";
        Product product = this.productService.productGet(this.contractId, this.req.getInt("tvPproductId", -1));
        if (product == null) {
            message = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d [#" + this.req.getInt("tvPproductId", -1) + "]";
        } else {
            try {
                int productId = this.req.getInt("tvPproductId", -1);
                if (productId <= 0) {
                    return;
                }
                this.productOrderService.productReactivate(this.contractId, productId, true);
            }
            catch (Exception ex) {
                message = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u0440\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d <br>[" + ex.getLocalizedMessage() + "]";
            }
        }
        this.context.getRequest().setAttribute("message", message);
        this.requestDispatcher("tv", "message");
    }

    private List<TvAccount> accounts() throws BGException {
        TvAccount root = this.tvAccountService.tvAccountTree(this.contractId);
        ArrayList<TvAccount> list = root.getChildren();
        if (list == null) {
            list = new ArrayList<TvAccount>();
        }
        this.context.getRequest().setAttribute("tvAccountList", list);
        return list;
    }
}

