/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntime;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.util.AbstractPeriodItemSet;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;

public class ProductSpecRuntime {
    public final ProductSpec productSpec;
    public final Map<Integer, ProductSpecActivationMode> activationModeMap;
    public final ServiceLinkRuntimeList serviceLinkList;

    ProductSpecRuntime(ProductSpec productSpec, ServiceLinkRuntimeList serviceLinkList) {
        this.productSpec = productSpec;
        List activationModeList = productSpec.getActivationModeList();
        this.activationModeMap = activationModeList != null ? Id.newMap((List)activationModeList) : Collections.emptyMap();
        this.serviceLinkList = serviceLinkList;
    }

    public ProductSpec getProductSpec() {
        return this.productSpec;
    }

    public Map<Integer, ProductSpecActivationMode> getActivationModeMap() {
        return this.activationModeMap;
    }

    public ServiceLinkRuntimeList getServiceLinkList() {
        return this.serviceLinkList;
    }

    public static class ServiceLinkRuntimeList
    extends AbstractPeriodItemSet<ServiceLinkRuntime> {
        public ServiceLinkRuntimeList(List<ServiceLinkRuntime> entryList) {
            super(ServiceLinkRuntime.class, entryList);
        }

        public List<ServiceLinkRuntime> list(long date1, long date2) {
            if (((ServiceLinkRuntime[])this.entries).length == 0) {
                return Collections.emptyList();
            }
            ArrayList<ServiceLinkRuntime> result = new ArrayList<ServiceLinkRuntime>();
            int size = ((ServiceLinkRuntime[])this.entries).length;
            for (int i = 0; i < size; ++i) {
                ServiceLinkRuntime item = ((ServiceLinkRuntime[])this.entries)[i];
                if (!RangeUtils.inRange((long)date1, (long)date2, (long)item.timeFrom, (long)item.timeTo)) continue;
                result.add(item);
            }
            if (result.size() > 0) {
                return result;
            }
            return Collections.emptyList();
        }
    }

    public static class ServiceLinkRuntime
    extends AbstractPeriodItemSet.PeriodItem {
        public final ServiceSpecRuntime serviceSpecRuntime;

        public ServiceLinkRuntime(ServiceSpecRuntime serviceSpecRuntime, int id, long timeFrom, long timeTo) {
            super(id, timeFrom, timeTo);
            this.serviceSpecRuntime = serviceSpecRuntime;
        }
    }
}

