/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract.report;

import java.awt.BorderLayout;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.modules.voice.client.ServiceReportPanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;

public class SessionTableReport
extends BGUPanel {
    private ServiceReportPanel serviceReportPanel = null;
    private VoiceSessionTableModel tableModel = new VoiceSessionTableModel();
    private BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
    private VoiceDeviceService wsDevice = (VoiceDeviceService)((ClientContext)this.getContext()).getPort(VoiceDeviceService.class);
    private Map<Integer, VoiceDevice> deviceMap = new HashMap<Integer, VoiceDevice>();
    private Map<Integer, VoiceDestination> destMap = new HashMap<Integer, VoiceDestination>();
    private Map<Integer, Service> serviceMap = new HashMap<Integer, Service>();

    public SessionTableReport(ServiceReportPanel serviceReportPanel) {
        this.serviceReportPanel = serviceReportPanel;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane((Component)this.table));
    }

    public VoiceSessionTableModel getTableModel() {
        return this.tableModel;
    }

    public Map<Integer, VoiceDestination> getDestMap() {
        return this.destMap;
    }

    public void setDestMap(Map<Integer, VoiceDestination> destMap) {
        this.destMap = destMap;
    }

    public Map<Integer, Service> getServiceMap() {
        return this.serviceMap;
    }

    public class VoiceSessionTableModel
    extends BGTableModel<VoiceSession> {
        private List<Service> serviceList;
        private Map<Integer, Integer> columnSidMap;
        private int basicColumnCount;

        public VoiceSessionTableModel() {
            super("voiceSession");
            this.columnSidMap = new HashMap<Integer, Integer>();
        }

        protected void initColumns() {
            if (this.serviceList == null) {
                this.serviceList = Collections.emptyList();
            }
            this.addColumn("SessionId", 100, 110, 120, "id").setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0410\u043a\u043a\u0430\u0443\u043d\u0442", 100, 110, 120, "AccountTitle").setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", 50, 50, 50, null).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, -1, -1, null).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", -1, -1, -1, null, false, false);
            this.addColumn("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", -1, 150, -1, null, true, false);
            this.addColumn("A", -1, -1, -1, "callingStationId", false, false);
            this.addColumn("B", -1, -1, -1, "calledStationId", false, false);
            this.addColumn("A#e164", 100, 110, 120, "e164CallingStationId").setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("B#e164", 100, 110, 120, "e164CalledStationId").setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0440\u0442", Column.DateTime.class, 150, 160, 170, "sessionStart", false).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0442\u043e\u043f", Column.DateTime.class, 150, 160, 170, "sessionStop", false).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c", Column.DateTime.class, -1, -1, -1, "lastActive", false, false, false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS_LEFT());
            this.addColumn("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", String.class, 140, 150, 160, "sessionTime", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041e\u043a\u0440.\u0434\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", String.class, -1, -1, -1, "RoundedSessionTime", false, false, false, null);
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 100, 100, 100, "sessionCost").setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c.\u043c\u0438\u043d.", -1, -1, -1, "minuteCost", false, false);
            this.addColumn("\u0427\u0430\u0441", Column.DateTime.class, -1, -1, -1, "hour", false, false, false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS_LEFT());
            this.addColumn("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", -1, -1, -1, "identifier", false, false);
            this.addColumn("acctSessionId", -1, -1, -1, "acctSessionId", false, false);
            this.addColumn("C \u043f\u043e\u0440\u0442\u0430", -1, -1, -1, "fromPort", false, false);
            this.addColumn("\u041d\u0430 \u043f\u043e\u0440\u0442", -1, -1, -1, "toPort", false, false);
            this.basicColumnCount = this.getColumnCount();
            for (Service service : this.serviceList) {
                if (SessionTableReport.this.serviceReportPanel.getTimeCheckBox().isSelected()) {
                    this.addColumn(service.getTitle() + "(\u0412\u0440\u0435\u043c\u044f)", -1, -1, -1, "time", false);
                    this.columnSidMap.put(this.getColumnCount() - 1, service.getId());
                }
                if (!SessionTableReport.this.serviceReportPanel.getMoneyCheckBox().isSelected()) continue;
                this.addColumn(service.getTitle() + "(\u0421\u0443\u043c\u043c\u0430)", -1, -1, -1, "money", false);
                this.columnSidMap.put(this.getColumnCount() - 1, service.getId());
            }
        }

        public void reinitColumns() {
            this.serviceList = new ArrayList<Service>(SessionTableReport.this.serviceReportPanel.getServiceCheckList().getSelected());
            this.columnSidMap = new HashMap<Integer, Integer>(this.serviceList.size());
            super.reinitColumns();
            this.table.setModel((TableModel)((Object)new VoiceSessionTableModel()));
            this.table.setModel((TableModel)((Object)this));
            ((BGUTable)this.table).loadColumnProperties();
        }

        public Object getValue(VoiceSession val, int column) throws BGException {
            Object result = null;
            switch (column) {
                case 2: {
                    result = val.getCallType() == 1 ? ">>" : "<<";
                    break;
                }
                case 3: {
                    VoiceDestination dest = SessionTableReport.this.destMap.get(val.getDestinationId());
                    if (dest == null) break;
                    result = dest.getTitle();
                    break;
                }
                case 4: {
                    Service service = SessionTableReport.this.serviceMap.get(val.getServiceId());
                    if (service == null) break;
                    result = service.getTitle();
                    break;
                }
                case 5: {
                    result = "";
                    if (val.getDeviceId() <= 0) break;
                    VoiceDevice device = SessionTableReport.this.deviceMap.get(val.getDeviceId());
                    if (device == null) {
                        device = (VoiceDevice)SessionTableReport.this.wsDevice.deviceGet(val.getDeviceId());
                        SessionTableReport.this.deviceMap.put(val.getDeviceId(), device);
                    }
                    if (device == null) break;
                    result = device.getTitle();
                    break;
                }
                case 13: {
                    Long sessionTime = val.getSessionTime();
                    result = Utils.formatSessionTime2((int)sessionTime.intValue());
                    break;
                }
                case 14: {
                    Long sessionTime = val.getRoundedSessionTime();
                    result = Utils.formatSessionTime2((int)sessionTime.intValue());
                    break;
                }
                default: {
                    if (column >= this.basicColumnCount) {
                        int service = this.columnSidMap.get(column);
                        VoiceSessionAccount sessionAccount = (VoiceSessionAccount)val.getAccountMap().get(service);
                        if (sessionAccount != null) {
                            String columnName = this.getIdentifier(column);
                            if ("time".equals(columnName)) {
                                Long sessiontime = sessionAccount.getAmount();
                                result = Utils.formatSessionTime((int)sessiontime.intValue());
                            }
                            if (!"money".equals(columnName)) break;
                            result = Utils.formatSessionCost((BigDecimal)sessionAccount.getAccount());
                            break;
                        }
                        result = 0;
                        break;
                    }
                    result = super.getValue((Object)val, column);
                }
            }
            return result;
        }
    }
}

