/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountPort;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class VoiceAccountPortDao
extends AbstractIdDao<VoiceAccountPort> {
    public VoiceAccountPortDao(Connection con, int moduleId) {
        super(con, moduleId, "voice_account_port");
    }

    protected VoiceAccountPort getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceAccountPort result = new VoiceAccountPort();
        result.setId(rs.getInt("id"));
        result.setAccountId(rs.getInt("accountId"));
        result.setPort(rs.getString("port"));
        result.setOut(rs.getBoolean("is_out"));
        return result;
    }

    protected void updateImpl(VoiceAccountPort voiceAccountPort) throws BGException, SQLException {
        boolean update = voiceAccountPort.getId() > 0;
        String fields = " SET accountId = ?, port = ?, is_out = ? ";
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + fields + (update ? " WHERE id = ?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int i = this.setParams(voiceAccountPort, ps, 1);
            if (update) {
                ps.setInt(i++, voiceAccountPort.getId());
            }
            ps.executeQuery();
            if (!update) {
                voiceAccountPort.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    private int setParams(VoiceAccountPort b, PreparedStatement ps, int index) throws SQLException {
        ps.setInt(index++, b.getAccountId());
        ps.setString(index++, b.getPort());
        ps.setBoolean(index++, b.isOut());
        return index;
    }

    public List<VoiceAccountPort> list(int accountId) throws BGException {
        return this.list("accountId=?", "port", new Object[]{accountId});
    }

    public List<VoiceAccountPort> list(int accountId, boolean out) throws BGException {
        return this.list("accountId=? and is_out = ?", "port", new Object[]{accountId, out});
    }

    public void update(int accountId, List<VoiceAccountPort> ports) throws BGException {
        this.delete("accountId = ?", new Object[]{accountId});
        if (ports.size() == 0) {
            return;
        }
        String quastions = "?,?,?";
        StringBuffer query = new StringBuffer(ports.size() * 4);
        query.append("INSERT INTO " + this.tableName + "( accountId, port, is_out ) VALUES ");
        query.append(ports.stream().map(v -> "(" + quastions + ")").collect(Collectors.joining(",")));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int idx = 1;
            for (VoiceAccountPort port : ports) {
                idx = this.setParams(port, ps, idx);
            }
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

