/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZone;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMapItem;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceZoneDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceGeographicCodeDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceZoneMapItemDao;
import ru.bitel.bgbilling.modules.voice.server.event.GeoCodeUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceZoneMapUpdateEvent;
import ru.bitel.common.XMLUtils;

public class ZoneMapImportManager {
    private static final Logger logger = LogManager.getLogger();
    private VoiceZoneMapItemDao zoneMapItemDao;
    private VoiceGeographicCodeDao codeDao;
    private int moduleId;
    private int userId;
    private Map<String, Integer> codeMap;
    private Connection con;

    public ZoneMapImportManager(Connection con, int moduleId, int userId) throws BGException {
        this.con = con;
        this.zoneMapItemDao = new VoiceZoneMapItemDao(con, moduleId);
        this.codeDao = new VoiceGeographicCodeDao(con, moduleId);
        this.moduleId = moduleId;
        this.userId = userId;
    }

    public String importZoneMap(int zoneMapId, int mode, Holder<DataHandler> importContent) throws BGException {
        int operatorId = 0;
        boolean needEvent = false;
        StringBuilder result = new StringBuilder();
        this.getCodeMap(operatorId);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             VoiceZoneDao zoneDAO = new VoiceZoneDao(this.con, this.moduleId);){
            ((DataHandler)importContent.value).writeTo((OutputStream)baos);
            if (mode == 0) {
                String content = new String(baos.toByteArray());
                for (String line : content.split("\n")) {
                    String code;
                    String zoneTitle;
                    int zoneId;
                    String[] lineData = line.split("\t");
                    if (lineData.length != 2 || !this.updateCode(operatorId, zoneMapId, zoneId = this.getZoneId(zoneDAO, zoneTitle = lineData[1]), code = lineData[0], zoneTitle, result)) continue;
                    needEvent = true;
                }
            } else if (mode == 1) {
                Document doc = XMLUtils.parseDocument((byte[])baos.toByteArray());
                NodeList zones = doc.getDocumentElement().getElementsByTagName("zone");
                for (int i = 0; i < zones.getLength(); ++i) {
                    Element zone = (Element)zones.item(i);
                    String zoneTitle = zone.getAttribute("name");
                    int zoneId = this.getZoneId(zoneDAO, zoneTitle);
                    NodeList codes = zone.getElementsByTagName("code");
                    for (int j = 0; j < codes.getLength(); ++j) {
                        Element codeElement = (Element)codes.item(j);
                        String code = codeElement.getAttribute("id");
                        if (!this.updateCode(operatorId, zoneMapId, zoneId, code, zoneTitle, result)) continue;
                        needEvent = true;
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438! \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u0435\u0435 \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0432 \u043b\u043e\u0433\u0430\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.");
        }
        if (needEvent) {
            EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, zoneMapId));
        }
        logger.info("result=>" + result);
        return result.toString();
    }

    private int getZoneId(VoiceZoneDao zoneDAO, String zoneTitle) throws BGException {
        VoiceZone vZone = zoneDAO.get(zoneTitle);
        if (vZone == null) {
            vZone = new VoiceZone();
            vZone.setTitle(zoneTitle);
            zoneDAO.update(vZone);
        }
        return vZone.getId();
    }

    private boolean updateCode(int operatorId, int zoneMapId, int zoneId, String code, String zoneTitle, StringBuilder result) throws BGException {
        Integer codeId = this.getCodeMap(operatorId).get(code);
        if (codeId == null || codeId <= 0) {
            result.append("\u043d\u0435\u0442 \u043a\u043e\u0434\u0430 => " + code + " \t " + zoneTitle + "\n");
            return false;
        }
        VoiceZoneMapItem item = this.zoneMapItemDao.get(zoneMapId, code);
        if (item == null) {
            item = new VoiceZoneMapItem();
            item.setMapId(zoneMapId);
            item.setCodeId(codeId.intValue());
        }
        item.setZoneId(zoneId);
        this.zoneMapItemDao.update(item);
        return true;
    }

    private Map<String, Integer> getCodeMap(int operatorId) throws BGException {
        if (this.codeMap == null) {
            List<VoiceGeographicCode> list = this.codeDao.list(-1, operatorId);
            this.codeMap = new HashMap<String, Integer>();
            for (VoiceGeographicCode code : list) {
                this.codeMap.put(code.getCode(), code.getId());
            }
        }
        return this.codeMap;
    }
}

