/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class VoiceIpSessionUtils {
    private Connection con;
    private int mid = -1;

    public VoiceIpSessionUtils(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public void setContractAccountFromSession(Calendar time, int cid, int sid) {
        String logSessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)time.getTime(), (int)this.mid);
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            String query = "SELECT SUM(session_cost) FROM " + logSessionTableName + " WHERE cid=? AND sid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, sid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                float sum = rs.getFloat(1);
                bu.setContractAccount(cid, time.getTime(), sid, sum);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setContractAccountFromSession(Calendar time, int cid) {
        String logSessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)time.getTime(), (int)this.mid);
        if (ServerUtils.tableExists((Connection)this.con, (String)logSessionTableName)) {
            try (BalanceUtils bu = new BalanceUtils(this.con);){
                String query = "SELECT sid, SUM(session_cost) FROM " + logSessionTableName + " WHERE cid=? GROUP BY sid";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int sid = rs.getInt(1);
                    float sum = rs.getFloat(2);
                    bu.setContractAccount(cid, time.getTime(), sid, sum);
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

