/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.servlet;

import java.io.IOException;
import java.sql.Connection;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankCheckEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="AlfabankExecutor", urlPatterns={"/alfabank/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String PARAM_MD_ORDER = "mdOrder";
    private static final String PARAM_ORDER_NUMBER = "orderNumber";
    private static final Logger log = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection con = null;
        TransactionManager transactionManager = null;
        try {
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            con = Setup.getSetup().getDBConnectionFromPool();
            String orderNumber = request.getParameter(PARAM_ORDER_NUMBER);
            String transactionId = request.getParameter(PARAM_MD_ORDER);
            transactionManager = new TransactionManager(con, moduleId);
            Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderNumber));
            if (transaction == null) {
                log.error("Not found transaction for ID = {}", (Object)orderNumber);
                return;
            }
            if (!transaction.getTransactionId().equals(transactionId)) {
                log.error("Transaction for ID = {} ( {} != {} )", (Object)orderNumber, (Object)transaction.getTransactionId(), (Object)transactionId);
                return;
            }
            try {
                EventProcessor.getInstance().publish((Event)new AlfabankCheckEvent(moduleId, transaction.getContractId(), transaction.isAutopayment()));
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
        catch (BGException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.recycle();
                }
                catch (BGException e) {
                    e.printStackTrace();
                }
            }
            ServerUtils.closeConnection((Connection)con);
        }
    }
}

