/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.assist.client.AssistPaymentEditor;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;

public class ServiceConfigPayments
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGControlPanelListSelect groupsPanel = new BGControlPanelListSelect();
    private BGTextField orderId = new BGTextField();
    private BGTextField contract = new BGTextField();
    private BGTextField cardName = new BGTextField();
    private BGTextField cardText = new BGTextField();
    private BGTextField billnumber = new BGTextField();
    private BGComboBox<ComboBoxItem> status = new BGComboBox();
    private AssistPaymentEditor editor = new AssistPaymentEditor();
    private BGControlPanelPeriodNoB periodSetStatuses = new BGControlPanelPeriodNoB();

    public ServiceConfigPayments() {
        this.jbInit();
        this.table.setHeader(this.rb_name, this.moduleDoc, "assist_payment");
        this.editor.setVisible(false);
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        this.editor.init(module, mid);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.groupsPanel.setBorder((Border)new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b "));
        this.groupsPanel.setPreferredSize(new Dimension(220, 335));
        this.groupsPanel.setMinimumSize(new Dimension(220, 335));
        Calendar now = Calendar.getInstance();
        this.period.setDateCalendar1(TimeUtils.getStartMonth((Calendar)now));
        this.period.setDateCalendar2(TimeUtils.getEndMonth((Calendar)now));
        this.orderId.setColumns(10);
        this.contract.setColumns(10);
        this.cardText.setColumns(10);
        this.cardName.setColumns(10);
        this.billnumber.setColumns(10);
        this.status.addItem((Object)new ComboBoxItem((Object)(AssistStatus.OK.toString() + "," + AssistStatus.NEW.toString() + "," + AssistStatus.FAIL.toString()), "\u0432\u0441\u0435"));
        this.status.addItem((Object)new ComboBoxItem((Object)AssistStatus.OK.toString(), AssistStatus.OK.getTitle()));
        this.status.addItem((Object)new ComboBoxItem((Object)AssistStatus.FAIL.toString(), AssistStatus.FAIL.getTitle()));
        this.status.addItem((Object)new ComboBoxItem((Object)AssistStatus.NEW.toString(), AssistStatus.NEW.getTitle()));
        BGButton filterSet = new BGButton("\u041f\u043e\u0438\u0441\u043a");
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        topPanel.add((Component)new JLabel("ID"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.orderId, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.contract, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u041a\u0430\u0440\u0442\u0430"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.cardText, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u0414\u0435\u0440\u0436\u0430\u0442\u0435\u043b\u044c/\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.cardName, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        topPanel.add((Component)new JLabel("#billnumber"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.billnumber, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.status, new GridBagConstraints(5, 1, 1, 2, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.period, new GridBagConstraints(6, 1, 1, 2, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(7, 1, 1, 2, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        topPanel.add((Component)filterSet, new GridBagConstraints(8, 1, 1, 2, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.groupsPanel, new GridBagConstraints(0, 0, 1, 3, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add(topPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.editor), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        filterSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigPayments.this.getPayments();
            }
        });
        this.editor.setActionSaved(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigPayments.this.editor.setVisible(false);
                ServiceConfigPayments.this.getPayments();
            }
        });
        this.editor.setActionCanceled(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigPayments.this.editor.setVisible(false);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceConfigPayments.this.editItem();
                }
            }
        });
        JMenuItem mi = new JMenuItem("\u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigPayments.this.doGetPaymentStatus();
            }
        });
        mi.setActionCommand("doGetPaymentStatus");
        this.table.getPopupMenu().add(mi);
        this.periodSetStatuses.setDateCalendar1(TimeUtils.plusPeriod((Calendar)now, (int)5, (int)-2));
        this.periodSetStatuses.setDateCalendar2(now);
    }

    private void doGetPaymentStatus() {
        String rowid = ClientUtils.getRowId((BGTable)this.table);
        if (rowid != null) {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("PayResult");
            req.setModuleId(this.getModuleId());
            req.setAttribute("ordernumber", rowid);
            Document doc = TransferManager.getDocument((Request)req);
            if (ClientUtils.checkStatus((Document)doc)) {
                String result = XMLUtils.selectText((Node)doc, (String)"/data/@result");
                AssistStatus resultStatus = AssistStatus.valueOf((String)result);
                String message = XMLUtils.selectText((Node)doc, (String)"/data/message/text()");
                String exception = XMLUtils.selectText((Node)doc, (String)"/data/exception/text()");
                StringBuilder sb = new StringBuilder();
                sb.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: ").append(result);
                if (resultStatus != null) {
                    sb.append(" (").append(resultStatus.getTitle()).append(")");
                }
                sb.append("\n\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: ").append(message);
                if (exception != null) {
                    sb.append("\nException: ").append(exception);
                }
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), sb.toString());
                this.getPayments();
            }
        }
    }

    public void setData() {
        if (!this.init) {
            this.init();
            this.init = true;
        }
    }

    private void init() {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("ListGroups");
        Document doc = TransferManager.getDocument((Request)req);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList((BGControlPanelListSelect)this.groupsPanel, (Node)XMLUtils.selectNode((Node)doc, (String)"/data/groups"));
        }
    }

    public void getPayments() {
        Document doc;
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("PayList");
        req.setModuleId(this.getModuleId());
        req.setAttribute("f_gr", this.groupsPanel.getListValues());
        req.setPeriod(this.period.getPeriod());
        req.setAttribute("f_orderid", this.orderId.getText());
        req.setAttribute("f_contract", this.contract.getText());
        req.setAttribute("f_cardname", this.cardName.getText());
        req.setAttribute("f_cardtext", this.cardText.getText());
        req.setAttribute("f_billnumber", this.billnumber.getText());
        ComboBoxItem item = (ComboBoxItem)this.status.getSelectedItem();
        if (item != null) {
            req.setAttribute("status", String.valueOf(item.getObject()));
        }
        if (ClientUtils.checkStatus((Document)(doc = TransferManager.getDocument((Request)req)))) {
            this.table.updateData(XMLUtils.selectNode((Node)doc, (String)"/data/table"));
        }
    }

    public void editItem() {
        String rowid = ClientUtils.getRowId((BGTable)this.table);
        if (rowid != null) {
            this.editor.setData(rowid);
            this.editor.setVisible(true);
        }
    }
}

